/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.regionserver.CompactionTool;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class, RegionServerTests.class})
public class TestCompactionToolNpeFix {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestCompactionToolNpeFix.class);
    private static final HBaseTestingUtility TESTUTIL = new HBaseTestingUtility();
    private HRegion region;
    private static final byte[] qualifier = Bytes.toBytes((String)"qf");
    private static Path rootDir;
    private final TableName tableName = TableName.valueOf((String)this.getClass().getSimpleName());

    @BeforeClass
    public static void setUpAfterClass() throws Exception {
        TESTUTIL.getConfiguration().setBoolean("hbase.hregion.memstore.mslab.enabled", false);
        TESTUTIL.startMiniCluster();
        rootDir = TESTUTIL.getDefaultRootDirPath();
        TESTUTIL.startMiniMapReduceCluster();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        TESTUTIL.shutdownMiniMapReduceCluster();
        TESTUTIL.shutdownMiniCluster();
        TESTUTIL.cleanupTestDir();
    }

    @Before
    public void setUp() throws IOException {
        TESTUTIL.createTable(this.tableName, HBaseTestingUtility.fam1);
        this.region = (HRegion)TESTUTIL.getMiniHBaseCluster().getRegions(this.tableName).get(0);
    }

    @After
    public void after() throws IOException {
        TESTUTIL.deleteTable(this.tableName);
    }

    private void putAndFlush(int key) throws Exception {
        Put put = new Put(Bytes.toBytes((int)key));
        put.addColumn(HBaseTestingUtility.fam1, qualifier, Bytes.toBytes((String)("val" + key)));
        this.region.put(put);
        TESTUTIL.flush(this.tableName);
    }

    private HStore prepareStoreWithMultiFiles() throws Exception {
        for (int i = 0; i < 5; ++i) {
            this.putAndFlush(i);
        }
        HStore store = this.region.getStore(HBaseTestingUtility.fam1);
        Assert.assertEquals((long)5L, (long)store.getStorefilesCount());
        return store;
    }

    @Test
    public void testCompactedFilesArchived() throws Exception {
        HStore store = this.prepareStoreWithMultiFiles();
        Path tableDir = CommonFSUtils.getTableDir((Path)rootDir, (TableName)this.region.getRegionInfo().getTable());
        FileSystem fs = store.getFileSystem();
        String storePath = tableDir + "/" + this.region.getRegionInfo().getEncodedName() + "/" + Bytes.toString((byte[])HBaseTestingUtility.fam1);
        FileStatus[] regionDirFiles = fs.listStatus(new Path(storePath));
        Assert.assertEquals((long)5L, (long)regionDirFiles.length);
        String defaultFS = TESTUTIL.getMiniHBaseCluster().getConfiguration().get("fs.defaultFS");
        Configuration config = HBaseConfiguration.create();
        config.set("fs.defaultFS", defaultFS);
        int result = ToolRunner.run((Configuration)config, (Tool)new CompactionTool(), (String[])new String[]{"-compactOnce", "-major", storePath});
        Assert.assertEquals((long)0L, (long)result);
        regionDirFiles = fs.listStatus(new Path(storePath));
        Assert.assertEquals((long)1L, (long)regionDirFiles.length);
    }

    @Test
    public void testCompactedFilesArchivedMapRed() throws Exception {
        HStore store = this.prepareStoreWithMultiFiles();
        Path tableDir = CommonFSUtils.getTableDir((Path)rootDir, (TableName)this.region.getRegionInfo().getTable());
        FileSystem fs = store.getFileSystem();
        String storePath = tableDir + "/" + this.region.getRegionInfo().getEncodedName() + "/" + Bytes.toString((byte[])HBaseTestingUtility.fam1);
        FileStatus[] regionDirFiles = fs.listStatus(new Path(storePath));
        Assert.assertEquals((long)5L, (long)regionDirFiles.length);
        String defaultFS = TESTUTIL.getMiniHBaseCluster().getConfiguration().get("fs.defaultFS");
        Configuration config = HBaseConfiguration.create((Configuration)TESTUTIL.getConfiguration());
        config.setBoolean("hbase.hregion.memstore.mslab.enabled", true);
        config.set("fs.defaultFS", defaultFS);
        int result = ToolRunner.run((Configuration)config, (Tool)new CompactionTool(), (String[])new String[]{"-compactOnce", "-mapred", "-major", storePath});
        Assert.assertEquals((long)0L, (long)result);
        regionDirFiles = fs.listStatus(new Path(storePath));
        Assert.assertEquals((long)1L, (long)regionDirFiles.length);
    }
}

