/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.NavigableMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.MultiTableInputFormatBase;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.hbase.mapreduce.TestMultiTableInputFormat;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MultiTableInputFormatTestBase {
    static final Logger LOG = LoggerFactory.getLogger(TestMultiTableInputFormat.class);
    public static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    static final String TABLE_NAME = "scantest";
    static final byte[] INPUT_FAMILY = Bytes.toBytes((String)"contents");
    static final String KEY_STARTROW = "startRow";
    static final String KEY_LASTROW = "stpRow";
    static List<String> TABLES = Lists.newArrayList();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.enableDebug(MultiTableInputFormatBase.class);
        TEST_UTIL.startMiniCluster(3);
        for (String tableName : TABLES) {
            Table table = TEST_UTIL.createMultiRegionTable(TableName.valueOf((String)tableName), INPUT_FAMILY, 4);
            Throwable throwable = null;
            try {
                TEST_UTIL.loadTable(table, INPUT_FAMILY, false);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (table == null) continue;
                if (throwable != null) {
                    try {
                        table.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                table.close();
            }
        }
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @After
    public void tearDown() throws Exception {
        Configuration c = TEST_UTIL.getConfiguration();
        FileUtil.fullyDelete((File)new File(c.get("hadoop.tmp.dir")));
    }

    @Test
    public void testScanEmptyToEmpty() throws IOException, InterruptedException, ClassNotFoundException {
        this.testScan(null, null, null);
    }

    @Test
    public void testScanEmptyToAPP() throws IOException, InterruptedException, ClassNotFoundException {
        this.testScan(null, "app", "apo");
    }

    @Test
    public void testScanOBBToOPP() throws IOException, InterruptedException, ClassNotFoundException {
        this.testScan("obb", "opp", "opo");
    }

    @Test
    public void testScanYZYToEmpty() throws IOException, InterruptedException, ClassNotFoundException {
        this.testScan("yzy", null, "zzz");
    }

    private void testScan(String start, String stop, String last) throws IOException, InterruptedException, ClassNotFoundException {
        String jobName = "Scan" + (start != null ? start.toUpperCase(Locale.ROOT) : "Empty") + "To" + (stop != null ? stop.toUpperCase(Locale.ROOT) : "Empty");
        LOG.info("Before map/reduce startup - job " + jobName);
        Configuration c = new Configuration(TEST_UTIL.getConfiguration());
        c.set(KEY_STARTROW, start != null ? start : "");
        c.set(KEY_LASTROW, last != null ? last : "");
        ArrayList<Scan> scans = new ArrayList<Scan>();
        for (String tableName : TABLES) {
            Scan scan = new Scan();
            scan.addFamily(INPUT_FAMILY);
            scan.setAttribute("scan.attributes.table.name", Bytes.toBytes((String)tableName));
            if (start != null) {
                scan.setStartRow(Bytes.toBytes((String)start));
            }
            if (stop != null) {
                scan.setStopRow(Bytes.toBytes((String)stop));
            }
            scans.add(scan);
            LOG.info("scan before: " + scan);
        }
        this.runJob(jobName, c, scans);
    }

    protected void runJob(String jobName, Configuration c, List<Scan> scans) throws IOException, InterruptedException, ClassNotFoundException {
        Job job = new Job(c, jobName);
        this.initJob(scans, job);
        job.setReducerClass(ScanReducer.class);
        job.setNumReduceTasks(1);
        FileOutputFormat.setOutputPath((Job)job, (Path)new Path(job.getJobName()));
        LOG.info("Started " + job.getJobName());
        job.waitForCompletion(true);
        Assert.assertTrue((boolean)job.isSuccessful());
        LOG.info("After map/reduce completion - job " + jobName);
    }

    protected abstract void initJob(List<Scan> var1, Job var2) throws IOException;

    static {
        for (int i = 0; i < 3; ++i) {
            TABLES.add(TABLE_NAME + String.valueOf(i));
        }
    }

    public static class ScanReducer
    extends Reducer<ImmutableBytesWritable, ImmutableBytesWritable, NullWritable, NullWritable> {
        private String first = null;
        private String last = null;

        protected void reduce(ImmutableBytesWritable key, Iterable<ImmutableBytesWritable> values, Reducer.Context context) throws IOException, InterruptedException {
            this.makeAssertions(key, values);
        }

        protected void makeAssertions(ImmutableBytesWritable key, Iterable<ImmutableBytesWritable> values) {
            int count = 0;
            for (ImmutableBytesWritable value : values) {
                String val = Bytes.toStringBinary((byte[])value.get());
                LOG.debug("reduce: key[" + count + "] -> " + Bytes.toStringBinary((byte[])key.get()) + ", value -> " + val);
                if (this.first == null) {
                    this.first = val;
                }
                this.last = val;
                ++count;
            }
            Assert.assertEquals((long)3L, (long)count);
        }

        protected void cleanup(Reducer.Context context) throws IOException, InterruptedException {
            Configuration c = context.getConfiguration();
            this.cleanup(c);
        }

        protected void cleanup(Configuration c) {
            String startRow = c.get(MultiTableInputFormatTestBase.KEY_STARTROW);
            String lastRow = c.get(MultiTableInputFormatTestBase.KEY_LASTROW);
            LOG.info("cleanup: first -> \"" + this.first + "\", start row -> \"" + startRow + "\"");
            LOG.info("cleanup: last -> \"" + this.last + "\", last row -> \"" + lastRow + "\"");
            if (startRow != null && startRow.length() > 0) {
                Assert.assertEquals((Object)startRow, (Object)this.first);
            }
            if (lastRow != null && lastRow.length() > 0) {
                Assert.assertEquals((Object)lastRow, (Object)this.last);
            }
        }
    }

    public static class ScanMapper
    extends TableMapper<ImmutableBytesWritable, ImmutableBytesWritable> {
        public void map(ImmutableBytesWritable key, Result value, Mapper.Context context) throws IOException, InterruptedException {
            this.makeAssertions(key, value);
            context.write((Object)key, (Object)key);
        }

        public void makeAssertions(ImmutableBytesWritable key, Result value) throws IOException {
            if (value.size() != 1) {
                throw new IOException("There should only be one input column");
            }
            NavigableMap cf = value.getMap();
            if (!cf.containsKey(INPUT_FAMILY)) {
                throw new IOException("Wrong input columns. Missing: '" + Bytes.toString((byte[])INPUT_FAMILY) + "'.");
            }
            String val = Bytes.toStringBinary((byte[])value.getValue(INPUT_FAMILY, null));
            LOG.debug("map: key -> " + Bytes.toStringBinary((byte[])key.get()) + ", value -> " + val);
        }
    }
}

