/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coprocessor.example;

import java.io.IOException;
import java.util.Optional;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionObserver;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class ScanModifyingObserver
implements RegionCoprocessor,
RegionObserver {
    public static final String FAMILY_TO_ADD_KEY = "hbase.examples.coprocessor.scanmodifying.family";
    public static final String QUALIFIER_TO_ADD_KEY = "hbase.examples.coprocessor.scanmodifying.qualifier";
    private byte[] FAMILY_TO_ADD = null;
    private byte[] QUALIFIER_TO_ADD = null;

    public void start(CoprocessorEnvironment env) throws IOException {
        RegionCoprocessorEnvironment renv = (RegionCoprocessorEnvironment)env;
        this.FAMILY_TO_ADD = Bytes.toBytes((String)renv.getConfiguration().get(FAMILY_TO_ADD_KEY));
        this.QUALIFIER_TO_ADD = Bytes.toBytes((String)renv.getConfiguration().get(QUALIFIER_TO_ADD_KEY));
    }

    public Optional<RegionObserver> getRegionObserver() {
        return Optional.of(this);
    }

    public void preScannerOpen(ObserverContext<RegionCoprocessorEnvironment> c, Scan scan) throws IOException {
        scan.addColumn(this.FAMILY_TO_ADD, this.QUALIFIER_TO_ADD);
    }
}

