/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.token;

import java.io.File;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseCommonTestingUtility;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.LocalHBaseCluster;
import org.apache.hadoop.hbase.security.HBaseKerberosUtils;
import org.apache.hadoop.hbase.security.token.TokenProvider;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.minikdc.MiniKdc;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.AfterClass;
import org.junit.BeforeClass;

public class SecureTestCluster {
    protected static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    protected static String USERNAME;
    private static LocalHBaseCluster CLUSTER;
    private static final File KEYTAB_FILE;
    private static MiniKdc KDC;
    private static String HOST;
    private static String PRINCIPAL;
    private static String HTTP_PRINCIPAL;
    private static Class testRunnerClass;

    protected static void setTestRunner(Class testRunnerClass) {
        SecureTestCluster.testRunnerClass = testRunnerClass;
    }

    @BeforeClass
    public static void setUp() throws Exception {
        KDC = TEST_UTIL.setupMiniKdc(KEYTAB_FILE);
        USERNAME = UserGroupInformation.getLoginUser().getShortUserName();
        PRINCIPAL = USERNAME + "/" + HOST;
        HTTP_PRINCIPAL = "HTTP/" + HOST;
        KDC.createPrincipal(KEYTAB_FILE, new String[]{PRINCIPAL, HTTP_PRINCIPAL});
        TEST_UTIL.startMiniZKCluster();
        HBaseKerberosUtils.setSecuredConfiguration((Configuration)TEST_UTIL.getConfiguration(), (String)(PRINCIPAL + "@" + KDC.getRealm()), (String)(HTTP_PRINCIPAL + "@" + KDC.getRealm()));
        HBaseKerberosUtils.setSSLConfiguration((HBaseCommonTestingUtility)TEST_UTIL, (Class)testRunnerClass);
        TEST_UTIL.getConfiguration().setStrings("hbase.coprocessor.region.classes", new String[]{TokenProvider.class.getName()});
        TEST_UTIL.startMiniDFSCluster(1);
        Path rootdir = TEST_UTIL.getDataTestDirOnTestFS("TestGenerateDelegationToken");
        CommonFSUtils.setRootDir((Configuration)TEST_UTIL.getConfiguration(), (Path)rootdir);
        CLUSTER = new LocalHBaseCluster(TEST_UTIL.getConfiguration(), 1);
        CLUSTER.startup();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        try {
            if (CLUSTER != null) {
                CLUSTER.shutdown();
            }
            CLUSTER.join();
            if (KDC != null) {
                KDC.stop();
            }
            TEST_UTIL.shutdownMiniCluster();
        }
        finally {
            SecureTestCluster.setTestRunner(SecureTestCluster.class);
        }
    }

    static {
        KEYTAB_FILE = new File(TEST_UTIL.getDataTestDir("keytab").toUri().getPath());
        HOST = "localhost";
        testRunnerClass = SecureTestCluster.class;
    }
}

