/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.io.DeallocateRewriteByteBuffAllocator;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.RSRpcServices;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hbase.thirdparty.com.google.protobuf.RpcController;
import org.apache.hbase.thirdparty.com.google.protobuf.ServiceException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={RegionServerTests.class, LargeTests.class})
public class TestRegionServerScan {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRegionServerScan.class);
    @Rule
    public TestName name = new TestName();
    private static final byte[] CF = Bytes.toBytes((String)"CF");
    private static final byte[] CQ = Bytes.toBytes((String)"CQ");
    private static final byte[] VALUE = new byte[1200];
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final Configuration conf = TEST_UTIL.getConfiguration();
    private static Admin admin = null;
    static final TableName tableName = TableName.valueOf((String)"TestRegionServerScan");
    static final byte[] r0 = Bytes.toBytes((String)"row-0");
    static final byte[] r1 = Bytes.toBytes((String)"row-1");
    static final byte[] r2 = Bytes.toBytes((String)"row-2");

    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        conf.set("hbase.bytebuff.allocator.class", DeallocateRewriteByteBuffAllocator.class.getName());
        conf.setBoolean("hbase.server.allocator.pool.enabled", true);
        conf.setInt("hbase.server.allocator.minimal.allocate.size", 0);
        conf.setInt("hbase.bucketcache.writer.threads", 20);
        conf.setInt("hbase.server.allocator.buffer.size", 2048);
        conf.set("hbase.bucketcache.ioengine", "offheap");
        conf.setInt("hbase.bucketcache.size", 64);
        conf.setStrings("hbase.regionserver.impl", new String[]{MyRegionServer.class.getName()});
        conf.setInt("hbase.rpc.timeout", 1800000);
        conf.setInt("hbase.client.scanner.timeout.period", 1800000);
        conf.setInt("hbase.client.operation.timeout", 3600000);
        conf.setInt("hbase.client.retries.number", 1);
        conf.setInt("hbase.client.pause", 10000);
        conf.setLong("hbase.storescanner.pread.max.bytes", 0x40000000L);
        TEST_UTIL.startMiniCluster(1);
        admin = TEST_UTIL.getAdmin();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testScannWhenRpcCallContextNull() throws Exception {
        ResultScanner resultScanner = null;
        Table table = null;
        try {
            table = TEST_UTIL.createTable(tableName, (byte[][])new byte[][]{CF}, 1, 1024, null);
            TestRegionServerScan.putToTable(table, r0);
            TestRegionServerScan.putToTable(table, r1);
            TestRegionServerScan.putToTable(table, r2);
            admin.flush(table.getName());
            Scan scan = new Scan();
            scan.setCaching(2);
            scan.withStartRow(r0, true).withStopRow(r2, true);
            MyRSRpcServices.inTest = true;
            resultScanner = table.getScanner(scan);
            Result result = resultScanner.next();
            byte[] rowKey = result.getRow();
            Assert.assertTrue((boolean)Bytes.equals((byte[])r0, (byte[])rowKey));
            result = resultScanner.next();
            rowKey = result.getRow();
            Assert.assertTrue((boolean)Bytes.equals((byte[])r1, (byte[])rowKey));
            result = resultScanner.next();
            rowKey = result.getRow();
            Assert.assertTrue((boolean)Bytes.equals((byte[])r2, (byte[])rowKey));
            Assert.assertNull((Object)resultScanner.next());
            Assert.assertTrue((MyRSRpcServices.exceptionRef.get() == null ? 1 : 0) != 0);
        }
        finally {
            MyRSRpcServices.inTest = false;
            if (resultScanner != null) {
                resultScanner.close();
            }
            if (table != null) {
                table.close();
            }
        }
    }

    private static void putToTable(Table table, byte[] rowkey) throws IOException {
        Put put = new Put(rowkey);
        put.addColumn(CF, CQ, VALUE);
        table.put(put);
    }

    private static class MyRSRpcServices
    extends RSRpcServices {
        private static AtomicReference<Throwable> exceptionRef = new AtomicReference<Object>(null);
        private static volatile boolean inTest = false;

        public MyRSRpcServices(HRegionServer rs) throws IOException {
            super(rs);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ClientProtos.ScanResponse scan(RpcController controller, ClientProtos.ScanRequest request) throws ServiceException {
            try {
                if (!inTest) {
                    return super.scan(controller, request);
                }
                HRegion region = null;
                if (request.hasRegion()) {
                    region = this.getRegion(request.getRegion());
                }
                if (region != null && !tableName.equals((Object)region.getTableDescriptor().getTableName())) {
                    return super.scan(controller, request);
                }
                ClientProtos.ScanResponse result = null;
                Optional rpcCall = RpcServer.unsetCurrentCall();
                try {
                    result = super.scan(controller, request);
                }
                finally {
                    rpcCall.ifPresent(RpcServer::setCurrentCall);
                }
                return result;
            }
            catch (Throwable e) {
                exceptionRef.set(e);
                throw new ServiceException(e);
            }
        }
    }

    private static class MyRegionServer
    extends MiniHBaseCluster.MiniHBaseClusterRegionServer {
        public MyRegionServer(Configuration conf) throws IOException, InterruptedException {
            super(conf);
        }

        protected RSRpcServices createRpcServices() throws IOException {
            return new MyRSRpcServices(this);
        }
    }
}

