/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas;

import java.io.IOException;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.quotas.GlobalQuotaSettingsImpl;
import org.apache.hadoop.hbase.quotas.QuotaSettings;
import org.apache.hadoop.hbase.quotas.SpaceLimitSettings;
import org.apache.hadoop.hbase.quotas.SpaceViolationPolicy;
import org.apache.hadoop.hbase.quotas.ThrottleSettings;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.QuotaProtos;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestGlobalQuotaSettingsImpl {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestGlobalQuotaSettingsImpl.class);
    QuotaProtos.TimedQuota REQUEST_THROTTLE = QuotaProtos.TimedQuota.newBuilder().setScope(QuotaProtos.QuotaScope.MACHINE).setSoftLimit(100L).setTimeUnit(HBaseProtos.TimeUnit.MINUTES).build();
    QuotaProtos.Throttle THROTTLE = QuotaProtos.Throttle.newBuilder().setReqNum(this.REQUEST_THROTTLE).build();
    QuotaProtos.SpaceQuota SPACE_QUOTA = QuotaProtos.SpaceQuota.newBuilder().setSoftLimit(0x100000L).setViolationPolicy(QuotaProtos.SpaceViolationPolicy.NO_WRITES).build();

    @Test
    public void testMergeThrottle() throws IOException {
        QuotaProtos.Quotas quota = QuotaProtos.Quotas.newBuilder().setThrottle(this.THROTTLE).build();
        QuotaProtos.TimedQuota writeQuota = this.REQUEST_THROTTLE.toBuilder().setSoftLimit(500L).build();
        QuotaProtos.ThrottleRequest writeThrottle = QuotaProtos.ThrottleRequest.newBuilder().setTimedQuota(writeQuota).setType(QuotaProtos.ThrottleType.WRITE_NUMBER).build();
        GlobalQuotaSettingsImpl settings = new GlobalQuotaSettingsImpl("joe", null, null, null, quota);
        GlobalQuotaSettingsImpl merged = settings.merge((QuotaSettings)new ThrottleSettings("joe", null, null, null, writeThrottle));
        QuotaProtos.Throttle mergedThrottle = merged.getThrottleProto();
        Assert.assertTrue((boolean)mergedThrottle.hasReqNum());
        QuotaProtos.TimedQuota actualReqNum = mergedThrottle.getReqNum();
        Assert.assertEquals((long)this.REQUEST_THROTTLE.getSoftLimit(), (long)actualReqNum.getSoftLimit());
        Assert.assertTrue((boolean)mergedThrottle.hasWriteNum());
        QuotaProtos.TimedQuota actualWriteNum = mergedThrottle.getWriteNum();
        Assert.assertEquals((long)writeQuota.getSoftLimit(), (long)actualWriteNum.getSoftLimit());
    }

    @Test
    public void testMergeSpace() throws IOException {
        TableName tn = TableName.valueOf((String)"foo");
        QuotaProtos.Quotas quota = QuotaProtos.Quotas.newBuilder().setSpace(this.SPACE_QUOTA).build();
        GlobalQuotaSettingsImpl settings = new GlobalQuotaSettingsImpl(null, tn, null, null, quota);
        GlobalQuotaSettingsImpl merged = settings.merge((QuotaSettings)new SpaceLimitSettings(tn, this.SPACE_QUOTA.getSoftLimit(), SpaceViolationPolicy.DISABLE));
        QuotaProtos.SpaceQuota mergedSpaceQuota = merged.getSpaceProto();
        Assert.assertEquals((long)this.SPACE_QUOTA.getSoftLimit(), (long)mergedSpaceQuota.getSoftLimit());
        Assert.assertEquals((Object)QuotaProtos.SpaceViolationPolicy.DISABLE, (Object)mergedSpaceQuota.getViolationPolicy());
    }

    @Test
    public void testMergeThrottleAndSpace() throws IOException {
        String ns = "org1";
        QuotaProtos.Quotas quota = QuotaProtos.Quotas.newBuilder().setThrottle(this.THROTTLE).setSpace(this.SPACE_QUOTA).build();
        GlobalQuotaSettingsImpl settings = new GlobalQuotaSettingsImpl(null, null, "org1", null, quota);
        QuotaProtos.TimedQuota writeQuota = this.REQUEST_THROTTLE.toBuilder().setSoftLimit(500L).build();
        QuotaProtos.ThrottleRequest writeThrottle = QuotaProtos.ThrottleRequest.newBuilder().setTimedQuota(writeQuota).setType(QuotaProtos.ThrottleType.WRITE_NUMBER).build();
        GlobalQuotaSettingsImpl merged = settings.merge((QuotaSettings)new ThrottleSettings(null, null, "org1", null, writeThrottle));
        GlobalQuotaSettingsImpl finalQuota = merged.merge((QuotaSettings)new SpaceLimitSettings("org1", this.SPACE_QUOTA.getSoftLimit(), SpaceViolationPolicy.NO_WRITES_COMPACTIONS));
        QuotaProtos.Throttle throttle = finalQuota.getThrottleProto();
        Assert.assertTrue((boolean)throttle.hasReqNum());
        QuotaProtos.TimedQuota reqNumQuota = throttle.getReqNum();
        Assert.assertEquals((long)this.REQUEST_THROTTLE.getSoftLimit(), (long)reqNumQuota.getSoftLimit());
        Assert.assertTrue((boolean)throttle.hasWriteNum());
        QuotaProtos.TimedQuota writeNumQuota = throttle.getWriteNum();
        Assert.assertEquals((long)writeQuota.getSoftLimit(), (long)writeNumQuota.getSoftLimit());
        QuotaProtos.SpaceQuota finalSpaceQuota = finalQuota.getSpaceProto();
        Assert.assertEquals((long)this.SPACE_QUOTA.getSoftLimit(), (long)finalSpaceQuota.getSoftLimit());
        Assert.assertEquals((Object)QuotaProtos.SpaceViolationPolicy.NO_WRITES_COMPACTIONS, (Object)finalSpaceQuota.getViolationPolicy());
    }
}

