/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mob;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hadoop.hbase.mob.MobFileCache;
import org.apache.hadoop.hbase.mob.MobUtils;
import org.apache.hadoop.hbase.mob.TestMobUtils;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.HStoreFile;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionAsTable;
import org.apache.hadoop.hbase.regionserver.RegionScannerImpl;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionContext;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionLifeCycleTracker;
import org.apache.hadoop.hbase.regionserver.throttle.NoLimitThroughputController;
import org.apache.hadoop.hbase.regionserver.throttle.ThroughputController;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.Pair;
import org.junit.After;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
@Category(value={MediumTests.class})
public class TestMobStoreCompaction {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMobStoreCompaction.class);
    @Rule
    public TestName name = new TestName();
    static final Logger LOG = LoggerFactory.getLogger((String)TestMobStoreCompaction.class.getName());
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private Configuration conf = null;
    private HRegion region = null;
    private HTableDescriptor htd = null;
    private HColumnDescriptor hcd = null;
    private long mobCellThreshold = 1000L;
    private FileSystem fs;
    private static final byte[] COLUMN_FAMILY = HBaseTestingUtility.fam1;
    private final byte[] STARTROW = Bytes.toBytes((String)HBaseTestingUtility.START_KEY);
    private int compactionThreshold;
    private Boolean useFileBasedSFT;

    public TestMobStoreCompaction(Boolean useFileBasedSFT) {
        this.useFileBasedSFT = useFileBasedSFT;
    }

    @Parameterized.Parameters
    public static Collection<Boolean> data() {
        Boolean[] data = new Boolean[]{false, true};
        return Arrays.asList(data);
    }

    private void init(Configuration conf, long mobThreshold) throws Exception {
        if (this.useFileBasedSFT.booleanValue()) {
            conf.set("hbase.store.file-tracker.impl", "org.apache.hadoop.hbase.regionserver.storefiletracker.FileBasedStoreFileTracker");
        }
        this.conf = conf;
        this.mobCellThreshold = mobThreshold;
        HBaseTestingUtility UTIL = new HBaseTestingUtility(conf);
        this.compactionThreshold = conf.getInt("hbase.hstore.compactionThreshold", 3);
        this.htd = UTIL.createTableDescriptor(TestMobUtils.getTableName(this.name));
        this.hcd = new HColumnDescriptor(COLUMN_FAMILY);
        this.hcd.setMobEnabled(true);
        this.hcd.setMobThreshold(mobThreshold);
        this.hcd.setMaxVersions(1);
        this.htd.modifyFamily(this.hcd);
        RegionInfo regionInfo = RegionInfoBuilder.newBuilder((TableName)this.htd.getTableName()).build();
        this.region = HBaseTestingUtility.createRegionAndWAL(regionInfo, UTIL.getDataTestDir(), conf, (TableDescriptor)this.htd, new MobFileCache(conf));
        this.fs = FileSystem.get((Configuration)conf);
    }

    @After
    public void tearDown() throws Exception {
        this.region.close();
        this.fs.delete(UTIL.getDataTestDir(), true);
    }

    @Test
    public void testSmallerValue() throws Exception {
        this.init(UTIL.getConfiguration(), 500L);
        byte[] dummyData = this.makeDummyData(300);
        RegionAsTable loader = new RegionAsTable((Region)this.region);
        for (int i = 0; i < this.compactionThreshold; ++i) {
            Put p = this.createPut(i, dummyData);
            loader.put(p);
            this.region.flush(true);
        }
        Assert.assertEquals((String)"Before compaction: store files", (long)this.compactionThreshold, (long)this.countStoreFiles());
        Assert.assertEquals((String)"Before compaction: mob file count", (long)0L, (long)this.countMobFiles());
        Assert.assertEquals((String)"Before compaction: rows", (long)this.compactionThreshold, (long)UTIL.countRows((Region)this.region));
        Assert.assertEquals((String)"Before compaction: mob rows", (long)0L, (long)this.countMobRows());
        this.region.compactStores();
        Assert.assertEquals((String)"After compaction: store files", (long)1L, (long)this.countStoreFiles());
        Assert.assertEquals((String)"After compaction: mob file count", (long)0L, (long)this.countMobFiles());
        Assert.assertEquals((String)"After compaction: referenced mob file count", (long)0L, (long)this.countReferencedMobFiles());
        Assert.assertEquals((String)"After compaction: rows", (long)this.compactionThreshold, (long)UTIL.countRows((Region)this.region));
        Assert.assertEquals((String)"After compaction: mob rows", (long)0L, (long)this.countMobRows());
    }

    @Test
    public void testLargerValue() throws Exception {
        this.init(UTIL.getConfiguration(), 200L);
        byte[] dummyData = this.makeDummyData(300);
        RegionAsTable loader = new RegionAsTable((Region)this.region);
        for (int i = 0; i < this.compactionThreshold; ++i) {
            Put p = this.createPut(i, dummyData);
            loader.put(p);
            this.region.flush(true);
        }
        Assert.assertEquals((String)"Before compaction: store files", (long)this.compactionThreshold, (long)this.countStoreFiles());
        Assert.assertEquals((String)"Before compaction: mob file count", (long)this.compactionThreshold, (long)this.countMobFiles());
        Assert.assertEquals((String)"Before compaction: rows", (long)this.compactionThreshold, (long)UTIL.countRows((Region)this.region));
        Assert.assertEquals((String)"Before compaction: mob rows", (long)this.compactionThreshold, (long)this.countMobRows());
        Assert.assertEquals((String)"Before compaction: number of mob cells", (long)this.compactionThreshold, (long)this.countMobCellsInMetadata());
        TestMobStoreCompaction.setMobThreshold(this.region, COLUMN_FAMILY, 500L);
        this.region.initialize();
        List stores = this.region.getStores();
        for (HStore store : stores) {
            store.triggerMajorCompaction();
            Optional context = store.requestCompaction(1, CompactionLifeCycleTracker.DUMMY, User.getCurrent());
            if (!context.isPresent()) continue;
            this.region.compact((CompactionContext)context.get(), store, (ThroughputController)NoLimitThroughputController.INSTANCE, User.getCurrent());
        }
        Assert.assertEquals((String)"After compaction: store files", (long)1L, (long)this.countStoreFiles());
        Assert.assertEquals((String)"After compaction: mob file count", (long)this.compactionThreshold, (long)this.countMobFiles());
        Assert.assertEquals((String)"After compaction: referenced mob file count", (long)0L, (long)this.countReferencedMobFiles());
        Assert.assertEquals((String)"After compaction: rows", (long)this.compactionThreshold, (long)UTIL.countRows((Region)this.region));
        Assert.assertEquals((String)"After compaction: mob rows", (long)0L, (long)this.countMobRows());
    }

    private static HRegion setMobThreshold(HRegion region, byte[] cfName, long modThreshold) {
        ColumnFamilyDescriptor cfd = ColumnFamilyDescriptorBuilder.newBuilder((ColumnFamilyDescriptor)region.getTableDescriptor().getColumnFamily(cfName)).setMobThreshold(modThreshold).build();
        TableDescriptor td = TableDescriptorBuilder.newBuilder((TableDescriptor)region.getTableDescriptor()).removeColumnFamily(cfName).setColumnFamily(cfd).build();
        region.setTableDescriptor(td);
        return region;
    }

    @Test
    public void testMobCompactionWithBulkload() throws Exception {
        this.init(UTIL.getConfiguration(), 300L);
        byte[] dummyData = this.makeDummyData(600);
        Path hbaseRootDir = CommonFSUtils.getRootDir((Configuration)this.conf);
        Path basedir = new Path(hbaseRootDir, this.htd.getNameAsString());
        ArrayList<Pair> hfiles = new ArrayList<Pair>(1);
        for (int i = 0; i < this.compactionThreshold; ++i) {
            Path hpath = new Path(basedir, UUID.randomUUID().toString().replace("-", ""));
            hfiles.add(Pair.newPair((Object)COLUMN_FAMILY, (Object)hpath.toString()));
            this.createHFile(hpath, i, dummyData);
        }
        Map map = this.region.bulkLoadHFiles(hfiles, true, null);
        Assert.assertTrue((String)"Bulkload result:", (!map.isEmpty() ? 1 : 0) != 0);
        Assert.assertEquals((String)"Before compaction: store files", (long)this.compactionThreshold, (long)this.countStoreFiles());
        Assert.assertEquals((String)"Before compaction: mob file count", (long)0L, (long)this.countMobFiles());
        Assert.assertEquals((String)"Before compaction: rows", (long)this.compactionThreshold, (long)UTIL.countRows((Region)this.region));
        Assert.assertEquals((String)"Before compaction: mob rows", (long)0L, (long)this.countMobRows());
        Assert.assertEquals((String)"Before compaction: referenced mob file count", (long)0L, (long)this.countReferencedMobFiles());
        this.region.compactStores();
        Assert.assertEquals((String)"After compaction: store files", (long)1L, (long)this.countStoreFiles());
        Assert.assertEquals((String)"After compaction: mob file count:", (long)1L, (long)this.countMobFiles());
        Assert.assertEquals((String)"After compaction: rows", (long)this.compactionThreshold, (long)UTIL.countRows((Region)this.region));
        Assert.assertEquals((String)"After compaction: mob rows", (long)this.compactionThreshold, (long)this.countMobRows());
        Assert.assertEquals((String)"After compaction: referenced mob file count", (long)1L, (long)this.countReferencedMobFiles());
        Assert.assertEquals((String)"After compaction: number of mob cells", (long)this.compactionThreshold, (long)this.countMobCellsInMetadata());
    }

    @Test
    public void testMajorCompactionAfterDelete() throws Exception {
        this.init(UTIL.getConfiguration(), 100L);
        byte[] dummyData = this.makeDummyData(200);
        RegionAsTable loader = new RegionAsTable((Region)this.region);
        int numHfiles = this.compactionThreshold - 1;
        byte[] deleteRow = Bytes.add((byte[])this.STARTROW, (byte[])Bytes.toBytes((int)0));
        for (int i = 0; i < numHfiles; ++i) {
            Put p = this.createPut(i, dummyData);
            loader.put(p);
            this.region.flush(true);
        }
        Assert.assertEquals((String)"Before compaction: store files", (long)numHfiles, (long)this.countStoreFiles());
        Assert.assertEquals((String)"Before compaction: mob file count", (long)numHfiles, (long)this.countMobFiles());
        Assert.assertEquals((String)"Before compaction: rows", (long)numHfiles, (long)UTIL.countRows((Region)this.region));
        Assert.assertEquals((String)"Before compaction: mob rows", (long)numHfiles, (long)this.countMobRows());
        Assert.assertEquals((String)"Before compaction: number of mob cells", (long)numHfiles, (long)this.countMobCellsInMetadata());
        Delete delete = new Delete(deleteRow);
        delete.addFamily(COLUMN_FAMILY);
        this.region.delete(delete);
        this.region.flush(true);
        Assert.assertEquals((String)"Before compaction: store files", (long)(numHfiles + 1), (long)this.countStoreFiles());
        Assert.assertEquals((String)"Before compaction: mob files", (long)numHfiles, (long)this.countMobFiles());
        this.region.compact(true);
        Assert.assertEquals((String)"After compaction: store files", (long)1L, (long)this.countStoreFiles());
    }

    private int countStoreFiles() throws IOException {
        HStore store = this.region.getStore(COLUMN_FAMILY);
        return store.getStorefilesCount();
    }

    private int countMobFiles() throws IOException {
        Path mobDirPath = MobUtils.getMobFamilyPath((Configuration)this.conf, (TableName)this.htd.getTableName(), (String)this.hcd.getNameAsString());
        if (this.fs.exists(mobDirPath)) {
            FileStatus[] files = UTIL.getTestFileSystem().listStatus(mobDirPath);
            return files.length;
        }
        return 0;
    }

    private long countMobCellsInMetadata() throws IOException {
        long mobCellsCount = 0L;
        Path mobDirPath = MobUtils.getMobFamilyPath((Configuration)this.conf, (TableName)this.htd.getTableName(), (String)this.hcd.getNameAsString());
        Configuration copyOfConf = new Configuration(this.conf);
        copyOfConf.setFloat("hfile.block.cache.size", 0.0f);
        CacheConfig cacheConfig = new CacheConfig(copyOfConf);
        if (this.fs.exists(mobDirPath)) {
            FileStatus[] files;
            for (FileStatus file : files = UTIL.getTestFileSystem().listStatus(mobDirPath)) {
                HStoreFile sf = new HStoreFile(this.fs, file.getPath(), this.conf, cacheConfig, BloomType.NONE, true);
                sf.initReader();
                Map fileInfo = sf.getReader().loadFileInfo();
                byte[] count = (byte[])fileInfo.get(HStoreFile.MOB_CELLS_COUNT);
                Assert.assertTrue((count != null ? 1 : 0) != 0);
                mobCellsCount += Bytes.toLong((byte[])count);
            }
        }
        return mobCellsCount;
    }

    private Put createPut(int rowIdx, byte[] dummyData) throws IOException {
        Put p = new Put(Bytes.add((byte[])this.STARTROW, (byte[])Bytes.toBytes((int)rowIdx)));
        p.setDurability(Durability.SKIP_WAL);
        p.addColumn(COLUMN_FAMILY, Bytes.toBytes((String)"colX"), dummyData);
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createHFile(Path path, int rowIdx, byte[] dummyData) throws IOException {
        HFileContext meta = new HFileContextBuilder().build();
        HFile.Writer writer = HFile.getWriterFactory((Configuration)this.conf, (CacheConfig)new CacheConfig(this.conf)).withPath(this.fs, path).withFileContext(meta).create();
        long now = EnvironmentEdgeManager.currentTime();
        try {
            KeyValue kv = new KeyValue(Bytes.add((byte[])this.STARTROW, (byte[])Bytes.toBytes((int)rowIdx)), COLUMN_FAMILY, Bytes.toBytes((String)"colX"), now, dummyData);
            writer.append((Cell)kv);
        }
        finally {
            writer.appendFileInfo(HStoreFile.BULKLOAD_TIME_KEY, Bytes.toBytes((long)EnvironmentEdgeManager.currentTime()));
            writer.close();
        }
    }

    private int countMobRows() throws IOException {
        Scan scan = new Scan();
        scan.setAttribute("hbase.mob.scan.raw", Bytes.toBytes((boolean)Boolean.TRUE));
        RegionScannerImpl scanner = this.region.getScanner(scan);
        int scannedCount = 0;
        ArrayList results = new ArrayList();
        boolean hasMore = true;
        while (hasMore) {
            hasMore = scanner.next(results);
            for (Cell c : results) {
                if (!MobUtils.isMobReferenceCell((Cell)c)) continue;
                ++scannedCount;
            }
            results.clear();
        }
        scanner.close();
        return scannedCount;
    }

    private byte[] makeDummyData(int size) {
        byte[] dummyData = new byte[size];
        Bytes.random((byte[])dummyData);
        return dummyData;
    }

    private int countReferencedMobFiles() throws IOException {
        Scan scan = new Scan();
        scan.setAttribute("hbase.mob.scan.raw", Bytes.toBytes((boolean)Boolean.TRUE));
        RegionScannerImpl scanner = this.region.getScanner(scan);
        ArrayList kvs = new ArrayList();
        boolean hasMore = true;
        HashSet<String> files = new HashSet<String>();
        do {
            kvs.clear();
            hasMore = scanner.next(kvs);
            for (Cell kv : kvs) {
                String fileName;
                int size;
                if (!MobUtils.isMobReferenceCell((Cell)kv) || !MobUtils.hasValidMobRefCellValue((Cell)kv) || (long)(size = MobUtils.getMobValueLength((Cell)kv)) <= this.mobCellThreshold || (fileName = MobUtils.getMobFileName((Cell)kv)).isEmpty()) continue;
                files.add(fileName);
                Path familyPath = MobUtils.getMobFamilyPath((Configuration)this.conf, (TableName)this.htd.getTableName(), (String)this.hcd.getNameAsString());
                Assert.assertTrue((boolean)this.fs.exists(new Path(familyPath, fileName)));
            }
        } while (hasMore);
        scanner.close();
        return files.size();
    }
}

