/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.cleaner;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FirstKeyOnlyFilter;
import org.apache.hadoop.hbase.master.cleaner.ReplicationBarrierCleaner;
import org.apache.hadoop.hbase.master.cleaner.TestHFileCleaner;
import org.apache.hadoop.hbase.master.replication.ReplicationPeerManager;
import org.apache.hadoop.hbase.replication.ReplicationException;
import org.apache.hadoop.hbase.replication.ReplicationQueueStorage;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, MediumTests.class})
public class TestReplicationBarrierCleaner {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestReplicationBarrierCleaner.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestHFileCleaner.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    @Rule
    public final TestName name = new TestName();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        UTIL.startMiniCluster(1);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @After
    public void tearDown() throws IOException {
        try (Table table = UTIL.getConnection().getTable(TableName.META_TABLE_NAME);
             ResultScanner scanner = table.getScanner(new Scan().addFamily(HConstants.CATALOG_FAMILY).addFamily(HConstants.REPLICATION_BARRIER_FAMILY).setFilter((Filter)new FirstKeyOnlyFilter()));){
            Result result;
            while ((result = scanner.next()) != null) {
                TableName tableName = RegionInfo.getTable((byte[])result.getRow());
                if (tableName.isSystemTable()) continue;
                table.delete(new Delete(result.getRow()));
            }
        }
    }

    private ReplicationPeerManager create(ReplicationQueueStorage queueStorage, List<String> firstPeerIds, List<String> ... peerIds) {
        ReplicationPeerManager peerManager = (ReplicationPeerManager)Mockito.mock(ReplicationPeerManager.class);
        if (queueStorage != null) {
            Mockito.when((Object)peerManager.getQueueStorage()).thenReturn((Object)queueStorage);
        }
        if (peerIds.length == 0) {
            Mockito.when((Object)peerManager.getSerialPeerIdsBelongsTo((TableName)ArgumentMatchers.any(TableName.class))).thenReturn(firstPeerIds);
        } else {
            Mockito.when((Object)peerManager.getSerialPeerIdsBelongsTo((TableName)ArgumentMatchers.any(TableName.class))).thenReturn(firstPeerIds, (Object[])peerIds);
        }
        return peerManager;
    }

    private ReplicationQueueStorage create(Long lastPushedSeqId, Long ... lastPushedSeqIds) throws ReplicationException {
        ReplicationQueueStorage queueStorage = (ReplicationQueueStorage)Mockito.mock(ReplicationQueueStorage.class);
        if (lastPushedSeqIds.length == 0) {
            Mockito.when((Object)queueStorage.getLastSequenceId(ArgumentMatchers.anyString(), ArgumentMatchers.anyString())).thenReturn((Object)lastPushedSeqId);
        } else {
            Mockito.when((Object)queueStorage.getLastSequenceId(ArgumentMatchers.anyString(), ArgumentMatchers.anyString())).thenReturn((Object)lastPushedSeqId, (Object[])lastPushedSeqIds);
        }
        return queueStorage;
    }

    private ReplicationBarrierCleaner create(ReplicationPeerManager peerManager) throws IOException {
        return new ReplicationBarrierCleaner(UTIL.getConfiguration(), (Stoppable)new WarnOnlyStoppable(), UTIL.getConnection(), peerManager);
    }

    private void addBarrier(RegionInfo region, long ... barriers) throws IOException {
        Put put = new Put(region.getRegionName(), EnvironmentEdgeManager.currentTime());
        for (int i = 0; i < barriers.length; ++i) {
            put.addColumn(HConstants.REPLICATION_BARRIER_FAMILY, HConstants.SEQNUM_QUALIFIER, put.getTimestamp() - (long)barriers.length + (long)i, Bytes.toBytes((long)barriers[i]));
        }
        try (Table table = UTIL.getConnection().getTable(TableName.META_TABLE_NAME);){
            table.put(put);
        }
    }

    private void fillCatalogFamily(RegionInfo region) throws IOException {
        try (Table table = UTIL.getConnection().getTable(TableName.META_TABLE_NAME);){
            table.put(new Put(region.getRegionName()).addColumn(HConstants.CATALOG_FAMILY, Bytes.toBytes((String)"whatever"), Bytes.toBytes((String)"whatever")));
        }
    }

    private void clearCatalogFamily(RegionInfo region) throws IOException {
        try (Table table = UTIL.getConnection().getTable(TableName.META_TABLE_NAME);){
            table.delete(new Delete(region.getRegionName()).addFamily(HConstants.CATALOG_FAMILY));
        }
    }

    @Test
    public void testNothing() throws IOException {
        ReplicationPeerManager peerManager = (ReplicationPeerManager)Mockito.mock(ReplicationPeerManager.class);
        ReplicationBarrierCleaner cleaner = this.create(peerManager);
        cleaner.chore();
        ((ReplicationPeerManager)Mockito.verify((Object)peerManager, (VerificationMode)Mockito.never())).getSerialPeerIdsBelongsTo((TableName)ArgumentMatchers.any(TableName.class));
        ((ReplicationPeerManager)Mockito.verify((Object)peerManager, (VerificationMode)Mockito.never())).getQueueStorage();
    }

    @Test
    public void testCleanNoPeers() throws IOException {
        TableName tableName1 = TableName.valueOf((String)(this.name.getMethodName() + "_1"));
        RegionInfo region11 = RegionInfoBuilder.newBuilder((TableName)tableName1).setEndKey(Bytes.toBytes((int)1)).build();
        this.addBarrier(region11, 10L, 20L, 30L, 40L, 50L, 60L);
        this.fillCatalogFamily(region11);
        RegionInfo region12 = RegionInfoBuilder.newBuilder((TableName)tableName1).setStartKey(Bytes.toBytes((int)1)).build();
        this.addBarrier(region12, 20L, 30L, 40L, 50L, 60L, 70L);
        this.fillCatalogFamily(region12);
        TableName tableName2 = TableName.valueOf((String)(this.name.getMethodName() + "_2"));
        RegionInfo region21 = RegionInfoBuilder.newBuilder((TableName)tableName2).setEndKey(Bytes.toBytes((int)1)).build();
        this.addBarrier(region21, 100L, 200L, 300L, 400L);
        this.fillCatalogFamily(region21);
        RegionInfo region22 = RegionInfoBuilder.newBuilder((TableName)tableName2).setStartKey(Bytes.toBytes((int)1)).build();
        this.addBarrier(region22, 200L, 300L, 400L, 500L, 600L);
        this.fillCatalogFamily(region22);
        ReplicationPeerManager peerManager = this.create(null, Collections.emptyList(), Collections.emptyList());
        ReplicationBarrierCleaner cleaner = this.create(peerManager);
        cleaner.chore();
        ((ReplicationPeerManager)Mockito.verify((Object)peerManager, (VerificationMode)Mockito.never())).getQueueStorage();
        ((ReplicationPeerManager)Mockito.verify((Object)peerManager, (VerificationMode)Mockito.times((int)2))).getSerialPeerIdsBelongsTo((TableName)ArgumentMatchers.any(TableName.class));
        Assert.assertArrayEquals((long[])new long[]{60L}, (long[])MetaTableAccessor.getReplicationBarrier((Connection)UTIL.getConnection(), (byte[])region11.getRegionName()));
        Assert.assertArrayEquals((long[])new long[]{70L}, (long[])MetaTableAccessor.getReplicationBarrier((Connection)UTIL.getConnection(), (byte[])region12.getRegionName()));
        Assert.assertArrayEquals((long[])new long[]{400L}, (long[])MetaTableAccessor.getReplicationBarrier((Connection)UTIL.getConnection(), (byte[])region21.getRegionName()));
        Assert.assertArrayEquals((long[])new long[]{600L}, (long[])MetaTableAccessor.getReplicationBarrier((Connection)UTIL.getConnection(), (byte[])region22.getRegionName()));
    }

    @Test
    public void testDeleteBarriers() throws IOException, ReplicationException {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        RegionInfo region = RegionInfoBuilder.newBuilder((TableName)tableName).build();
        this.addBarrier(region, 10L, 20L, 30L, 40L, 50L, 60L);
        ReplicationQueueStorage queueStorage = this.create(-1L, 2L, 15L, 25L, 20L, 25L, 65L, 55L, 70L, 70L);
        ArrayList peerIds = Lists.newArrayList((Object[])new String[]{"1", "2"});
        ReplicationPeerManager peerManager = this.create(queueStorage, peerIds, peerIds, peerIds, peerIds, peerIds);
        ReplicationBarrierCleaner cleaner = this.create(peerManager);
        cleaner.chore();
        Assert.assertArrayEquals((long[])new long[]{10L, 20L, 30L, 40L, 50L, 60L}, (long[])MetaTableAccessor.getReplicationBarrier((Connection)UTIL.getConnection(), (byte[])region.getRegionName()));
        cleaner.chore();
        Assert.assertArrayEquals((long[])new long[]{10L, 20L, 30L, 40L, 50L, 60L}, (long[])MetaTableAccessor.getReplicationBarrier((Connection)UTIL.getConnection(), (byte[])region.getRegionName()));
        cleaner.chore();
        Assert.assertArrayEquals((long[])new long[]{20L, 30L, 40L, 50L, 60L}, (long[])MetaTableAccessor.getReplicationBarrier((Connection)UTIL.getConnection(), (byte[])region.getRegionName()));
        cleaner.chore();
        Assert.assertArrayEquals((long[])new long[]{50L, 60L}, (long[])MetaTableAccessor.getReplicationBarrier((Connection)UTIL.getConnection(), (byte[])region.getRegionName()));
        cleaner.chore();
        Assert.assertArrayEquals((long[])new long[]{60L}, (long[])MetaTableAccessor.getReplicationBarrier((Connection)UTIL.getConnection(), (byte[])region.getRegionName()));
    }

    @Test
    public void testDeleteRowForDeletedRegion() throws IOException, ReplicationException {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        RegionInfo region = RegionInfoBuilder.newBuilder((TableName)tableName).build();
        this.addBarrier(region, 40L, 50L, 60L);
        this.fillCatalogFamily(region);
        String peerId = "1";
        ReplicationQueueStorage queueStorage = this.create(59L, new Long[0]);
        ReplicationPeerManager peerManager = this.create(queueStorage, Lists.newArrayList((Object[])new String[]{peerId}), new List[0]);
        ReplicationBarrierCleaner cleaner = this.create(peerManager);
        cleaner.chore();
        Assert.assertArrayEquals((long[])new long[]{50L, 60L}, (long[])MetaTableAccessor.getReplicationBarrier((Connection)UTIL.getConnection(), (byte[])region.getRegionName()));
        ((ReplicationQueueStorage)Mockito.verify((Object)queueStorage, (VerificationMode)Mockito.never())).removeLastSequenceIds(ArgumentMatchers.anyString(), ArgumentMatchers.anyList());
        this.clearCatalogFamily(region);
        cleaner.chore();
        try (Table table = UTIL.getConnection().getTable(TableName.META_TABLE_NAME);){
            Assert.assertFalse((boolean)table.exists(new Get(region.getRegionName()).addFamily(HConstants.REPLICATION_BARRIER_FAMILY)));
        }
        ((ReplicationQueueStorage)Mockito.verify((Object)queueStorage, (VerificationMode)Mockito.times((int)1))).removeLastSequenceIds(peerId, Arrays.asList(region.getEncodedName()));
    }

    @Test
    public void testDeleteRowForDeletedRegionNoPeers() throws IOException {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        RegionInfo region = RegionInfoBuilder.newBuilder((TableName)tableName).build();
        this.addBarrier(region, 40L, 50L, 60L);
        ReplicationPeerManager peerManager = (ReplicationPeerManager)Mockito.mock(ReplicationPeerManager.class);
        ReplicationBarrierCleaner cleaner = this.create(peerManager);
        cleaner.chore();
        ((ReplicationPeerManager)Mockito.verify((Object)peerManager, (VerificationMode)Mockito.times((int)1))).getSerialPeerIdsBelongsTo(tableName);
        try (Table table = UTIL.getConnection().getTable(TableName.META_TABLE_NAME);){
            Assert.assertFalse((boolean)table.exists(new Get(region.getRegionName())));
        }
    }

    private static class WarnOnlyStoppable
    implements Stoppable {
        private WarnOnlyStoppable() {
        }

        public void stop(String why) {
            LOG.warn("TestReplicationBarrierCleaner received stop, ignoring. Reason: " + why);
        }

        public boolean isStopped() {
            return false;
        }
    }
}

