/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.cleaner;

import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.master.cleaner.HFileLinkCleaner;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.HFileArchiveUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={LargeTests.class})
public class TestCleanerClearHFiles {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestCleanerClearHFiles.class);
    @Rule
    public TestName name = new TestName();
    private static HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static Configuration conf = TEST_UTIL.getConfiguration();
    private static Admin admin = null;
    private static final byte[] COLUMN_FAMILY = Bytes.toBytes((String)"CF");
    private static final String TABLE1 = "table1";
    private static final String TABLE2 = "table2";
    private static final String DEFAULT_ARCHIVE_SUBDIRS_PREFIX = "data/default/";

    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        conf.setStrings("hbase.master.hfile.cleaner.custom.paths", new String[]{"data/default/table1"});
        conf.setStrings("hbase.master.hfilecleaner.custom.paths.plugins", new String[]{HFileLinkCleaner.class.getName()});
        conf.setInt("hbase.master.hfilecleaner.ttl", 10);
        conf.setInt("hbase.master.cleaner.interval", 20000);
        TEST_UTIL.startMiniCluster();
        admin = TEST_UTIL.getAdmin();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testClearArchive() throws Exception {
        DistributedFileSystem fs = TEST_UTIL.getDFSCluster().getFileSystem();
        Table table1 = this.createTable(TEST_UTIL, TableName.valueOf((String)TABLE1));
        Table table2 = this.createTable(TEST_UTIL, TableName.valueOf((String)TABLE2));
        admin.disableTable(table1.getName());
        admin.deleteTable(table1.getName());
        admin.disableTable(table2.getName());
        admin.deleteTable(table2.getName());
        Path archiveDir = HFileArchiveUtil.getArchivePath((Configuration)conf);
        Path archiveTable1Path = new Path(archiveDir, "data/default/table1");
        Path archiveTable2Path = new Path(archiveDir, "data/default/table2");
        TEST_UTIL.waitFor(10000L, () -> !this.notExistOrEmptyDir(archiveTable1Path, fs) && !this.notExistOrEmptyDir(archiveTable2Path, fs));
        TEST_UTIL.waitFor(30000L, () -> this.notExistOrEmptyDir(archiveTable1Path, fs) && this.notExistOrEmptyDir(archiveTable2Path, fs));
    }

    private boolean notExistOrEmptyDir(Path dir, DistributedFileSystem fs) {
        try {
            return fs.listStatus(dir).length == 0;
        }
        catch (Exception e) {
            return e instanceof FileNotFoundException;
        }
    }

    private Table createTable(HBaseTestingUtility util, TableName tableName) throws IOException {
        TableDescriptor td = TableDescriptorBuilder.newBuilder((TableName)tableName).setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])COLUMN_FAMILY).build()).build();
        return util.createTable(td, (byte[][])null);
    }
}

