/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.balancer;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Random;
import java.util.TreeMap;
import java.util.concurrent.ThreadLocalRandom;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionReplicaUtil;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.balancer.BalanceAction;
import org.apache.hadoop.hbase.master.balancer.BalancerClusterState;
import org.apache.hadoop.hbase.master.balancer.BalancerTestBase;
import org.apache.hadoop.hbase.master.balancer.CandidateGenerator;
import org.apache.hadoop.hbase.master.balancer.DummyMetricsStochasticBalancer;
import org.apache.hadoop.hbase.master.balancer.HeterogeneousRegionCountCostFunction;
import org.apache.hadoop.hbase.master.balancer.MetricsStochasticBalancer;
import org.apache.hadoop.hbase.master.balancer.RandomCandidateGenerator;
import org.apache.hadoop.hbase.master.balancer.ServerAndLoad;
import org.apache.hadoop.hbase.master.balancer.StochasticLoadBalancer;
import org.apache.hadoop.hbase.master.balancer.TestStochasticLoadBalancerHeterogeneousCostRules;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={MasterTests.class, MediumTests.class})
public class TestStochasticLoadBalancerHeterogeneousCost
extends BalancerTestBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestStochasticLoadBalancerHeterogeneousCost.class);
    private static final HBaseTestingUtility HTU = new HBaseTestingUtility();
    private static String RULES_FILE;
    private Queue<ServerName> serverQueue = new LinkedList<ServerName>();

    @BeforeClass
    public static void beforeAllTests() throws IOException {
        BalancerTestBase.conf = HTU.getConfiguration();
        BalancerTestBase.conf.setFloat("hbase.master.balancer.stochastic.regionCountCost", 0.0f);
        BalancerTestBase.conf.setFloat("hbase.master.balancer.stochastic.primaryRegionCountCost", 0.0f);
        BalancerTestBase.conf.setFloat("hbase.master.balancer.stochastic.tableSkewCost", 0.0f);
        BalancerTestBase.conf.set("hbase.master.balancer.stochastic.additionalCostFunctions", HeterogeneousRegionCountCostFunction.class.getName());
        TestCase.assertTrue((boolean)FileSystem.get((Configuration)HTU.getConfiguration()).mkdirs(HTU.getDataTestDir()));
        RULES_FILE = HTU.getDataTestDir("hbase-balancer.rules").toString();
        BalancerTestBase.conf.set("hbase.master.balancer.heterogeneousRegionCountRulesFile", RULES_FILE);
        loadBalancer = new StochasticLoadTestBalancer();
        MasterServices services = (MasterServices)Mockito.mock(MasterServices.class);
        Mockito.when((Object)services.getConfiguration()).thenReturn((Object)conf);
        BalancerTestBase.loadBalancer.setMasterServices(services);
        loadBalancer.initialize();
        loadBalancer.getCandidateGenerators().add(new FairRandomCandidateGenerator());
    }

    @Test
    public void testDefault() throws IOException {
        List<String> rules = Collections.emptyList();
        int numNodes = 2;
        int numRegions = 300;
        int numRegionsPerServer = 250;
        this.testHeterogeneousWithCluster(2, 300, 250, rules);
    }

    @Test
    public void testOneGroup() throws IOException {
        List<String> rules = Collections.singletonList("rs.* 100");
        int numNodes = 4;
        int numRegions = 300;
        int numRegionsPerServer = 30;
        this.testHeterogeneousWithCluster(4, 300, 30, rules);
    }

    @Test
    public void testTwoGroups() throws IOException {
        List<String> rules = Arrays.asList("rs[0-4] 200", "rs[5-9] 50");
        int numNodes = 10;
        int numRegions = 500;
        int numRegionsPerServer = 50;
        this.testHeterogeneousWithCluster(10, 500, 50, rules);
    }

    @Test
    public void testFourGroups() throws IOException {
        List<String> rules = Arrays.asList("rs[1-3] 200", "rs[4-7] 250", "rs[8-9] 100");
        int numNodes = 10;
        int numRegions = 800;
        int numRegionsPerServer = 80;
        this.testHeterogeneousWithCluster(10, 800, 80, rules);
    }

    @Test
    public void testOverloaded() throws IOException {
        List<String> rules = Collections.singletonList("rs[0-1] 50");
        int numNodes = 2;
        int numRegions = 120;
        int numRegionsPerServer = 60;
        TestStochasticLoadBalancerHeterogeneousCostRules.createRulesFile(RULES_FILE);
        Map<ServerName, List<RegionInfo>> serverMap = this.createServerMap(2, 120, 60, 1, 1);
        List plans = BalancerTestBase.loadBalancer.balanceTable(HConstants.ENSEMBLE_TABLE_NAME, serverMap);
        Assert.assertNull((Object)plans);
    }

    private void testHeterogeneousWithCluster(int numNodes, int numRegions, int numRegionsPerServer, List<String> rules) throws IOException {
        TestStochasticLoadBalancerHeterogeneousCostRules.createRulesFile(RULES_FILE, rules);
        Map<ServerName, List<RegionInfo>> serverMap = this.createServerMap(numNodes, numRegions, numRegionsPerServer, 1, 1);
        this.testWithClusterWithIteration(serverMap, null, true, false);
    }

    @Override
    protected Map<ServerName, List<RegionInfo>> createServerMap(int numNodes, int numRegions, int numRegionsPerServer, int replication, int numTables) {
        int[] cluster = new int[numNodes];
        for (int i = 0; i < numNodes; ++i) {
            cluster[i] = numRegionsPerServer;
        }
        cluster[cluster.length - 1] = numRegions - (cluster.length - 1) * numRegionsPerServer;
        TreeMap<ServerName, List<RegionInfo>> clusterState = this.mockClusterServers(cluster, numTables);
        if (replication > 0) {
            for (List regions : clusterState.values()) {
                int length = regions.size();
                for (int i = 0; i < length; ++i) {
                    for (int r = 1; r < replication; ++r) {
                        regions.add(RegionReplicaUtil.getRegionInfoForReplica((RegionInfo)((RegionInfo)regions.get(i)), (int)r));
                    }
                }
            }
        }
        return clusterState;
    }

    @Override
    protected TreeMap<ServerName, List<RegionInfo>> mockClusterServers(int[] mockCluster, int numTables) {
        int numServers = mockCluster.length;
        TreeMap<ServerName, List<RegionInfo>> servers = new TreeMap<ServerName, List<RegionInfo>>();
        for (int i = 0; i < numServers; ++i) {
            int numRegions = mockCluster[i];
            ServerAndLoad sal = this.createServer("rs" + i);
            List<RegionInfo> regions = this.randomRegions(numRegions, numTables);
            servers.put(sal.getServerName(), regions);
        }
        return servers;
    }

    private ServerAndLoad createServer(String host) {
        if (!this.serverQueue.isEmpty()) {
            ServerName sn = this.serverQueue.poll();
            return new ServerAndLoad(sn, 0);
        }
        ThreadLocalRandom rand = ThreadLocalRandom.current();
        int port = ((Random)rand).nextInt(60000);
        long startCode = ((Random)rand).nextLong();
        ServerName sn = ServerName.valueOf((String)host, (int)port, (long)startCode);
        return new ServerAndLoad(sn, 0);
    }

    static class StochasticLoadTestBalancer
    extends StochasticLoadBalancer {
        private FairRandomCandidateGenerator fairRandomCandidateGenerator = new FairRandomCandidateGenerator();

        StochasticLoadTestBalancer() {
            super((MetricsStochasticBalancer)new DummyMetricsStochasticBalancer());
        }

        protected CandidateGenerator getRandomGenerator() {
            return this.fairRandomCandidateGenerator;
        }
    }

    static class FairRandomCandidateGenerator
    extends RandomCandidateGenerator {
        FairRandomCandidateGenerator() {
        }

        public BalanceAction pickRandomRegions(BalancerClusterState cluster, int thisServer, int otherServer) {
            if (thisServer < 0 || otherServer < 0) {
                return BalanceAction.NULL_ACTION;
            }
            int thisRegion = this.pickRandomRegion(cluster, thisServer, 0.5);
            int otherRegion = this.pickRandomRegion(cluster, otherServer, 0.5);
            return this.getAction(thisServer, thisRegion, otherServer, otherRegion);
        }

        BalanceAction generate(BalancerClusterState cluster) {
            return super.generate(cluster);
        }
    }
}

