/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile.bucket;

import java.io.File;
import java.io.IOException;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.io.hfile.bucket.BucketEntry;
import org.apache.hadoop.hbase.io.hfile.bucket.ExclusiveMemoryMmapIOEngine;
import org.apache.hadoop.hbase.io.hfile.bucket.TestByteBufferIOEngine;
import org.apache.hadoop.hbase.nio.ByteBuff;
import org.apache.hadoop.hbase.testclassification.IOTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={IOTests.class, SmallTests.class})
public class TestExclusiveMemoryMmapEngine {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestExclusiveMemoryMmapEngine.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFileMmapEngine() throws IOException {
        int size = 0x200000;
        String filePath = "testFileMmapEngine";
        try {
            ExclusiveMemoryMmapIOEngine fileMmapEngine = new ExclusiveMemoryMmapIOEngine(filePath, (long)size);
            for (int i = 0; i < 50; ++i) {
                int len = (int)Math.floor(Math.random() * 100.0);
                long offset = (long)Math.floor(Math.random() * (double)size % (double)(size - len));
                int val = (int)(Math.random() * 255.0);
                ByteBuff src = TestByteBufferIOEngine.createByteBuffer(len, val, i % 2 == 0);
                int pos = src.position();
                int lim = src.limit();
                fileMmapEngine.write(src, offset);
                src.position(pos).limit(lim);
                BucketEntry be = TestByteBufferIOEngine.createBucketEntry(offset, len);
                fileMmapEngine.read(be);
                ByteBuff dst = TestByteBufferIOEngine.getByteBuff(be);
                Assert.assertEquals((long)src.remaining(), (long)len);
                Assert.assertEquals((long)dst.remaining(), (long)len);
                Assert.assertEquals((long)0L, (long)ByteBuff.compareTo((ByteBuff)src, (int)pos, (int)len, (ByteBuff)dst, (int)dst.position(), (int)dst.remaining()));
            }
        }
        finally {
            File file = new File(filePath);
            if (file.exists()) {
                file.delete();
            }
        }
    }
}

