/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io;

import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.testclassification.IOTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.WritableComparable;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={IOTests.class, SmallTests.class})
public class TestImmutableBytesWritable {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestImmutableBytesWritable.class);

    @Test
    public void testHash() throws Exception {
        Assert.assertEquals((long)new ImmutableBytesWritable(Bytes.toBytes((String)"xxabc"), 2, 3).hashCode(), (long)new ImmutableBytesWritable(Bytes.toBytes((String)"abc")).hashCode());
        Assert.assertEquals((long)new ImmutableBytesWritable(Bytes.toBytes((String)"xxabcd"), 2, 3).hashCode(), (long)new ImmutableBytesWritable(Bytes.toBytes((String)"abc")).hashCode());
        Assert.assertNotSame((Object)new ImmutableBytesWritable(Bytes.toBytes((String)"xxabc"), 2, 3).hashCode(), (Object)new ImmutableBytesWritable(Bytes.toBytes((String)"xxabc"), 2, 2).hashCode());
    }

    @Test
    public void testSpecificCompare() {
        ImmutableBytesWritable ibw1 = new ImmutableBytesWritable(new byte[]{15});
        ImmutableBytesWritable.Comparator c = new ImmutableBytesWritable.Comparator();
        ImmutableBytesWritable ibw2 = new ImmutableBytesWritable(new byte[]{0, 0});
        Assert.assertFalse((String)"ibw1 < ibw2", (c.compare((WritableComparable)ibw1, (WritableComparable)ibw2) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testComparison() throws Exception {
        this.runTests("aa", "b", -1);
        this.runTests("aa", "aa", 0);
        this.runTests("aa", "ab", -1);
        this.runTests("aa", "aaa", -1);
        this.runTests("", "", 0);
        this.runTests("", "a", -1);
    }

    private void runTests(String aStr, String bStr, int signum) throws Exception {
        ImmutableBytesWritable a = new ImmutableBytesWritable(Bytes.toBytes((String)aStr));
        ImmutableBytesWritable b = new ImmutableBytesWritable(Bytes.toBytes((String)bStr));
        this.doComparisonsOnObjects(a, b, signum);
        this.doComparisonsOnRaw(a, b, signum);
        a = new ImmutableBytesWritable(Bytes.toBytes((String)("xxx" + aStr)), 3, aStr.length());
        b = new ImmutableBytesWritable(Bytes.toBytes((String)("yy" + bStr)), 2, bStr.length());
        this.doComparisonsOnObjects(a, b, signum);
        this.doComparisonsOnRaw(a, b, signum);
        a = new ImmutableBytesWritable(Bytes.toBytes((String)("xxx" + aStr + "zzz")), 3, aStr.length());
        b = new ImmutableBytesWritable(Bytes.toBytes((String)("yy" + bStr + "aaa")), 2, bStr.length());
        this.doComparisonsOnObjects(a, b, signum);
        this.doComparisonsOnRaw(a, b, signum);
    }

    private int signum(int i) {
        if (i > 0) {
            return 1;
        }
        if (i == 0) {
            return 0;
        }
        return -1;
    }

    private void doComparisonsOnRaw(ImmutableBytesWritable a, ImmutableBytesWritable b, int expectedSignum) throws IOException {
        ImmutableBytesWritable.Comparator comparator = new ImmutableBytesWritable.Comparator();
        ByteArrayOutputStream baosA = new ByteArrayOutputStream();
        ByteArrayOutputStream baosB = new ByteArrayOutputStream();
        a.write((DataOutput)new DataOutputStream(baosA));
        b.write((DataOutput)new DataOutputStream(baosB));
        Assert.assertEquals((String)("Comparing " + a + " and " + b + " as raw"), (long)this.signum(comparator.compare(baosA.toByteArray(), 0, baosA.size(), baosB.toByteArray(), 0, baosB.size())), (long)expectedSignum);
        Assert.assertEquals((String)("Comparing " + a + " and " + b + " as raw (inverse)"), (long)(-this.signum(comparator.compare(baosB.toByteArray(), 0, baosB.size(), baosA.toByteArray(), 0, baosA.size()))), (long)expectedSignum);
    }

    private void doComparisonsOnObjects(ImmutableBytesWritable a, ImmutableBytesWritable b, int expectedSignum) {
        ImmutableBytesWritable.Comparator comparator = new ImmutableBytesWritable.Comparator();
        Assert.assertEquals((String)("Comparing " + a + " and " + b + " as objects"), (long)this.signum(comparator.compare((WritableComparable)a, (WritableComparable)b)), (long)expectedSignum);
        Assert.assertEquals((String)("Comparing " + a + " and " + b + " as objects (inverse)"), (long)(-this.signum(comparator.compare((WritableComparable)b, (WritableComparable)a))), (long)expectedSignum);
    }
}

