/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.List;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.MetaWithReplicasTestBase;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MiscTests.class, MediumTests.class})
public class TestCleanupMetaReplica
extends MetaWithReplicasTestBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestCleanupMetaReplica.class);

    @BeforeClass
    public static void setUp() throws Exception {
        TestCleanupMetaReplica.startCluster();
    }

    @Test
    public void testReplicaCleanup() throws Exception {
        ZKWatcher zkw = TEST_UTIL.getZooKeeperWatcher();
        List metaReplicaZnodes = zkw.getMetaReplicaNodes();
        Assert.assertEquals((long)3L, (long)metaReplicaZnodes.size());
        HBaseTestingUtility.setReplicas(TEST_UTIL.getAdmin(), TableName.META_TABLE_NAME, 1);
        metaReplicaZnodes = zkw.getMetaReplicaNodes();
        Assert.assertEquals((long)1L, (long)metaReplicaZnodes.size());
    }
}

