/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.RegionLocations;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.ConnectionRegistry;
import org.apache.hadoop.hbase.client.RegistryEndpointsRefresher;
import org.apache.hadoop.hbase.client.RetriesExhaustedException;
import org.apache.hadoop.hbase.exceptions.ClientExceptionsUtil;
import org.apache.hadoop.hbase.exceptions.MasterRegistryFetchException;
import org.apache.hadoop.hbase.ipc.HBaseRpcController;
import org.apache.hadoop.hbase.ipc.RpcClient;
import org.apache.hadoop.hbase.ipc.RpcClientFactory;
import org.apache.hadoop.hbase.ipc.RpcControllerFactory;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.shaded.com.google.errorprone.annotations.RestrictedApi;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.RegistryProtos;
import org.apache.hadoop.hbase.trace.TraceUtil;
import org.apache.hadoop.hbase.util.FutureUtils;
import org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.apache.hbase.thirdparty.com.google.common.collect.ImmutableMap;
import org.apache.hbase.thirdparty.com.google.protobuf.Message;
import org.apache.hbase.thirdparty.com.google.protobuf.RpcCallback;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
abstract class AbstractRpcBasedConnectionRegistry
implements ConnectionRegistry {
    public static final int HEDGED_REQS_FANOUT_DEFAULT = 2;
    private final int hedgedReadFanOut;
    private volatile ImmutableMap<ServerName, RegistryProtos.ClientMetaService.Interface> addr2Stub;
    private final RpcClient rpcClient;
    private final RpcControllerFactory rpcControllerFactory;
    private final int rpcTimeoutMs;
    private final RegistryEndpointsRefresher registryEndpointRefresher;

    protected AbstractRpcBasedConnectionRegistry(Configuration conf, String hedgedReqsFanoutConfigName, String initialRefreshDelaySecsConfigName, String refreshIntervalSecsConfigName, String minRefreshIntervalSecsConfigName) throws IOException {
        this.hedgedReadFanOut = Math.max(1, conf.getInt(hedgedReqsFanoutConfigName, 2));
        this.rpcTimeoutMs = (int)Math.min(Integer.MAX_VALUE, conf.getLong("hbase.rpc.timeout", 60000L));
        this.rpcClient = RpcClientFactory.createClient(conf, null);
        this.rpcControllerFactory = RpcControllerFactory.instantiate(conf);
        this.populateStubs(this.getBootstrapNodes(conf));
        this.registryEndpointRefresher = RegistryEndpointsRefresher.create(conf, initialRefreshDelaySecsConfigName, refreshIntervalSecsConfigName, minRefreshIntervalSecsConfigName, this::refreshStubs);
    }

    protected abstract Set<ServerName> getBootstrapNodes(Configuration var1) throws IOException;

    protected abstract CompletableFuture<Set<ServerName>> fetchEndpoints();

    private void refreshStubs() throws IOException {
        this.populateStubs(FutureUtils.get(this.fetchEndpoints()));
    }

    private void populateStubs(Set<ServerName> addrs) throws IOException {
        Preconditions.checkNotNull(addrs);
        ImmutableMap.Builder<ServerName, RegistryProtos.ClientMetaService.Stub> builder = ImmutableMap.builderWithExpectedSize(addrs.size());
        User user = User.getCurrent();
        for (ServerName masterAddr : addrs) {
            builder.put(masterAddr, RegistryProtos.ClientMetaService.newStub(this.rpcClient.createRpcChannel(masterAddr, user, this.rpcTimeoutMs)));
        }
        this.addr2Stub = builder.build();
    }

    private <T extends Message> CompletableFuture<T> call(RegistryProtos.ClientMetaService.Interface stub, Callable<T> callable) {
        HBaseRpcController controller = this.rpcControllerFactory.newController();
        CompletableFuture future = new CompletableFuture();
        callable.call(controller, stub, (T resp) -> {
            if (controller.failed()) {
                IOException failureReason = controller.getFailed();
                future.completeExceptionally(failureReason);
                if (ClientExceptionsUtil.isConnectionException(failureReason)) {
                    this.registryEndpointRefresher.refreshNow();
                }
            } else {
                future.complete(resp);
            }
        });
        return future;
    }

    private IOException badResponse(String debug) {
        return new IOException(String.format("Invalid result for request %s. Will be retried", debug));
    }

    private <T extends Message> void groupCall(CompletableFuture<T> future, Set<ServerName> servers, List<RegistryProtos.ClientMetaService.Interface> stubs, int startIndexInclusive, Callable<T> callable, Predicate<T> isValidResp, String debug, ConcurrentLinkedQueue<Throwable> errors) {
        int endIndexExclusive = Math.min(startIndexInclusive + this.hedgedReadFanOut, stubs.size());
        AtomicInteger remaining = new AtomicInteger(endIndexExclusive - startIndexInclusive);
        for (int i = startIndexInclusive; i < endIndexExclusive; ++i) {
            FutureUtils.addListener(this.call(stubs.get(i), callable), (r, e) -> {
                if (future.isDone()) {
                    return;
                }
                if (e == null && !isValidResp.test(r)) {
                    e = this.badResponse(debug);
                }
                if (e != null) {
                    errors.add((Throwable)e);
                    if (remaining.decrementAndGet() == 0) {
                        if (endIndexExclusive == stubs.size()) {
                            RetriesExhaustedException ex = new RetriesExhaustedException("masters", stubs.size(), new ArrayList<Throwable>(errors));
                            future.completeExceptionally(new MasterRegistryFetchException(servers, (Throwable)ex));
                        } else {
                            this.groupCall(future, servers, stubs, endIndexExclusive, callable, isValidResp, debug, errors);
                        }
                    }
                } else {
                    future.complete(r);
                }
            });
        }
    }

    protected final <T extends Message> CompletableFuture<T> call(Callable<T> callable, Predicate<T> isValidResp, String debug) {
        ImmutableMap<ServerName, RegistryProtos.ClientMetaService.Interface> addr2StubRef = this.addr2Stub;
        Set servers = addr2StubRef.keySet();
        ArrayList<RegistryProtos.ClientMetaService.Interface> stubs = new ArrayList<RegistryProtos.ClientMetaService.Interface>(addr2StubRef.values());
        Collections.shuffle(stubs, ThreadLocalRandom.current());
        CompletableFuture future = new CompletableFuture();
        this.groupCall(future, servers, stubs, 0, callable, isValidResp, debug, new ConcurrentLinkedQueue<Throwable>());
        return future;
    }

    @RestrictedApi(explanation="Should only be called in tests", link="", allowedOnPath=".*/src/test/.*")
    Set<ServerName> getParsedServers() {
        return this.addr2Stub.keySet();
    }

    private static RegionLocations transformMetaRegionLocations(RegistryProtos.GetMetaRegionLocationsResponse resp) {
        ArrayList<HRegionLocation> regionLocations = new ArrayList<HRegionLocation>();
        resp.getMetaLocationsList().forEach(location -> regionLocations.add(ProtobufUtil.toRegionLocation(location)));
        return new RegionLocations(regionLocations);
    }

    @Override
    public CompletableFuture<RegionLocations> getMetaRegionLocations() {
        return TraceUtil.tracedFuture(() -> this.call((c, s, d) -> s.getMetaRegionLocations(c, RegistryProtos.GetMetaRegionLocationsRequest.getDefaultInstance(), d), r -> r.getMetaLocationsCount() != 0, "getMetaLocationsCount").thenApply(AbstractRpcBasedConnectionRegistry::transformMetaRegionLocations), this.getClass().getSimpleName() + ".getMetaRegionLocations");
    }

    @Override
    public CompletableFuture<String> getClusterId() {
        return TraceUtil.tracedFuture(() -> this.call((c, s, d) -> s.getClusterId(c, RegistryProtos.GetClusterIdRequest.getDefaultInstance(), d), RegistryProtos.GetClusterIdResponse::hasClusterId, "getClusterId()").thenApply(RegistryProtos.GetClusterIdResponse::getClusterId), this.getClass().getSimpleName() + ".getClusterId");
    }

    @Override
    public CompletableFuture<ServerName> getActiveMaster() {
        return TraceUtil.tracedFuture(() -> this.call((c, s, d) -> s.getActiveMaster(c, RegistryProtos.GetActiveMasterRequest.getDefaultInstance(), d), RegistryProtos.GetActiveMasterResponse::hasServerName, "getActiveMaster()").thenApply(resp -> ProtobufUtil.toServerName(resp.getServerName())), this.getClass().getSimpleName() + ".getActiveMaster");
    }

    @Override
    public void close() {
        TraceUtil.trace(() -> {
            if (this.registryEndpointRefresher != null) {
                this.registryEndpointRefresher.stop();
            }
            if (this.rpcClient != null) {
                this.rpcClient.close();
            }
        }, this.getClass().getSimpleName() + ".close");
    }

    @FunctionalInterface
    protected static interface Callable<T> {
        public void call(HBaseRpcController var1, RegistryProtos.ClientMetaService.Interface var2, RpcCallback<T> var3);
    }
}

