/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.mavibot.btree.util;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.UUID;
import org.apache.directory.mavibot.btree.Tuple;
import org.apache.directory.mavibot.btree.util.TupleReaderWriter;

public class BulkDataSorter<K, V> {
    private File workDir;
    private int splitAfter = 1000;
    private Comparator<Tuple<K, V>> tupleComparator;
    private TupleReaderWriter<K, V> readerWriter;
    private boolean sorted;

    public BulkDataSorter(TupleReaderWriter<K, V> readerWriter, Comparator<Tuple<K, V>> tupleComparator, int splitAfter) {
        if (splitAfter <= 0) {
            throw new IllegalArgumentException("Value of splitAfter parameter cannot be null");
        }
        this.splitAfter = splitAfter;
        this.workDir = new File(System.getProperty("java.io.tmpdir"), System.currentTimeMillis() + "-sort");
        this.workDir.mkdir();
        this.readerWriter = readerWriter;
        this.tupleComparator = tupleComparator;
    }

    public void sort(File dataFile) throws IOException {
        int i = 0;
        Tuple[] arr = (Tuple[])Array.newInstance(Tuple.class, this.splitAfter);
        Tuple<K, V> t = null;
        DataInputStream in = new DataInputStream(new FileInputStream(dataFile));
        while ((t = this.readerWriter.readTuple(in)) != null) {
            arr[i++] = t;
            if (i % this.splitAfter != 0) continue;
            i = 0;
            Arrays.sort(arr, this.tupleComparator);
            this.storeSortedData(arr);
        }
        if (i != 0) {
            Tuple[] tmp = (Tuple[])Array.newInstance(Tuple.class, i);
            System.arraycopy(arr, 0, tmp, 0, i);
            Arrays.sort(tmp, this.tupleComparator);
            this.storeSortedData(tmp);
        }
        this.sorted = true;
    }

    private void storeSortedData(Tuple<K, V>[] arr) throws IOException {
        File tempFile = File.createTempFile(UUID.randomUUID().toString(), ".batch", this.workDir);
        DataOutputStream out = new DataOutputStream(new FileOutputStream(tempFile));
        for (Tuple<K, V> t : arr) {
            this.readerWriter.writeTuple(t, out);
        }
        out.flush();
        out.close();
    }

    public File getWorkDir() {
        return this.workDir;
    }

    public Iterator<Tuple<K, V>> getMergeSortedTuples() throws IOException {
        if (!this.sorted) {
            throw new IllegalStateException("Data is not sorted");
        }
        File[] batches = this.workDir.listFiles();
        if (batches.length == 0) {
            return Collections.EMPTY_LIST.iterator();
        }
        final DataInputStream[] streams = new DataInputStream[batches.length];
        for (int i = 0; i < batches.length; ++i) {
            streams[i] = new DataInputStream(new FileInputStream(batches[i]));
        }
        Iterator itr = new Iterator<Tuple<K, V>>(){
            private Tuple<K, V>[] heads;
            private Tuple<K, V> candidate;
            private boolean closed;
            private int candidatePos;
            {
                this.heads = (Tuple[])Array.newInstance(Tuple.class, streams.length);
                this.candidate = null;
                this.candidatePos = -1;
            }

            @Override
            public boolean hasNext() {
                int i;
                if (this.closed) {
                    throw new IllegalStateException("No elements to read");
                }
                Tuple available = null;
                for (i = 0; i < streams.length; ++i) {
                    int comp;
                    if (this.heads[i] == null) {
                        this.heads[i] = BulkDataSorter.this.readerWriter.readTuple(streams[i]);
                    }
                    if (available == null) {
                        available = this.heads[i];
                        this.candidatePos = i;
                        continue;
                    }
                    if (available == null || this.heads[i] == null || (comp = BulkDataSorter.this.tupleComparator.compare(this.heads[i], available)) > 0) continue;
                    available = this.heads[i];
                    this.candidatePos = i;
                }
                this.heads[this.candidatePos] = null;
                if (available == null) {
                    for (i = 0; i < streams.length; ++i) {
                        if (this.heads[i] == null) continue;
                        available = this.heads[i];
                        this.heads[i] = BulkDataSorter.this.readerWriter.readTuple(streams[i]);
                        break;
                    }
                }
                if (available != null) {
                    this.candidate = available;
                    return true;
                }
                for (DataInputStream in : streams) {
                    try {
                        in.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                this.closed = true;
                return false;
            }

            @Override
            public Tuple<K, V> next() {
                if (this.candidate == null && !this.closed) {
                    this.hasNext();
                }
                if (this.candidate == null) {
                    throw new NoSuchElementException("No tuples found");
                }
                return this.candidate;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Not supported");
            }
        };
        return itr;
    }
}

