/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.mavibot.btree;

import java.io.IOException;
import org.apache.directory.mavibot.btree.BTree;
import org.apache.directory.mavibot.btree.Leaf;
import org.apache.directory.mavibot.btree.ParentPos;

class InternalUtil {
    InternalUtil() {
    }

    public static void setDupsContainer(ParentPos parentPos, BTree btree) {
        if (!btree.isAllowDuplicates()) {
            return;
        }
        try {
            if (parentPos.dupsContainer == null) {
                BTree dupsContainer;
                Leaf leaf = (Leaf)parentPos.page;
                parentPos.dupsContainer = dupsContainer = (BTree)leaf.values[parentPos.pos].getValue(btree);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void changeNextDupsContainer(ParentPos parentPos, BTree btree) throws IOException {
        if (!btree.isAllowDuplicates()) {
            return;
        }
        if (parentPos.pos < parentPos.page.getNbElems()) {
            BTree dupsContainer;
            Leaf leaf = (Leaf)parentPos.page;
            parentPos.dupsContainer = dupsContainer = (BTree)leaf.values[parentPos.pos].getValue(btree);
            parentPos.dupPos = 0;
        }
    }

    public static void changePrevDupsContainer(ParentPos parentPos, BTree btree) throws IOException {
        if (!btree.isAllowDuplicates()) {
            return;
        }
        int index = parentPos.pos - 1;
        if (index >= 0) {
            BTree dupsContainer;
            Leaf leaf = (Leaf)parentPos.page;
            parentPos.dupsContainer = dupsContainer = (BTree)leaf.values[index].getValue(btree);
            parentPos.dupPos = (int)parentPos.dupsContainer.getNbElems();
        }
    }

    public static void setLastDupsContainer(ParentPos parentPos, BTree btree) throws IOException {
        InternalUtil.changePrevDupsContainer(parentPos, btree);
    }
}

