/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.test.util.warc;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.test.util.warc.WARCFileWriter;
import org.apache.hadoop.hbase.test.util.warc.WARCWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;

public class WARCOutputFormat
extends FileOutputFormat<NullWritable, WARCWritable> {
    public RecordWriter<NullWritable, WARCWritable> getRecordWriter(TaskAttemptContext context) throws IOException, InterruptedException {
        return new WARCWriter(context);
    }

    private class WARCWriter
    extends RecordWriter<NullWritable, WARCWritable> {
        private final WARCFileWriter writer;

        public WARCWriter(TaskAttemptContext context) throws IOException {
            Configuration conf = context.getConfiguration();
            CompressionCodec codec = FileOutputFormat.getCompressOutput((JobContext)context) ? WARCFileWriter.getGzipCodec(conf) : null;
            Path workFile = WARCOutputFormat.this.getDefaultWorkFile(context, "");
            this.writer = new WARCFileWriter(conf, codec, workFile);
        }

        public void write(NullWritable key, WARCWritable value) throws IOException, InterruptedException {
            this.writer.write(value);
        }

        public void close(TaskAttemptContext context) throws IOException, InterruptedException {
            this.writer.close();
        }
    }
}

