/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.chaos.factories;

import org.apache.hadoop.hbase.chaos.actions.Action;
import org.apache.hadoop.hbase.chaos.actions.AddCPULoadAction;
import org.apache.hadoop.hbase.chaos.actions.CorruptPacketsCommandAction;
import org.apache.hadoop.hbase.chaos.actions.DelayPacketsCommandAction;
import org.apache.hadoop.hbase.chaos.actions.DumpClusterStatusAction;
import org.apache.hadoop.hbase.chaos.actions.DuplicatePacketsCommandAction;
import org.apache.hadoop.hbase.chaos.actions.FillDiskCommandAction;
import org.apache.hadoop.hbase.chaos.actions.LosePacketsCommandAction;
import org.apache.hadoop.hbase.chaos.actions.ReorderPacketsCommandAction;
import org.apache.hadoop.hbase.chaos.factories.MonkeyFactory;
import org.apache.hadoop.hbase.chaos.monkies.ChaosMonkey;
import org.apache.hadoop.hbase.chaos.monkies.PolicyBasedChaosMonkey;
import org.apache.hadoop.hbase.chaos.policies.PeriodicRandomActionPolicy;

public class DistributedIssuesMonkeyFactory
extends MonkeyFactory {
    private long action1Period;
    private long action2Period;
    private long cpuLoadDuration;
    private long cpuLoadProcesses;
    private long networkIssueTimeout;
    private long networkIssueDuration;
    private float networkIssueRation;
    private long networkIssueDelay;
    private String networkIssueInterface;
    private long fillDiskTimeout;
    private String fillDiskPath;
    private long fillDiskFileSize;
    private long fillDiskIssueduration;

    @Override
    public ChaosMonkey build() {
        this.loadProperties();
        Action[] actions1 = new Action[]{new AddCPULoadAction(this.cpuLoadDuration, this.cpuLoadProcesses, this.networkIssueTimeout), new CorruptPacketsCommandAction(this.networkIssueRation, this.networkIssueDuration, this.networkIssueTimeout, this.networkIssueInterface), new DuplicatePacketsCommandAction(this.networkIssueRation, this.networkIssueDuration, this.networkIssueTimeout, this.networkIssueInterface), new LosePacketsCommandAction(this.networkIssueRation, this.networkIssueDuration, this.networkIssueTimeout, this.networkIssueInterface), new DelayPacketsCommandAction(this.networkIssueDelay, this.networkIssueDuration, this.networkIssueTimeout, this.networkIssueInterface), new ReorderPacketsCommandAction(this.networkIssueRation, this.networkIssueDuration, this.networkIssueDelay, this.networkIssueTimeout, this.networkIssueInterface), new FillDiskCommandAction(this.fillDiskFileSize, this.fillDiskIssueduration, this.fillDiskPath, this.fillDiskTimeout)};
        Action[] actions2 = new Action[]{new DumpClusterStatusAction()};
        return new PolicyBasedChaosMonkey(this.properties, this.util, new PeriodicRandomActionPolicy(this.action1Period, actions1), new PeriodicRandomActionPolicy(this.action2Period, actions2));
    }

    private void loadProperties() {
        this.action1Period = Long.parseLong(this.properties.getProperty("sdm.action1.period", "60000"));
        this.action2Period = Long.parseLong(this.properties.getProperty("sdm.action2.period", "90000"));
        this.cpuLoadDuration = Long.parseLong(this.properties.getProperty("cpu.load.duration", "300000"));
        this.cpuLoadProcesses = Long.parseLong(this.properties.getProperty("cpu.load.processes", "2"));
        this.networkIssueTimeout = Long.parseLong(this.properties.getProperty("network.issue.command.timeout", "30000"));
        this.networkIssueDuration = Long.parseLong(this.properties.getProperty("network.issueduration", "60000"));
        this.networkIssueRation = Float.parseFloat(this.properties.getProperty("network.issue.ratio", "0.1"));
        this.networkIssueDelay = Long.parseLong(this.properties.getProperty("network.issue.delay", "100"));
        this.networkIssueInterface = this.properties.getProperty("network.issue.interface", "eth0");
        this.fillDiskTimeout = Long.parseLong(this.properties.getProperty("fill.disk.command.timeout", "60000"));
        this.fillDiskPath = this.properties.getProperty("fill.disk.path", "/tmp");
        this.fillDiskFileSize = Long.parseLong(this.properties.getProperty("fill.disk.file.size", "0"));
        this.fillDiskIssueduration = Long.parseLong(this.properties.getProperty("fill.disk.issue.duration", "300000"));
    }
}

