/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.regionserver;

import java.io.IOException;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.replication.TestReplicationBase;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MediumTests.class})
public class TestReplicationCompressedWAL
extends TestReplicationBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestReplicationCompressedWAL.class);
    static final Logger LOG = LoggerFactory.getLogger(TestReplicationCompressedWAL.class);
    static final int NUM_BATCHES = 20;
    static final int NUM_ROWS_PER_BATCH = 100;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        CONF1.setBoolean("hbase.regionserver.wal.enablecompression", true);
        TestReplicationBase.setUpBeforeClass();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TestReplicationBase.tearDownAfterClass();
    }

    @Test
    public void testMultiplePuts() throws Exception {
        TestReplicationCompressedWAL.runMultiplePutTest();
    }

    protected static void runMultiplePutTest() throws IOException, InterruptedException {
        for (int i = 0; i < 20; ++i) {
            TestReplicationCompressedWAL.putBatch(i);
            TestReplicationCompressedWAL.getBatch(i);
        }
    }

    protected static void getBatch(int batch) throws IOException, InterruptedException {
        block0: for (int i = 0; i < 100; ++i) {
            byte[] row = TestReplicationCompressedWAL.getRowKey(batch, i);
            Get get = new Get(row);
            for (int j = 0; j < 50; ++j) {
                Result res;
                if (j == 49) {
                    Assert.fail((String)"Waited too much time for replication");
                }
                if (!(res = htable2.get(get)).isEmpty()) {
                    Assert.assertArrayEquals((byte[])row, (byte[])res.value());
                    continue block0;
                }
                LOG.info("Row not available");
                Thread.sleep(500L);
            }
        }
    }

    protected static byte[] getRowKey(int batch, int count) {
        return Bytes.toBytes((String)("row" + (batch * 100 + count)));
    }

    protected static void putBatch(int batch) throws IOException {
        for (int i = 0; i < 100; ++i) {
            byte[] row = TestReplicationCompressedWAL.getRowKey(batch, i);
            Put put = new Put(row);
            put.addColumn(famName, row, row);
            htable1.put(put);
        }
    }
}

