/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.replication.ReplicationQueueStorage;
import org.apache.hadoop.hbase.replication.SerialReplicationTestBase;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.ReplicationTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ReplicationTests.class, MediumTests.class})
public class TestSerialReplication
extends SerialReplicationTestBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestSerialReplication.class);

    @Before
    public void setUp() throws IOException, CommonFSUtils.StreamLacksCapabilityException {
        this.setupWALWriter();
        this.addPeer(false);
    }

    @Test
    public void testRegionMove() throws Exception {
        TableName tableName = this.createTable();
        try (Table table = UTIL.getConnection().getTable(tableName);){
            for (int i = 0; i < 100; ++i) {
                table.put(new Put(Bytes.toBytes((int)i)).addColumn(CF, CQ, Bytes.toBytes((int)i)));
            }
        }
        RegionInfo region = (RegionInfo)UTIL.getAdmin().getRegions(tableName).get(0);
        HRegionServer rs = UTIL.getOtherRegionServer(UTIL.getRSForFirstRegionInTable(tableName));
        TestSerialReplication.moveRegion(region, rs);
        try (Table table = UTIL.getConnection().getTable(tableName);){
            for (int i = 100; i < 200; ++i) {
                table.put(new Put(Bytes.toBytes((int)i)).addColumn(CF, CQ, Bytes.toBytes((int)i)));
            }
        }
        this.enablePeerAndWaitUntilReplicationDone(200);
        this.checkOrder(200);
    }

    @Test
    public void testRegionSplit() throws Exception {
        TableName tableName = this.createTable();
        try (Table table = UTIL.getConnection().getTable(tableName);){
            for (int i = 0; i < 100; ++i) {
                table.put(new Put(Bytes.toBytes((int)i)).addColumn(CF, CQ, Bytes.toBytes((int)i)));
            }
        }
        UTIL.flush(tableName);
        RegionInfo region = (RegionInfo)UTIL.getAdmin().getRegions(tableName).get(0);
        UTIL.getAdmin().splitRegionAsync(region.getEncodedNameAsBytes(), Bytes.toBytes((int)50)).get(30L, TimeUnit.SECONDS);
        UTIL.waitUntilNoRegionsInTransition(30000L);
        List regions = UTIL.getAdmin().getRegions(tableName);
        Assert.assertEquals((long)2L, (long)regions.size());
        try (Table table = UTIL.getConnection().getTable(tableName);){
            for (int i = 0; i < 100; ++i) {
                table.put(new Put(Bytes.toBytes((int)i)).addColumn(CF, CQ, Bytes.toBytes((int)i)));
            }
        }
        this.enablePeerAndWaitUntilReplicationDone(200);
        HashMap<String, Long> regionsToSeqId = new HashMap<String, Long>();
        regionsToSeqId.put(region.getEncodedName(), -1L);
        regions.stream().map(RegionInfo::getEncodedName).forEach(n -> regionsToSeqId.put((String)n, -1L));
        try (WAL.Reader reader = WALFactory.createReader((FileSystem)UTIL.getTestFileSystem(), (Path)this.logPath, (Configuration)UTIL.getConfiguration());){
            WAL.Entry entry;
            int count = 0;
            while ((entry = reader.next()) != null) {
                String encodedName = Bytes.toString((byte[])entry.getKey().getEncodedRegionName());
                Long seqId = (Long)regionsToSeqId.get(encodedName);
                Assert.assertNotNull((String)("Unexcepted entry " + entry + ", expected regions " + region + ", or " + regions), (Object)seqId);
                Assert.assertTrue((String)("Sequence id go backwards from " + seqId + " to " + entry.getKey().getSequenceId() + " for " + encodedName), (entry.getKey().getSequenceId() >= seqId ? 1 : 0) != 0);
                if (count < 100) {
                    Assert.assertEquals((String)(encodedName + " is pushed before parent " + region.getEncodedName()), (Object)region.getEncodedName(), (Object)encodedName);
                } else {
                    Assert.assertNotEquals((Object)region.getEncodedName(), (Object)encodedName);
                }
                ++count;
            }
            Assert.assertEquals((long)200L, (long)count);
        }
    }

    @Test
    public void testRegionMerge() throws Exception {
        byte[] splitKey = Bytes.toBytes((int)50);
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        UTIL.getAdmin().createTable(TableDescriptorBuilder.newBuilder((TableName)tableName).setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])CF).setScope(1).build()).build(), (byte[][])new byte[][]{splitKey});
        UTIL.waitTableAvailable(tableName);
        try (Table table = UTIL.getConnection().getTable(tableName);){
            for (int i = 0; i < 100; ++i) {
                table.put(new Put(Bytes.toBytes((int)i)).addColumn(CF, CQ, Bytes.toBytes((int)i)));
            }
        }
        List regions = UTIL.getAdmin().getRegions(tableName);
        UTIL.getAdmin().mergeRegionsAsync((byte[][])regions.stream().map(RegionInfo::getEncodedNameAsBytes).toArray(x$0 -> new byte[x$0][]), false).get(30L, TimeUnit.SECONDS);
        UTIL.waitUntilNoRegionsInTransition(30000L);
        List regionsAfterMerge = UTIL.getAdmin().getRegions(tableName);
        Assert.assertEquals((long)1L, (long)regionsAfterMerge.size());
        try (Table table = UTIL.getConnection().getTable(tableName);){
            for (int i = 0; i < 100; ++i) {
                table.put(new Put(Bytes.toBytes((int)i)).addColumn(CF, CQ, Bytes.toBytes((int)i)));
            }
        }
        this.enablePeerAndWaitUntilReplicationDone(200);
        HashMap<String, Long> regionsToSeqId = new HashMap<String, Long>();
        RegionInfo region = (RegionInfo)regionsAfterMerge.get(0);
        regionsToSeqId.put(region.getEncodedName(), -1L);
        regions.stream().map(RegionInfo::getEncodedName).forEach(n -> regionsToSeqId.put((String)n, -1L));
        try (WAL.Reader reader = WALFactory.createReader((FileSystem)UTIL.getTestFileSystem(), (Path)this.logPath, (Configuration)UTIL.getConfiguration());){
            WAL.Entry entry;
            int count = 0;
            while ((entry = reader.next()) != null) {
                String encodedName = Bytes.toString((byte[])entry.getKey().getEncodedRegionName());
                Long seqId = (Long)regionsToSeqId.get(encodedName);
                Assert.assertNotNull((String)("Unexcepted entry " + entry + ", expected regions " + region + ", or " + regions), (Object)seqId);
                Assert.assertTrue((String)("Sequence id go backwards from " + seqId + " to " + entry.getKey().getSequenceId() + " for " + encodedName), (entry.getKey().getSequenceId() >= seqId ? 1 : 0) != 0);
                if (count < 100) {
                    Assert.assertNotEquals((String)(encodedName + " is pushed before parents " + regions.stream().map(RegionInfo::getEncodedName).collect(Collectors.joining(" and "))), (Object)region.getEncodedName(), (Object)encodedName);
                } else {
                    Assert.assertEquals((Object)region.getEncodedName(), (Object)encodedName);
                }
                ++count;
            }
            Assert.assertEquals((long)200L, (long)count);
        }
    }

    @Test
    public void testRemovePeerNothingReplicated() throws Exception {
        TableName tableName = this.createTable();
        String encodedRegionName = UTIL.getMiniHBaseCluster().getRegions(tableName).get(0).getRegionInfo().getEncodedName();
        ReplicationQueueStorage queueStorage = UTIL.getMiniHBaseCluster().getMaster().getReplicationPeerManager().getQueueStorage();
        Assert.assertEquals((long)-1L, (long)queueStorage.getLastSequenceId(encodedRegionName, PEER_ID));
        UTIL.getAdmin().removeReplicationPeer(PEER_ID);
        Assert.assertEquals((long)-1L, (long)queueStorage.getLastSequenceId(encodedRegionName, PEER_ID));
    }

    @Test
    public void testRemovePeer() throws Exception {
        TableName tableName = this.createTable();
        try (Table table = UTIL.getConnection().getTable(tableName);){
            for (int i = 0; i < 100; ++i) {
                table.put(new Put(Bytes.toBytes((int)i)).addColumn(CF, CQ, Bytes.toBytes((int)i)));
            }
        }
        this.enablePeerAndWaitUntilReplicationDone(100);
        this.checkOrder(100);
        String encodedRegionName = UTIL.getMiniHBaseCluster().getRegions(tableName).get(0).getRegionInfo().getEncodedName();
        ReplicationQueueStorage queueStorage = UTIL.getMiniHBaseCluster().getMaster().getReplicationPeerManager().getQueueStorage();
        Assert.assertTrue((queueStorage.getLastSequenceId(encodedRegionName, PEER_ID) > 0L ? 1 : 0) != 0);
        UTIL.getAdmin().removeReplicationPeer(PEER_ID);
        Assert.assertEquals((long)-1L, (long)queueStorage.getLastSequenceId(encodedRegionName, PEER_ID));
    }

    @Test
    public void testRemoveSerialFlag() throws Exception {
        TableName tableName = this.createTable();
        try (Table table = UTIL.getConnection().getTable(tableName);){
            for (int i = 0; i < 100; ++i) {
                table.put(new Put(Bytes.toBytes((int)i)).addColumn(CF, CQ, Bytes.toBytes((int)i)));
            }
        }
        this.enablePeerAndWaitUntilReplicationDone(100);
        this.checkOrder(100);
        String encodedRegionName = UTIL.getMiniHBaseCluster().getRegions(tableName).get(0).getRegionInfo().getEncodedName();
        ReplicationQueueStorage queueStorage = UTIL.getMiniHBaseCluster().getMaster().getReplicationPeerManager().getQueueStorage();
        Assert.assertTrue((queueStorage.getLastSequenceId(encodedRegionName, PEER_ID) > 0L ? 1 : 0) != 0);
        ReplicationPeerConfig peerConfig = UTIL.getAdmin().getReplicationPeerConfig(PEER_ID);
        UTIL.getAdmin().updateReplicationPeerConfig(PEER_ID, ReplicationPeerConfig.newBuilder((ReplicationPeerConfig)peerConfig).setSerial(false).build());
        Assert.assertEquals((long)-1L, (long)queueStorage.getLastSequenceId(encodedRegionName, PEER_ID));
    }
}

