/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coprocessor;

import java.io.IOException;
import java.util.Optional;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.coprocessor.CoprocessorException;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionObserver;
import org.apache.hadoop.hbase.regionserver.FlushLifeCycleTracker;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.RegionCoprocessorHost;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.regionserver.ScanType;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionLifeCycleTracker;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionRequest;
import org.apache.hadoop.hbase.testclassification.CoprocessorTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.mockito.Mockito;

@Category(value={CoprocessorTests.class, SmallTests.class})
public class TestRegionObserverPreFlushAndPreCompact {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRegionObserverPreFlushAndPreCompact.class);
    @Rule
    public TestName name = new TestName();

    @Test(expected=CoprocessorException.class)
    public void testPreFlushReturningNull() throws IOException {
        RegionCoprocessorHost rch = this.getRegionCoprocessorHost();
        rch.preFlush(null, null, null);
    }

    @Test(expected=CoprocessorException.class)
    public void testPreCompactReturningNull() throws IOException {
        RegionCoprocessorHost rch = this.getRegionCoprocessorHost();
        rch.preCompact(null, null, null, null, null, null);
    }

    private RegionCoprocessorHost getRegionCoprocessorHost() {
        RegionInfo ri = RegionInfoBuilder.FIRST_META_REGIONINFO;
        HRegion mockedHRegion = (HRegion)Mockito.mock(HRegion.class);
        Mockito.when((Object)mockedHRegion.getRegionInfo()).thenReturn((Object)ri);
        TableDescriptor td = TableDescriptorBuilder.newBuilder((TableName)ri.getTable()).build();
        Mockito.when((Object)mockedHRegion.getTableDescriptor()).thenReturn((Object)td);
        RegionServerServices mockedServices = (RegionServerServices)Mockito.mock(RegionServerServices.class);
        Configuration conf = HBaseConfiguration.create();
        conf.set("hbase.coprocessor.region.classes", TestRegionObserver.class.getName());
        return new RegionCoprocessorHost(mockedHRegion, mockedServices, conf);
    }

    public static class TestRegionObserver
    implements RegionObserver,
    RegionCoprocessor {
        public InternalScanner preFlush(ObserverContext<RegionCoprocessorEnvironment> c, Store store, InternalScanner scanner, FlushLifeCycleTracker tracker) throws IOException {
            return null;
        }

        public InternalScanner preCompact(ObserverContext<RegionCoprocessorEnvironment> c, Store store, InternalScanner scanner, ScanType scanType, CompactionLifeCycleTracker tracker, CompactionRequest request) throws IOException {
            return null;
        }

        public Optional<RegionObserver> getRegionObserver() {
            return Optional.of(this);
        }
    }
}

