/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.List;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.regionserver.ConstantSizeRegionSplitPolicy;
import org.apache.hadoop.hbase.snapshot.SnapshotTestingUtils;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.Threads;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={LargeTests.class, ClientTests.class})
public class TestSnapshotCloneIndependence {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestSnapshotCloneIndependence.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestSnapshotCloneIndependence.class);
    @Rule
    public TestName testName = new TestName();
    protected static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    protected static final int NUM_RS = 2;
    private static final String STRING_TABLE_NAME = "test";
    private static final String TEST_FAM_STR = "fam";
    protected static final byte[] TEST_FAM = Bytes.toBytes((String)"fam");
    private static final int CLEANER_INTERVAL = 100;
    private FileSystem fs;
    private Path rootDir;
    private Admin admin;
    private TableName originalTableName;
    private Table originalTable;
    private TableName cloneTableName;
    private int countOriginalTable;
    String snapshotNameAsString;
    byte[] snapshotName;

    @BeforeClass
    public static void setupCluster() throws Exception {
        TestSnapshotCloneIndependence.setupConf(UTIL.getConfiguration());
        UTIL.startMiniCluster(2);
    }

    static void setupConf(Configuration conf) {
        conf.setInt("hbase.regionserver.metahandler.count", 15);
        conf.setBoolean("hbase.snapshot.enabled", true);
        conf.setInt("hbase.hregion.memstore.flush.size", 25000);
        conf.setInt("hbase.hstore.compaction.min", 10);
        conf.setInt("hbase.hstore.compactionThreshold", 10);
        conf.setInt("hbase.hstore.blockingStoreFiles", 12);
        conf.setInt("hbase.regionserver.msginterval", 100);
        conf.setBoolean("hbase.master.enabletable.roundrobin", true);
        conf.set("hbase.regionserver.region.split.policy", ConstantSizeRegionSplitPolicy.class.getName());
        conf.setInt("hbase.master.cleaner.interval", 100);
        conf.setInt("hbase.master.hfilecleaner.plugins.snapshot.period", 100);
        conf.setInt("hbase.master.hfilecleaner.ttl", 100);
    }

    @Before
    public void setup() throws Exception {
        this.fs = UTIL.getHBaseCluster().getMaster().getMasterFileSystem().getFileSystem();
        this.rootDir = UTIL.getHBaseCluster().getMaster().getMasterFileSystem().getRootDir();
        this.admin = UTIL.getAdmin();
        this.originalTableName = TableName.valueOf((String)(STRING_TABLE_NAME + this.testName.getMethodName()));
        this.cloneTableName = TableName.valueOf((String)("test-clone-" + this.originalTableName));
        this.snapshotNameAsString = "snapshot_" + this.originalTableName;
        this.snapshotName = Bytes.toBytes((String)this.snapshotNameAsString);
        this.originalTable = this.createTable(this.originalTableName, TEST_FAM);
        this.loadData(this.originalTable, new byte[][]{TEST_FAM});
        this.countOriginalTable = this.countRows(this.originalTable, new byte[0][]);
        System.out.println("Original table has: " + this.countOriginalTable + " rows");
    }

    @After
    public void tearDown() throws Exception {
        UTIL.deleteTable(this.originalTableName);
        UTIL.deleteTable(this.cloneTableName);
        SnapshotTestingUtils.deleteAllSnapshots(UTIL.getAdmin());
        SnapshotTestingUtils.deleteArchiveDirectory(UTIL);
    }

    @AfterClass
    public static void cleanupTest() throws Exception {
        try {
            UTIL.shutdownMiniCluster();
        }
        catch (Exception e) {
            LOG.warn("failure shutting down cluster", (Throwable)e);
        }
    }

    @Test
    public void testOnlineSnapshotAppendIndependent() throws Exception {
        this.createAndCloneSnapshot(true);
        this.runTestSnapshotAppendIndependent();
    }

    @Test
    public void testOfflineSnapshotAppendIndependent() throws Exception {
        this.createAndCloneSnapshot(false);
        this.runTestSnapshotAppendIndependent();
    }

    @Test
    public void testOnlineSnapshotMetadataChangesIndependent() throws Exception {
        this.createAndCloneSnapshot(true);
        this.runTestSnapshotMetadataChangesIndependent();
    }

    @Test
    public void testOfflineSnapshotMetadataChangesIndependent() throws Exception {
        this.createAndCloneSnapshot(false);
        this.runTestSnapshotMetadataChangesIndependent();
    }

    @Test
    public void testOfflineSnapshotRegionOperationsIndependent() throws Exception {
        this.createAndCloneSnapshot(false);
        this.runTestRegionOperationsIndependent();
    }

    @Test
    public void testOnlineSnapshotRegionOperationsIndependent() throws Exception {
        this.createAndCloneSnapshot(true);
        this.runTestRegionOperationsIndependent();
    }

    @Test
    public void testOfflineSnapshotDeleteIndependent() throws Exception {
        this.createAndCloneSnapshot(false);
        this.runTestSnapshotDeleteIndependent();
    }

    @Test
    public void testOnlineSnapshotDeleteIndependent() throws Exception {
        this.createAndCloneSnapshot(true);
        this.runTestSnapshotDeleteIndependent();
    }

    private static void waitOnSplit(Connection c, Table t, int originalCount) throws Exception {
        for (int i = 0; i < 200; ++i) {
            Threads.sleepWithoutInterrupt((long)500L);
            try (RegionLocator locator = c.getRegionLocator(t.getName());){
                if (locator.getAllRegionLocations().size() <= originalCount) continue;
                return;
            }
        }
        throw new Exception("Split did not increase the number of regions");
    }

    private void createAndCloneSnapshot(boolean online) throws Exception {
        SnapshotTestingUtils.createSnapshotAndValidate(this.admin, this.originalTableName, TEST_FAM_STR, this.snapshotNameAsString, this.rootDir, this.fs, online);
        if (!online) {
            this.admin.enableTable(this.originalTableName);
            UTIL.waitTableAvailable(this.originalTableName);
        }
        this.admin.cloneSnapshot(this.snapshotName, this.cloneTableName);
        UTIL.waitUntilAllRegionsAssigned(this.cloneTableName);
    }

    private void runTestSnapshotAppendIndependent() throws Exception {
        try (Table clonedTable = UTIL.getConnection().getTable(this.cloneTableName);){
            int clonedTableRowCount = this.countRows(clonedTable, new byte[0][]);
            Assert.assertEquals((String)"The line counts of original and cloned tables do not match after clone. ", (long)this.countOriginalTable, (long)clonedTableRowCount);
            Put p = new Put(Bytes.toBytes((String)("new-row-" + EnvironmentEdgeManager.currentTime())));
            p.addColumn(TEST_FAM, Bytes.toBytes((String)"someQualifier"), Bytes.toBytes((String)"someString"));
            this.originalTable.put(p);
            Assert.assertEquals((String)"The row count of the original table was not modified by the put", (long)(this.countOriginalTable + 1), (long)this.countRows(this.originalTable, new byte[0][]));
            Assert.assertEquals((String)"The row count of the cloned table changed as a result of addition to the original", (long)clonedTableRowCount, (long)this.countRows(clonedTable, new byte[0][]));
            Put p2 = new Put(Bytes.toBytes((String)("new-row-" + EnvironmentEdgeManager.currentTime())));
            p2.addColumn(TEST_FAM, Bytes.toBytes((String)"someQualifier"), Bytes.toBytes((String)"someString"));
            clonedTable.put(p2);
            Assert.assertEquals((String)"The row count of the original table was modified by the put to the clone", (long)(this.countOriginalTable + 1), (long)this.countRows(this.originalTable, new byte[0][]));
            Assert.assertEquals((String)"The row count of the cloned table was not modified by the put", (long)(clonedTableRowCount + 1), (long)this.countRows(clonedTable, new byte[0][]));
        }
    }

    private void runTestRegionOperationsIndependent() throws Exception {
        ((ClusterConnection)UTIL.getConnection()).clearRegionCache();
        List originalTableHRegions = this.admin.getTableRegions(this.originalTableName);
        int originalRegionCount = originalTableHRegions.size();
        int cloneTableRegionCount = this.admin.getTableRegions(this.cloneTableName).size();
        Assert.assertEquals((String)"The number of regions in the cloned table is different than in the original table.", (long)originalRegionCount, (long)cloneTableRegionCount);
        this.admin.splitRegionAsync(((HRegionInfo)originalTableHRegions.get(0)).getRegionName()).get();
        TestSnapshotCloneIndependence.waitOnSplit(UTIL.getConnection(), this.originalTable, originalRegionCount);
        int cloneTableRegionCount2 = this.admin.getTableRegions(this.cloneTableName).size();
        Assert.assertEquals((String)"The number of regions in the cloned table changed though none of its regions were split.", (long)cloneTableRegionCount, (long)cloneTableRegionCount2);
    }

    private void runTestSnapshotMetadataChangesIndependent() throws Exception {
        byte[] TEST_FAM_2 = Bytes.toBytes((String)"fam2");
        HColumnDescriptor hcd = new HColumnDescriptor(TEST_FAM_2);
        this.admin.disableTable(this.originalTableName);
        this.admin.addColumnFamily(this.originalTableName, (ColumnFamilyDescriptor)hcd);
        this.admin.enableTable(this.originalTableName);
        UTIL.waitTableAvailable(this.originalTableName);
        HTableDescriptor originalTableDescriptor = this.originalTable.getTableDescriptor();
        HTableDescriptor clonedTableDescriptor = this.admin.getTableDescriptor(this.cloneTableName);
        Assert.assertTrue((String)"The original family was not found. There is something wrong. ", (boolean)originalTableDescriptor.hasFamily(TEST_FAM));
        Assert.assertTrue((String)"The original family was not found in the clone. There is something wrong. ", (boolean)clonedTableDescriptor.hasFamily(TEST_FAM));
        Assert.assertTrue((String)"The new family was not found. ", (boolean)originalTableDescriptor.hasFamily(TEST_FAM_2));
        Assert.assertTrue((String)"The new family was not found. ", (!clonedTableDescriptor.hasFamily(TEST_FAM_2) ? 1 : 0) != 0);
    }

    private void runTestSnapshotDeleteIndependent() throws Exception {
        this.admin.majorCompact(this.originalTableName);
        this.admin.deleteSnapshot(this.snapshotName);
        Pattern pattern = Pattern.compile(this.snapshotNameAsString);
        do {
            Thread.sleep(5000L);
        } while (!this.admin.listSnapshots(pattern).isEmpty());
        try (Table original = UTIL.getConnection().getTable(this.originalTableName);
             Table clonedTable = UTIL.getConnection().getTable(this.cloneTableName);){
            int origTableRowCount = this.countRows(original, new byte[0][]);
            int clonedTableRowCount = this.countRows(clonedTable, new byte[0][]);
            Assert.assertEquals((long)origTableRowCount, (long)clonedTableRowCount);
        }
    }

    protected Table createTable(TableName table, byte[] family) throws Exception {
        Table t = UTIL.createTable(table, family);
        UTIL.waitUntilAllRegionsAssigned(table);
        return t;
    }

    public void loadData(Table table, byte[] ... families) throws Exception {
        UTIL.loadTable(this.originalTable, TEST_FAM);
    }

    protected int countRows(Table table, byte[] ... families) throws Exception {
        return UTIL.countRows(table, families);
    }
}

