/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.conf;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.http.HttpServer2;

@InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce"})
@InterfaceStability.Unstable
public class ConfServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    protected static final String FORMAT_JSON = "json";
    protected static final String FORMAT_XML = "xml";

    private Configuration getConfFromContext() {
        Configuration conf = (Configuration)this.getServletContext().getAttribute("hadoop.conf");
        assert (conf != null);
        return conf;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (!HttpServer2.isInstrumentationAccessAllowed(this.getServletContext(), request, response)) {
            return;
        }
        String format = ConfServlet.parseAccecptHeader(request);
        if (FORMAT_XML.equals(format)) {
            response.setContentType("text/xml; charset=utf-8");
        } else if (FORMAT_JSON.equals(format)) {
            response.setContentType("application/json; charset=utf-8");
        }
        String name = request.getParameter("name");
        PrintWriter out = response.getWriter();
        try {
            ConfServlet.writeResponse(this.getConfFromContext(), out, format, name);
        }
        catch (BadFormatException bfe) {
            response.sendError(400, bfe.getMessage());
        }
        catch (IllegalArgumentException iae) {
            response.sendError(404, iae.getMessage());
        }
        ((Writer)out).close();
    }

    @VisibleForTesting
    static String parseAccecptHeader(HttpServletRequest request) {
        String format = request.getHeader("Accept");
        return format != null && format.contains(FORMAT_JSON) ? FORMAT_JSON : FORMAT_XML;
    }

    static void writeResponse(Configuration conf, Writer out, String format, String propertyName) throws IOException, IllegalArgumentException, BadFormatException {
        if (FORMAT_JSON.equals(format)) {
            Configuration.dumpConfiguration(conf, propertyName, out);
        } else if (FORMAT_XML.equals(format)) {
            conf.writeXml(propertyName, out);
        } else {
            throw new BadFormatException("Bad format: " + format);
        }
    }

    static void writeResponse(Configuration conf, Writer out, String format) throws IOException, BadFormatException {
        ConfServlet.writeResponse(conf, out, format, null);
    }

    public static class BadFormatException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public BadFormatException(String msg) {
            super(msg);
        }
    }
}

