/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.zookeeper;

import java.io.IOException;
import java.util.Properties;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.zookeeper.ZKConfig;
import org.apache.hbase.thirdparty.com.google.common.collect.ImmutableSet;
import org.apache.zookeeper.client.ZKClientConfig;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MiscTests.class, SmallTests.class})
public class TestZKConfig {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestZKConfig.class);
    private static final Set<String> ZOOKEEPER_CLIENT_TLS_PROPERTIES = ImmutableSet.of((Object)"client.secure", (Object)"clientCnxnSocket", (Object)"ssl.keyStore.location", (Object)"ssl.keyStore.password", (Object)"ssl.keyStore.passwordPath", (Object)"ssl.keyStore.type", (Object[])new String[]{"ssl.trustStore.location", "ssl.trustStore.password", "ssl.trustStore.passwordPath", "ssl.trustStore.type"});

    @Test
    public void testZKConfigLoading() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        conf.setInt("hbase.zookeeper.property.clientPort", 2181);
        Properties props = ZKConfig.makeZKProps((Configuration)conf);
        Assert.assertEquals((String)"Property client port should have been default from the HBase config", (Object)"2181", (Object)props.getProperty("clientPort"));
    }

    @Test
    public void testGetZooKeeperClusterKey() {
        Configuration conf = HBaseConfiguration.create();
        conf.set("hbase.zookeeper.quorum", "\tlocalhost\n");
        conf.set("hbase.zookeeper.property.clientPort", "3333");
        conf.set("zookeeper.znode.parent", "hbase");
        String clusterKey = ZKConfig.getZooKeeperClusterKey((Configuration)conf, (String)"test");
        Assert.assertTrue((!clusterKey.contains("\t") && !clusterKey.contains("\n") ? 1 : 0) != 0);
        Assert.assertEquals((Object)"localhost:3333:hbase,test", (Object)clusterKey);
    }

    @Test
    public void testClusterKey() throws Exception {
        this.testKey("server", 2181, "/hbase");
        this.testKey("server1,server2,server3", 2181, "/hbase");
        try {
            ZKConfig.validateClusterKey((String)"2181:/hbase");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testClusterKeyWithMultiplePorts() throws Exception {
        this.testKey("server1:2182", 2181, "/hbase", true);
        this.testKey("server1:2182,server2:2183,server3:2184", 2181, "/hbase", true);
        this.testKey("server1:2182,server2,server3:2184", 2181, "/hbase", true);
        this.testKey("server1:2182,server2:2183,server3", 2181, "/hbase", true);
        this.testKey("server1:2182,server2,server3:2184,server4", 2181, "/hbase", true);
        this.testKey("server1:2182,server1:2183,server1", 2181, "/hbase", true);
        this.testKey("server1:2182,server2:2183,server1", 2181, "/hbase", true);
    }

    @Test
    public void testZooKeeperTlsProperties() {
        Configuration conf = HBaseConfiguration.create();
        for (String p : ZOOKEEPER_CLIENT_TLS_PROPERTIES) {
            conf.set("hbase.zookeeper.property." + p, p);
            String zkprop = "zookeeper." + p;
            System.clearProperty(zkprop);
        }
        ZKClientConfig zkClientConfig = ZKConfig.getZKClientConfig((Configuration)conf);
        for (String p : ZOOKEEPER_CLIENT_TLS_PROPERTIES) {
            Assert.assertEquals((String)("Invalid or unset system property: " + p), (Object)p, (Object)zkClientConfig.getProperty("zookeeper." + p));
        }
    }

    @Test
    public void testZooKeeperTlsPropertiesHQuorumPeer() {
        Configuration conf = HBaseConfiguration.create();
        for (String p : ZOOKEEPER_CLIENT_TLS_PROPERTIES) {
            conf.set("hbase.zookeeper.property." + p, p);
            String zkprop = "zookeeper." + p;
            System.clearProperty(zkprop);
        }
        Properties zkProps = ZKConfig.makeZKProps((Configuration)conf);
        for (String p : ZOOKEEPER_CLIENT_TLS_PROPERTIES) {
            Assert.assertEquals((String)("Invalid or unset system property: " + p), (Object)p, (Object)zkProps.getProperty(p));
        }
    }

    private void testKey(String ensemble, int port, String znode) throws IOException {
        this.testKey(ensemble, port, znode, false);
    }

    private void testKey(String ensemble, int port, String znode, Boolean multiplePortSupport) throws IOException {
        Configuration conf = new Configuration();
        String key = ensemble + ":" + port + ":" + znode;
        String ensemble2 = null;
        ZKConfig.ZKClusterKey zkClusterKey = ZKConfig.transformClusterKey((String)key);
        if (multiplePortSupport.booleanValue()) {
            ensemble2 = ZKConfig.standardizeZKQuorumServerString((String)ensemble, (String)Integer.toString(port));
            Assert.assertEquals((Object)ensemble2, (Object)zkClusterKey.getQuorumString());
        } else {
            Assert.assertEquals((Object)ensemble, (Object)zkClusterKey.getQuorumString());
        }
        Assert.assertEquals((long)port, (long)zkClusterKey.getClientPort());
        Assert.assertEquals((Object)znode, (Object)zkClusterKey.getZnodeParent());
        conf = HBaseConfiguration.createClusterConf((Configuration)conf, (String)key);
        Assert.assertEquals((Object)zkClusterKey.getQuorumString(), (Object)conf.get("hbase.zookeeper.quorum"));
        Assert.assertEquals((long)zkClusterKey.getClientPort(), (long)conf.getInt("hbase.zookeeper.property.clientPort", -1));
        Assert.assertEquals((Object)zkClusterKey.getZnodeParent(), (Object)conf.get("zookeeper.znode.parent"));
        String reconstructedKey = ZKConfig.getZooKeeperClusterKey((Configuration)conf);
        if (multiplePortSupport.booleanValue()) {
            String key2 = ensemble2 + ":" + port + ":" + znode;
            Assert.assertEquals((Object)key2, (Object)reconstructedKey);
        } else {
            Assert.assertEquals((Object)key, (Object)reconstructedKey);
        }
    }
}

