/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.regex.Pattern;
import org.apache.hadoop.hbase.ClassFinder;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.jupiter.api.Tag;
import org.junit.runners.Suite;

public class ClassTestFinder
extends ClassFinder {
    public ClassTestFinder() {
        super(new TestFileNameFilter(), new TestFileNameFilter(), new TestClassFilter());
    }

    public ClassTestFinder(Class<?> category) {
        super(new TestFileNameFilter(), new TestFileNameFilter(), new TestClassFilter(category));
    }

    public static Class<?>[] getCategoryAnnotations(Class<?> c) {
        Category category = c.getAnnotation(Category.class);
        if (category != null) {
            return category.value();
        }
        return new Class[0];
    }

    public static String[] getTagAnnotations(Class<?> c) {
        Tag[] tags = (Tag[])c.getAnnotationsByType(Tag.class);
        ArrayList<String> values = new ArrayList<String>();
        for (Tag tag : tags) {
            values.add(tag.value());
        }
        return values.toArray(new String[values.size()]);
    }

    public static class TestClassFilter
    implements ClassFinder.ClassFilter {
        private Class<?> categoryAnnotation = null;

        public TestClassFilter(Class<?> categoryAnnotation) {
            this.categoryAnnotation = categoryAnnotation;
        }

        public TestClassFilter() {
            this(null);
        }

        @Override
        public boolean isCandidateClass(Class<?> c) {
            return this.isTestClass(c) && this.isCategorizedClass(c);
        }

        private boolean isTestClass(Class<?> c) {
            if (Modifier.isAbstract(c.getModifiers())) {
                return false;
            }
            if (c.getAnnotation(Suite.SuiteClasses.class) != null) {
                return true;
            }
            for (Method met : c.getMethods()) {
                if (met.getAnnotation(Test.class) == null && met.getAnnotation(org.junit.jupiter.api.Test.class) == null) continue;
                return true;
            }
            return false;
        }

        private boolean isCategorizedClass(Class<?> c) {
            if (this.categoryAnnotation == null) {
                return true;
            }
            for (Class<?> cc : ClassTestFinder.getCategoryAnnotations(c)) {
                if (!cc.equals(this.categoryAnnotation)) continue;
                return true;
            }
            return false;
        }
    }

    public static class TestFileNameFilter
    implements ClassFinder.FileNameFilter,
    ClassFinder.ResourcePathFilter {
        private static final Pattern hadoopCompactRe = Pattern.compile("hbase-hadoop\\d?-compat");

        @Override
        public boolean isCandidateFile(String fileName, String absFilePath) {
            boolean isTestFile = fileName.startsWith("Test") || fileName.startsWith("IntegrationTest");
            return isTestFile && !hadoopCompactRe.matcher(absFilePath).find();
        }

        @Override
        public boolean isCandidatePath(String resourcePath, boolean isJar) {
            return !hadoopCompactRe.matcher(resourcePath).find();
        }
    }
}

