/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.asyncfs;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutionException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.io.asyncfs.AsyncFSTestBase;
import org.apache.hadoop.hbase.io.asyncfs.FanOutOneBlockAsyncDFSOutput;
import org.apache.hadoop.hbase.io.asyncfs.FanOutOneBlockAsyncDFSOutputHelper;
import org.apache.hadoop.hbase.io.asyncfs.ProtobufDecoder;
import org.apache.hadoop.hbase.io.asyncfs.monitor.StreamSlowMonitor;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hbase.thirdparty.io.netty.buffer.ByteBuf;
import org.apache.hbase.thirdparty.io.netty.channel.Channel;
import org.apache.hbase.thirdparty.io.netty.channel.ChannelHandler;
import org.apache.hbase.thirdparty.io.netty.channel.ChannelHandlerContext;
import org.apache.hbase.thirdparty.io.netty.channel.ChannelInboundHandlerAdapter;
import org.apache.hbase.thirdparty.io.netty.channel.EventLoop;
import org.apache.hbase.thirdparty.io.netty.channel.EventLoopGroup;
import org.apache.hbase.thirdparty.io.netty.channel.nio.NioEventLoopGroup;
import org.apache.hbase.thirdparty.io.netty.channel.socket.nio.NioSocketChannel;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MiscTests.class, MediumTests.class})
public class TestFanOutOneBlockAsyncDFSOutputHang
extends AsyncFSTestBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestFanOutOneBlockAsyncDFSOutputHang.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestFanOutOneBlockAsyncDFSOutputHang.class);
    private static DistributedFileSystem FS;
    private static EventLoopGroup EVENT_LOOP_GROUP;
    private static Class<? extends Channel> CHANNEL_CLASS;
    private static StreamSlowMonitor MONITOR;
    private static FanOutOneBlockAsyncDFSOutput OUT;
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void setUp() throws Exception {
        TestFanOutOneBlockAsyncDFSOutputHang.startMiniDFSCluster(2);
        FS = CLUSTER.getFileSystem();
        EVENT_LOOP_GROUP = new NioEventLoopGroup();
        CHANNEL_CLASS = NioSocketChannel.class;
        MONITOR = StreamSlowMonitor.create((Configuration)UTIL.getConfiguration(), (String)"testMonitor");
        Path f = new Path("/testHang");
        EventLoop eventLoop = EVENT_LOOP_GROUP.next();
        OUT = FanOutOneBlockAsyncDFSOutputHelper.createOutput((DistributedFileSystem)FS, (Path)f, (boolean)true, (boolean)false, (short)2, (long)FS.getDefaultBlockSize(), (EventLoopGroup)eventLoop, CHANNEL_CLASS, (StreamSlowMonitor)MONITOR, (boolean)true);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        if (OUT != null) {
            OUT.recoverAndClose(null);
        }
        if (EVENT_LOOP_GROUP != null) {
            EVENT_LOOP_GROUP.shutdownGracefully().get();
        }
        TestFanOutOneBlockAsyncDFSOutputHang.shutdownMiniDFSCluster();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Test
    public void testFlushHangWhenOneDataNodeFailedBeforeOtherDataNodeAck() throws Exception {
        MiniDFSCluster.DataNodeProperties firstDataNodeProperties = null;
        try {
            final CyclicBarrier dn1AckReceivedCyclicBarrier = new CyclicBarrier(2);
            Map datanodeInfoMap = OUT.getDatanodeInfoMap();
            Iterator iterator = datanodeInfoMap.entrySet().iterator();
            Assert.assertTrue((boolean)iterator.hasNext());
            Map.Entry dn1Entry = iterator.next();
            Channel dn1Channel = (Channel)dn1Entry.getKey();
            DatanodeInfo dn1DatanodeInfo = (DatanodeInfo)dn1Entry.getValue();
            ArrayList protobufDecoderNames = new ArrayList();
            dn1Channel.pipeline().forEach(entry -> {
                if (ProtobufDecoder.class.isInstance(entry.getValue())) {
                    protobufDecoderNames.add(entry.getKey());
                }
            });
            Assert.assertTrue((protobufDecoderNames.size() == 1 ? 1 : 0) != 0);
            dn1Channel.pipeline().addAfter((String)protobufDecoderNames.get(0), "dn1AckReceivedHandler", (ChannelHandler)new ChannelInboundHandlerAdapter(){

                public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                    super.channelRead(ctx, msg);
                    dn1AckReceivedCyclicBarrier.await();
                }
            });
            Assert.assertTrue((boolean)iterator.hasNext());
            Map.Entry dn2Entry = iterator.next();
            Channel dn2Channel = (Channel)dn2Entry.getKey();
            dn2Channel.pipeline().addFirst(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                    if (!(msg instanceof ByteBuf)) {
                        ctx.fireChannelRead(msg);
                    } else {
                        ((ByteBuf)msg).release();
                    }
                }
            }});
            byte[] b = new byte[10];
            Bytes.random((byte[])b);
            OUT.write(b, 0, b.length);
            CompletableFuture future = OUT.flush(false);
            dn1AckReceivedCyclicBarrier.await();
            firstDataNodeProperties = TestFanOutOneBlockAsyncDFSOutputHang.findAndKillFirstDataNode(dn1DatanodeInfo);
            Assert.assertTrue((firstDataNodeProperties != null ? 1 : 0) != 0);
            try {
                future.get();
                Assert.fail();
            }
            catch (ExecutionException e) {
                Assert.assertTrue((e != null ? 1 : 0) != 0);
                LOG.info("expected exception caught when get future", (Throwable)e);
            }
            datanodeInfoMap.keySet().forEach(ch -> {
                try {
                    ch.closeFuture().get();
                }
                catch (InterruptedException | ExecutionException e) {
                    throw new RuntimeException(e);
                }
            });
            if (firstDataNodeProperties == null) return;
        }
        catch (Throwable throwable) {
            if (firstDataNodeProperties == null) throw throwable;
            CLUSTER.restartDataNode(firstDataNodeProperties);
            throw throwable;
        }
        CLUSTER.restartDataNode(firstDataNodeProperties);
    }

    private static MiniDFSCluster.DataNodeProperties findAndKillFirstDataNode(DatanodeInfo firstDatanodeInfo) {
        Assert.assertTrue((firstDatanodeInfo != null ? 1 : 0) != 0);
        ArrayList dataNodes = CLUSTER.getDataNodes();
        ArrayList<Integer> foundIndexes = new ArrayList<Integer>();
        int index = 0;
        for (DataNode dataNode : dataNodes) {
            if (firstDatanodeInfo.getXferAddr().equals(dataNode.getDatanodeId().getXferAddr())) {
                foundIndexes.add(index);
            }
            ++index;
        }
        Assert.assertTrue((foundIndexes.size() == 1 ? 1 : 0) != 0);
        return CLUSTER.stopDataNode(((Integer)foundIndexes.get(0)).intValue());
    }
}

