/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Date;
import javax.servlet.ServletContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.http.HttpServer;
import org.apache.hadoop.hbase.monitoring.StateDumpServlet;
import org.apache.hadoop.hbase.rest.RESTServer;
import org.apache.hadoop.hbase.util.LogMonitoring;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class RESTDumpServlet
extends StateDumpServlet {
    private static final long serialVersionUID = 1L;
    private static final String LINE = "===========================================================";

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (!HttpServer.isInstrumentationAccessAllowed((ServletContext)this.getServletContext(), (HttpServletRequest)request, (HttpServletResponse)response)) {
            return;
        }
        RESTServer restServer = (RESTServer)this.getServletContext().getAttribute("rest");
        assert (restServer != null) : "No REST Server in context!";
        response.setContentType("text/plain");
        ServletOutputStream os = response.getOutputStream();
        try (PrintWriter out = new PrintWriter((OutputStream)os);){
            out.println("REST Server status for " + restServer.getServerName() + " as of " + new Date());
            out.println("\n\nVersion Info:");
            out.println(LINE);
            this.dumpVersionInfo(out);
            out.println("\n\nStacks:");
            out.println(LINE);
            out.flush();
            PrintStream ps = new PrintStream((OutputStream)response.getOutputStream(), false, "UTF-8");
            Threads.printThreadInfo((PrintStream)ps, (String)"");
            ps.flush();
            out.println("\n\nREST Server configuration:");
            out.println(LINE);
            Configuration conf = RESTServer.conf;
            out.flush();
            conf.writeXml((OutputStream)os);
            os.flush();
            out.println("\n\nLogs");
            out.println(LINE);
            long tailKb = this.getTailKbParam(request);
            LogMonitoring.dumpTailOfLogs((PrintWriter)out, (long)tailKb);
            out.flush();
        }
    }
}

