/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.google.common.collect.ImmutableList;
import com.google.protobuf.ByteString;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.fs.XAttr;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.proto.HdfsProtos;
import org.apache.hadoop.hdfs.protocolPB.PBHelperClient;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoContiguous;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.namenode.AclEntryStatusFormat;
import org.apache.hadoop.hdfs.server.namenode.AclFeature;
import org.apache.hadoop.hdfs.server.namenode.DirectoryWithQuotaFeature;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.FSImage;
import org.apache.hadoop.hdfs.server.namenode.FSImageFormatProtobuf;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.FileUnderConstructionFeature;
import org.apache.hadoop.hdfs.server.namenode.FsImageProto;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeAttributes;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectoryAttributes;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.INodeFileAttributes;
import org.apache.hadoop.hdfs.server.namenode.INodeMap;
import org.apache.hadoop.hdfs.server.namenode.INodeReference;
import org.apache.hadoop.hdfs.server.namenode.INodeSymlink;
import org.apache.hadoop.hdfs.server.namenode.INodeWithAdditionalFields;
import org.apache.hadoop.hdfs.server.namenode.QuotaByStorageTypeEntry;
import org.apache.hadoop.hdfs.server.namenode.QuotaCounts;
import org.apache.hadoop.hdfs.server.namenode.SaveNamespaceContext;
import org.apache.hadoop.hdfs.server.namenode.SerialNumberManager;
import org.apache.hadoop.hdfs.server.namenode.XAttrFeature;
import org.apache.hadoop.hdfs.server.namenode.XAttrFormat;
import org.apache.hadoop.hdfs.server.namenode.startupprogress.Phase;
import org.apache.hadoop.hdfs.server.namenode.startupprogress.StartupProgress;
import org.apache.hadoop.hdfs.server.namenode.startupprogress.Step;
import org.apache.hadoop.hdfs.util.EnumCounters;
import org.apache.hadoop.hdfs.util.ReadOnlyList;

@InterfaceAudience.Private
public final class FSImageFormatPBINode {
    private static final Log LOG = LogFactory.getLog(FSImageFormatPBINode.class);
    private static final int DIRECTORY_ENTRY_BATCH_SIZE = 1000;
    public static final int ACL_ENTRY_NAME_MASK = 0xFFFFFF;
    public static final int ACL_ENTRY_NAME_OFFSET = 6;
    public static final int ACL_ENTRY_TYPE_OFFSET = 3;
    public static final int ACL_ENTRY_SCOPE_OFFSET = 5;
    public static final int ACL_ENTRY_PERM_MASK = 7;
    public static final int XATTR_NAMESPACE_MASK = 3;
    public static final int XATTR_NAMESPACE_OFFSET = 30;
    public static final int XATTR_NAME_MASK = 0xFFFFFF;
    public static final int XATTR_NAME_OFFSET = 6;
    public static final int XATTR_NAMESPACE_EXT_OFFSET = 5;
    public static final int XATTR_NAMESPACE_EXT_MASK = 1;

    private FSImageFormatPBINode() {
    }

    public static final class Saver {
        private long numImageErrors;
        private final FSNamesystem fsn;
        private final FsImageProto.FileSummary.Builder summary;
        private final SaveNamespaceContext context;
        private final FSImageFormatProtobuf.Saver parent;

        private static long buildPermissionStatus(INodeAttributes n) {
            return n.getPermissionLong();
        }

        private static FsImageProto.INodeSection.AclFeatureProto.Builder buildAclEntries(AclFeature f) {
            FsImageProto.INodeSection.AclFeatureProto.Builder b = FsImageProto.INodeSection.AclFeatureProto.newBuilder();
            for (int pos = 0; pos < f.getEntriesSize(); ++pos) {
                int e = f.getEntryAt(pos);
                b.addEntries(e);
            }
            return b;
        }

        private static FsImageProto.INodeSection.XAttrFeatureProto.Builder buildXAttrs(XAttrFeature f) {
            FsImageProto.INodeSection.XAttrFeatureProto.Builder b = FsImageProto.INodeSection.XAttrFeatureProto.newBuilder();
            for (XAttr a : f.getXAttrs()) {
                FsImageProto.INodeSection.XAttrCompactProto.Builder xAttrCompactBuilder = FsImageProto.INodeSection.XAttrCompactProto.newBuilder();
                int v = XAttrFormat.toInt(a);
                xAttrCompactBuilder.setName(v);
                if (a.getValue() != null) {
                    xAttrCompactBuilder.setValue(PBHelperClient.getByteString((byte[])a.getValue()));
                }
                b.addXAttrs(xAttrCompactBuilder.build());
            }
            return b;
        }

        private static FsImageProto.INodeSection.QuotaByStorageTypeFeatureProto.Builder buildQuotaByStorageTypeEntries(QuotaCounts q) {
            FsImageProto.INodeSection.QuotaByStorageTypeFeatureProto.Builder b = FsImageProto.INodeSection.QuotaByStorageTypeFeatureProto.newBuilder();
            for (StorageType t : StorageType.getTypesSupportingQuota()) {
                if (q.getTypeSpace(t) < 0L) continue;
                FsImageProto.INodeSection.QuotaByStorageTypeEntryProto.Builder eb = FsImageProto.INodeSection.QuotaByStorageTypeEntryProto.newBuilder().setStorageType(PBHelperClient.convertStorageType((StorageType)t)).setQuota(q.getTypeSpace(t));
                b.addQuotas(eb);
            }
            return b;
        }

        public static FsImageProto.INodeSection.INodeFile.Builder buildINodeFile(INodeFileAttributes file, FSImageFormatProtobuf.SaverContext state) {
            XAttrFeature xAttrFeature;
            FsImageProto.INodeSection.INodeFile.Builder b = FsImageProto.INodeSection.INodeFile.newBuilder().setAccessTime(file.getAccessTime()).setModificationTime(file.getModificationTime()).setPermission(Saver.buildPermissionStatus(file)).setPreferredBlockSize(file.getPreferredBlockSize()).setReplication(file.getFileReplication()).setStoragePolicyID(file.getLocalStoragePolicyID());
            AclFeature f = file.getAclFeature();
            if (f != null) {
                b.setAcl(Saver.buildAclEntries(f));
            }
            if ((xAttrFeature = file.getXAttrFeature()) != null) {
                b.setXAttrs(Saver.buildXAttrs(xAttrFeature));
            }
            return b;
        }

        public static FsImageProto.INodeSection.INodeDirectory.Builder buildINodeDirectory(INodeDirectoryAttributes dir, FSImageFormatProtobuf.SaverContext state) {
            XAttrFeature xAttrFeature;
            AclFeature f;
            QuotaCounts quota = dir.getQuotaCounts();
            FsImageProto.INodeSection.INodeDirectory.Builder b = FsImageProto.INodeSection.INodeDirectory.newBuilder().setModificationTime(dir.getModificationTime()).setNsQuota(quota.getNameSpace()).setDsQuota(quota.getStorageSpace()).setPermission(Saver.buildPermissionStatus(dir));
            if (quota.getTypeSpaces().anyGreaterOrEqual(0L)) {
                b.setTypeQuotas(Saver.buildQuotaByStorageTypeEntries(quota));
            }
            if ((f = dir.getAclFeature()) != null) {
                b.setAcl(Saver.buildAclEntries(f));
            }
            if ((xAttrFeature = dir.getXAttrFeature()) != null) {
                b.setXAttrs(Saver.buildXAttrs(xAttrFeature));
            }
            return b;
        }

        Saver(FSImageFormatProtobuf.Saver parent, FsImageProto.FileSummary.Builder summary) {
            this.parent = parent;
            this.summary = summary;
            this.context = parent.getContext();
            this.fsn = this.context.getSourceNamesystem();
            this.numImageErrors = 0L;
        }

        void serializeINodeDirectorySection(OutputStream out) throws IOException {
            FSDirectory dir = this.fsn.getFSDirectory();
            Iterator<INodeWithAdditionalFields> iter = dir.getINodeMap().getMapIterator();
            ArrayList<INodeReference> refList = this.parent.getSaverContext().getRefList();
            int i = 0;
            int outputInodes = 0;
            while (iter.hasNext()) {
                INodeWithAdditionalFields n = iter.next();
                if (!n.isDirectory()) continue;
                ReadOnlyList<INode> children = n.asDirectory().getChildrenList(0x7FFFFFFE);
                if (children.size() > 0) {
                    FsImageProto.INodeDirectorySection.DirEntry.Builder b = FsImageProto.INodeDirectorySection.DirEntry.newBuilder().setParent(n.getId());
                    for (INode inode : children) {
                        if (dir.getInode(inode.getId()) == null) {
                            FSImage.LOG.error((Object)("FSImageFormatPBINode#serializeINodeDirectorySection: Dangling child pointer found. Missing INode in inodeMap: id=" + inode.getId() + "; path=" + inode.getFullPathName() + "; parent=" + (inode.getParent() == null ? "null" : inode.getParent().getFullPathName())));
                            ++this.numImageErrors;
                        }
                        if (!inode.isReference()) {
                            b.addChildren(inode.getId());
                        } else {
                            refList.add(inode.asReference());
                            b.addRefChildren(refList.size() - 1);
                        }
                        ++outputInodes;
                    }
                    FsImageProto.INodeDirectorySection.DirEntry e = b.build();
                    e.writeDelimitedTo(out);
                }
                if (++i % 4096 == 0) {
                    this.context.checkCancelled();
                }
                if (outputInodes < this.parent.getInodesPerSubSection()) continue;
                outputInodes = 0;
                this.parent.commitSubSection(this.summary, FSImageFormatProtobuf.SectionName.INODE_DIR_SUB);
            }
            this.parent.commitSectionAndSubSection(this.summary, FSImageFormatProtobuf.SectionName.INODE_DIR, FSImageFormatProtobuf.SectionName.INODE_DIR_SUB);
        }

        void serializeINodeSection(OutputStream out) throws IOException {
            INodeMap inodesMap = this.fsn.dir.getINodeMap();
            FsImageProto.INodeSection.Builder b = FsImageProto.INodeSection.newBuilder().setLastInodeId(this.fsn.dir.getLastInodeId()).setNumInodes(inodesMap.size());
            FsImageProto.INodeSection s = b.build();
            s.writeDelimitedTo(out);
            int i = 0;
            Iterator<INodeWithAdditionalFields> iter = inodesMap.getMapIterator();
            while (iter.hasNext()) {
                INodeWithAdditionalFields n = iter.next();
                this.save(out, n);
                if (++i % 4096 == 0) {
                    this.context.checkCancelled();
                }
                if (i % this.parent.getInodesPerSubSection() != 0) continue;
                this.parent.commitSubSection(this.summary, FSImageFormatProtobuf.SectionName.INODE_SUB);
            }
            this.parent.commitSectionAndSubSection(this.summary, FSImageFormatProtobuf.SectionName.INODE, FSImageFormatProtobuf.SectionName.INODE_SUB);
        }

        void serializeFilesUCSection(OutputStream out) throws IOException {
            Collection<Long> filesWithUC = this.fsn.getLeaseManager().getINodeIdWithLeases();
            for (Long id : filesWithUC) {
                INode inode = this.fsn.getFSDirectory().getInode(id);
                if (inode == null) {
                    LOG.warn((Object)("Fail to find inode " + id + " when saving the leases."));
                    continue;
                }
                INodeFile file = inode.asFile();
                if (!file.isUnderConstruction()) {
                    LOG.warn((Object)("Fail to save the lease for inode id " + id + " as the file is not under construction"));
                    continue;
                }
                String path = file.getFullPathName();
                FsImageProto.FilesUnderConstructionSection.FileUnderConstructionEntry.Builder b = FsImageProto.FilesUnderConstructionSection.FileUnderConstructionEntry.newBuilder().setInodeId(file.getId()).setFullPath(path);
                FsImageProto.FilesUnderConstructionSection.FileUnderConstructionEntry e = b.build();
                e.writeDelimitedTo(out);
            }
            this.parent.commitSection(this.summary, FSImageFormatProtobuf.SectionName.FILES_UNDERCONSTRUCTION);
        }

        private void save(OutputStream out, INode n) throws IOException {
            if (n.isDirectory()) {
                this.save(out, n.asDirectory());
            } else if (n.isFile()) {
                this.save(out, n.asFile());
            } else if (n.isSymlink()) {
                this.save(out, n.asSymlink());
            }
        }

        private void save(OutputStream out, INodeDirectory n) throws IOException {
            FsImageProto.INodeSection.INodeDirectory.Builder b = Saver.buildINodeDirectory(n, this.parent.getSaverContext());
            FsImageProto.INodeSection.INode r = this.buildINodeCommon(n).setType(FsImageProto.INodeSection.INode.Type.DIRECTORY).setDirectory(b).build();
            r.writeDelimitedTo(out);
        }

        private void save(OutputStream out, INodeFile n) throws IOException {
            FileUnderConstructionFeature uc;
            FsImageProto.INodeSection.INodeFile.Builder b = Saver.buildINodeFile(n, this.parent.getSaverContext());
            if (n.getBlocks() != null) {
                for (BlockInfo block : n.getBlocks()) {
                    b.addBlocks(PBHelperClient.convert((Block)block));
                }
            }
            if ((uc = n.getFileUnderConstructionFeature()) != null) {
                FsImageProto.INodeSection.FileUnderConstructionFeature f = FsImageProto.INodeSection.FileUnderConstructionFeature.newBuilder().setClientName(uc.getClientName()).setClientMachine(uc.getClientMachine()).build();
                b.setFileUC(f);
            }
            FsImageProto.INodeSection.INode r = this.buildINodeCommon(n).setType(FsImageProto.INodeSection.INode.Type.FILE).setFile(b).build();
            r.writeDelimitedTo(out);
        }

        private void save(OutputStream out, INodeSymlink n) throws IOException {
            FsImageProto.INodeSection.INodeSymlink.Builder b = FsImageProto.INodeSection.INodeSymlink.newBuilder().setPermission(Saver.buildPermissionStatus(n)).setTarget(ByteString.copyFrom((byte[])n.getSymlink())).setModificationTime(n.getModificationTime()).setAccessTime(n.getAccessTime());
            FsImageProto.INodeSection.INode r = this.buildINodeCommon(n).setType(FsImageProto.INodeSection.INode.Type.SYMLINK).setSymlink(b).build();
            r.writeDelimitedTo(out);
        }

        private final FsImageProto.INodeSection.INode.Builder buildINodeCommon(INode n) {
            return FsImageProto.INodeSection.INode.newBuilder().setId(n.getId()).setName(ByteString.copyFrom((byte[])n.getLocalNameBytes()));
        }

        public long getNumImageErrors() {
            return this.numImageErrors;
        }
    }

    public static final class Loader {
        private final FSDirectory dir;
        private final FSNamesystem fsn;
        private final FSImageFormatProtobuf.Loader parent;
        private ReentrantLock cacheNameMapLock;
        private ReentrantLock blockMapLock;

        public static PermissionStatus loadPermission(long id, SerialNumberManager.StringTable stringTable) {
            return INodeWithAdditionalFields.PermissionStatusFormat.toPermissionStatus(id, stringTable);
        }

        public static ImmutableList<AclEntry> loadAclEntries(FsImageProto.INodeSection.AclFeatureProto proto, SerialNumberManager.StringTable stringTable) {
            ImmutableList.Builder b = ImmutableList.builder();
            for (int v : proto.getEntriesList()) {
                b.add((Object)AclEntryStatusFormat.toAclEntry(v, stringTable));
            }
            return b.build();
        }

        public static List<XAttr> loadXAttrs(FsImageProto.INodeSection.XAttrFeatureProto proto, SerialNumberManager.StringTable stringTable) {
            ArrayList<XAttr> b = new ArrayList<XAttr>();
            for (FsImageProto.INodeSection.XAttrCompactProto xAttrCompactProto : proto.getXAttrsList()) {
                int v = xAttrCompactProto.getName();
                byte[] value = null;
                if (xAttrCompactProto.getValue() != null) {
                    value = xAttrCompactProto.getValue().toByteArray();
                }
                b.add(XAttrFormat.toXAttr(v, value, stringTable));
            }
            return b;
        }

        public static ImmutableList<QuotaByStorageTypeEntry> loadQuotaByStorageTypeEntries(FsImageProto.INodeSection.QuotaByStorageTypeFeatureProto proto) {
            ImmutableList.Builder b = ImmutableList.builder();
            for (FsImageProto.INodeSection.QuotaByStorageTypeEntryProto quotaEntry : proto.getQuotasList()) {
                StorageType type = PBHelperClient.convertStorageType((HdfsProtos.StorageTypeProto)quotaEntry.getStorageType());
                long quota = quotaEntry.getQuota();
                b.add((Object)new QuotaByStorageTypeEntry.Builder().setStorageType(type).setQuota(quota).build());
            }
            return b.build();
        }

        public static INodeDirectory loadINodeDirectory(FsImageProto.INodeSection.INode n, FSImageFormatProtobuf.LoaderContext state) {
            assert (n.getType() == FsImageProto.INodeSection.INode.Type.DIRECTORY);
            FsImageProto.INodeSection.INodeDirectory d = n.getDirectory();
            PermissionStatus permissions = Loader.loadPermission(d.getPermission(), state.getStringTable());
            INodeDirectory dir = new INodeDirectory(n.getId(), n.getName().toByteArray(), permissions, d.getModificationTime());
            long nsQuota = d.getNsQuota();
            long dsQuota = d.getDsQuota();
            if (nsQuota >= 0L || dsQuota >= 0L) {
                dir.addDirectoryWithQuotaFeature(new DirectoryWithQuotaFeature.Builder().nameSpaceQuota(nsQuota).storageSpaceQuota(dsQuota).build());
            }
            EnumCounters<StorageType> typeQuotas = null;
            if (d.hasTypeQuotas()) {
                ImmutableList<QuotaByStorageTypeEntry> qes = Loader.loadQuotaByStorageTypeEntries(d.getTypeQuotas());
                typeQuotas = new EnumCounters<StorageType>(StorageType.class, -1L);
                for (QuotaByStorageTypeEntry qe : qes) {
                    if (qe.getQuota() < 0L || qe.getStorageType() == null || !qe.getStorageType().supportTypeQuota()) continue;
                    typeQuotas.set(qe.getStorageType(), qe.getQuota());
                }
                if (typeQuotas.anyGreaterOrEqual(0L)) {
                    DirectoryWithQuotaFeature q = dir.getDirectoryWithQuotaFeature();
                    if (q == null) {
                        dir.addDirectoryWithQuotaFeature(new DirectoryWithQuotaFeature.Builder().typeQuotas(typeQuotas).build());
                    } else {
                        q.setQuota(typeQuotas);
                    }
                }
            }
            if (d.hasAcl()) {
                int[] entries = AclEntryStatusFormat.toInt(Loader.loadAclEntries(d.getAcl(), state.getStringTable()));
                dir.addAclFeature(new AclFeature(entries));
            }
            if (d.hasXAttrs()) {
                dir.addXAttrFeature(new XAttrFeature(Loader.loadXAttrs(d.getXAttrs(), state.getStringTable())));
            }
            return dir;
        }

        public static void updateBlocksMap(INodeFile file, BlockManager bm) {
            BlockInfo[] blocks = file.getBlocks();
            if (blocks != null) {
                for (int i = 0; i < blocks.length; ++i) {
                    file.setBlock(i, bm.addBlockCollection(blocks[i], file));
                }
            }
        }

        Loader(FSNamesystem fsn, FSImageFormatProtobuf.Loader parent) {
            this.fsn = fsn;
            this.dir = fsn.dir;
            this.parent = parent;
            this.cacheNameMapLock = new ReentrantLock(true);
            this.blockMapLock = new ReentrantLock(true);
        }

        void loadINodeDirectorySectionInParallel(ExecutorService service, ArrayList<FsImageProto.FileSummary.Section> sections, final String compressionCodec) throws IOException {
            LOG.info((Object)("Loading the INodeDirectory section in parallel with " + sections.size() + " sub-sections"));
            final CountDownLatch latch = new CountDownLatch(sections.size());
            final CopyOnWriteArrayList exceptions = new CopyOnWriteArrayList();
            for (final FsImageProto.FileSummary.Section s : sections) {
                service.submit(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        InputStream ins = null;
                        try {
                            ins = Loader.this.parent.getInputStreamForSection(s, compressionCodec);
                            Loader.this.loadINodeDirectorySection(ins);
                        }
                        catch (Exception e) {
                            LOG.error((Object)"An exception occurred loading INodeDirectories in parallel", (Throwable)e);
                            exceptions.add(new IOException(e));
                        }
                        finally {
                            latch.countDown();
                            try {
                                if (ins != null) {
                                    ins.close();
                                }
                            }
                            catch (IOException ioe) {
                                LOG.warn((Object)"Failed to close the input stream, ignoring", (Throwable)ioe);
                            }
                        }
                    }
                });
            }
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                LOG.error((Object)"Interrupted waiting for countdown latch", (Throwable)e);
                throw new IOException(e);
            }
            if (exceptions.size() != 0) {
                LOG.error((Object)(exceptions.size() + " exceptions occurred loading " + "INodeDirectories"));
                throw (IOException)exceptions.get(0);
            }
            LOG.info((Object)"Completed loading all INodeDirectory sub-sections");
        }

        void loadINodeDirectorySection(InputStream in) throws IOException {
            FsImageProto.INodeDirectorySection.DirEntry e;
            ArrayList<INodeReference> refList = this.parent.getLoaderContext().getRefList();
            ArrayList<INode> inodeList = new ArrayList<INode>();
            while ((e = FsImageProto.INodeDirectorySection.DirEntry.parseDelimitedFrom(in)) != null) {
                INodeDirectory p = this.dir.getInode(e.getParent()).asDirectory();
                Iterator<Number> i$ = e.getChildrenList().iterator();
                while (i$.hasNext()) {
                    long id = i$.next();
                    INode child = this.dir.getInode(id);
                    if (this.addToParent(p, child)) {
                        if (child.isFile()) {
                            inodeList.add(child);
                        }
                        if (inodeList.size() < 1000) continue;
                        this.addToCacheAndBlockMap(inodeList);
                        inodeList.clear();
                        continue;
                    }
                    LOG.warn((Object)("Failed to add the inode " + child.getId() + "to the directory " + p.getId()));
                }
                i$ = e.getRefChildrenList().iterator();
                while (i$.hasNext()) {
                    int refId = (Integer)i$.next();
                    INodeReference ref = (INodeReference)refList.get(refId);
                    if (this.addToParent(p, ref)) {
                        if (ref.isFile()) {
                            inodeList.add(ref);
                        }
                        if (inodeList.size() < 1000) continue;
                        this.addToCacheAndBlockMap(inodeList);
                        inodeList.clear();
                        continue;
                    }
                    LOG.warn((Object)("Failed to add the inode reference " + ref.getId() + " to the directory " + p.getId()));
                }
            }
            this.addToCacheAndBlockMap(inodeList);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addToCacheAndBlockMap(ArrayList<INode> inodeList) {
            try {
                this.cacheNameMapLock.lock();
                for (INode i : inodeList) {
                    this.dir.cacheName(i);
                }
            }
            finally {
                this.cacheNameMapLock.unlock();
            }
            try {
                this.blockMapLock.lock();
                for (INode i : inodeList) {
                    Loader.updateBlocksMap(i.asFile(), this.fsn.getBlockManager());
                }
            }
            finally {
                this.blockMapLock.unlock();
            }
        }

        void loadINodeSection(InputStream in, StartupProgress prog, Step currentStep) throws IOException {
            this.loadINodeSectionHeader(in, prog, currentStep);
            StartupProgress.Counter counter = prog.getCounter(Phase.LOADING_FSIMAGE, currentStep);
            int totalLoaded = this.loadINodesInSection(in, counter);
            LOG.info((Object)("Successfully loaded " + totalLoaded + " inodes"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int loadINodesInSection(InputStream in, StartupProgress.Counter counter) throws IOException {
            FsImageProto.INodeSection.INode p;
            int cntr = 0;
            while ((p = FsImageProto.INodeSection.INode.parseDelimitedFrom(in)) != null) {
                if (p.getId() == 16385L) {
                    Loader loader = this;
                    synchronized (loader) {
                        this.loadRootINode(p);
                    }
                }
                INode n = this.loadINode(p);
                Loader loader = this;
                synchronized (loader) {
                    this.dir.addToInodeMap(n);
                }
                ++cntr;
                if (counter == null) continue;
                counter.increment();
            }
            return cntr;
        }

        private long loadINodeSectionHeader(InputStream in, StartupProgress prog, Step currentStep) throws IOException {
            FsImageProto.INodeSection s = FsImageProto.INodeSection.parseDelimitedFrom(in);
            this.fsn.dir.resetLastInodeId(s.getLastInodeId());
            long numInodes = s.getNumInodes();
            LOG.info((Object)("Loading " + numInodes + " INodes."));
            prog.setTotal(Phase.LOADING_FSIMAGE, currentStep, numInodes);
            return numInodes;
        }

        void loadINodeSectionInParallel(ExecutorService service, ArrayList<FsImageProto.FileSummary.Section> sections, String compressionCodec, final StartupProgress prog, final Step currentStep) throws IOException {
            LOG.info((Object)("Loading the INode section in parallel with " + sections.size() + " sub-sections"));
            long expectedInodes = 0L;
            final CountDownLatch latch = new CountDownLatch(sections.size());
            final AtomicInteger totalLoaded = new AtomicInteger(0);
            final CopyOnWriteArrayList exceptions = new CopyOnWriteArrayList();
            for (int i = 0; i < sections.size(); ++i) {
                FsImageProto.FileSummary.Section s = sections.get(i);
                final InputStream ins = this.parent.getInputStreamForSection(s, compressionCodec);
                if (i == 0) {
                    expectedInodes = this.loadINodeSectionHeader(ins, prog, currentStep);
                }
                service.submit(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            totalLoaded.addAndGet(Loader.this.loadINodesInSection(ins, null));
                            prog.setCount(Phase.LOADING_FSIMAGE, currentStep, totalLoaded.get());
                        }
                        catch (Exception e) {
                            LOG.error((Object)"An exception occurred loading INodes in parallel", (Throwable)e);
                            exceptions.add(new IOException(e));
                        }
                        finally {
                            latch.countDown();
                            try {
                                ins.close();
                            }
                            catch (IOException ioe) {
                                LOG.warn((Object)"Failed to close the input stream, ignoring", (Throwable)ioe);
                            }
                        }
                    }
                });
            }
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                LOG.info((Object)"Interrupted waiting for countdown latch");
            }
            if (exceptions.size() != 0) {
                LOG.error((Object)(exceptions.size() + " exceptions occurred loading INodes"));
                throw (IOException)exceptions.get(0);
            }
            if ((long)totalLoaded.get() != expectedInodes) {
                throw new IOException("Expected to load " + expectedInodes + " in " + "parallel, but loaded " + totalLoaded.get() + ". The image may " + "be corrupt.");
            }
            LOG.info((Object)("Completed loading all INode sections. Loaded " + totalLoaded.get() + " inodes."));
        }

        void loadFilesUnderConstructionSection(InputStream in) throws IOException {
            FsImageProto.FilesUnderConstructionSection.FileUnderConstructionEntry entry;
            while ((entry = FsImageProto.FilesUnderConstructionSection.FileUnderConstructionEntry.parseDelimitedFrom(in)) != null) {
            }
        }

        private boolean addToParent(INodeDirectory parentDir, INode child) {
            if (parentDir == this.dir.rootDir && FSDirectory.isReservedName(child)) {
                throw new HadoopIllegalArgumentException("File name \"" + child.getLocalName() + "\" is reserved. Please " + " change the name of the existing file or directory to another " + "name before upgrading to this release.");
            }
            return parentDir.addChild(child);
        }

        private INode loadINode(FsImageProto.INodeSection.INode n) {
            switch (n.getType()) {
                case FILE: {
                    return this.loadINodeFile(n);
                }
                case DIRECTORY: {
                    return Loader.loadINodeDirectory(n, this.parent.getLoaderContext());
                }
                case SYMLINK: {
                    return this.loadINodeSymlink(n);
                }
            }
            return null;
        }

        private INodeFile loadINodeFile(FsImageProto.INodeSection.INode n) {
            assert (n.getType() == FsImageProto.INodeSection.INode.Type.FILE);
            FsImageProto.INodeSection.INodeFile f = n.getFile();
            List<HdfsProtos.BlockProto> bp = f.getBlocksList();
            short replication = (short)f.getReplication();
            FSImageFormatProtobuf.LoaderContext state = this.parent.getLoaderContext();
            BlockInfo[] blocks = new BlockInfo[bp.size()];
            int e = bp.size();
            for (int i = 0; i < e; ++i) {
                blocks[i] = new BlockInfoContiguous(PBHelperClient.convert((HdfsProtos.BlockProto)bp.get(i)), replication);
            }
            PermissionStatus permissions = Loader.loadPermission(f.getPermission(), this.parent.getLoaderContext().getStringTable());
            INodeFile file = new INodeFile(n.getId(), n.getName().toByteArray(), permissions, f.getModificationTime(), f.getAccessTime(), blocks, replication, f.getPreferredBlockSize(), (byte)f.getStoragePolicyID());
            if (f.hasAcl()) {
                int[] entries = AclEntryStatusFormat.toInt(Loader.loadAclEntries(f.getAcl(), state.getStringTable()));
                file.addAclFeature(new AclFeature(entries));
            }
            if (f.hasXAttrs()) {
                file.addXAttrFeature(new XAttrFeature(Loader.loadXAttrs(f.getXAttrs(), state.getStringTable())));
            }
            if (f.hasFileUC()) {
                FsImageProto.INodeSection.FileUnderConstructionFeature uc = f.getFileUC();
                file.toUnderConstruction(uc.getClientName(), uc.getClientMachine());
                this.fsn.leaseManager.addLease(uc.getClientName(), file.getId());
                if (blocks.length > 0) {
                    BlockInfo lastBlk = file.getLastBlock();
                    lastBlk.convertToBlockUnderConstruction(HdfsServerConstants.BlockUCState.UNDER_CONSTRUCTION, null);
                }
            }
            return file;
        }

        private INodeSymlink loadINodeSymlink(FsImageProto.INodeSection.INode n) {
            assert (n.getType() == FsImageProto.INodeSection.INode.Type.SYMLINK);
            FsImageProto.INodeSection.INodeSymlink s = n.getSymlink();
            PermissionStatus permissions = Loader.loadPermission(s.getPermission(), this.parent.getLoaderContext().getStringTable());
            INodeSymlink sym = new INodeSymlink(n.getId(), n.getName().toByteArray(), permissions, s.getModificationTime(), s.getAccessTime(), s.getTarget().toStringUtf8());
            return sym;
        }

        private void loadRootINode(FsImageProto.INodeSection.INode p) {
            XAttrFeature f;
            EnumCounters<StorageType> typeQuotas;
            INodeDirectory root = Loader.loadINodeDirectory(p, this.parent.getLoaderContext());
            QuotaCounts q = root.getQuotaCounts();
            long nsQuota = q.getNameSpace();
            long dsQuota = q.getStorageSpace();
            if (nsQuota != -1L || dsQuota != -1L) {
                this.dir.rootDir.getDirectoryWithQuotaFeature().setQuota(nsQuota, dsQuota);
            }
            if ((typeQuotas = q.getTypeSpaces()).anyGreaterOrEqual(0L)) {
                this.dir.rootDir.getDirectoryWithQuotaFeature().setQuota(typeQuotas);
            }
            this.dir.rootDir.cloneModificationTime(root);
            this.dir.rootDir.clonePermissionStatus(root);
            AclFeature af = (AclFeature)root.getFeature(AclFeature.class);
            if (af != null) {
                this.dir.rootDir.addAclFeature(af);
            }
            if ((f = root.getXAttrFeature()) != null) {
                this.dir.rootDir.addXAttrFeature(f);
            }
            this.dir.addRootDirToEncryptionZone(f);
        }
    }
}

