/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.fsdataset.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.server.datanode.ReplicaInfo;
import org.apache.hadoop.util.AutoCloseableLock;
import org.apache.hadoop.util.LightWeightResizableGSet;

class ReplicaMap {
    private final ReadWriteLock rwLock;
    private final AutoCloseableLock readLock;
    private final AutoCloseableLock writeLock;
    private final Map<String, LightWeightResizableGSet<Block, ReplicaInfo>> map = new HashMap<String, LightWeightResizableGSet<Block, ReplicaInfo>>();

    ReplicaMap(ReadWriteLock lock) {
        if (lock == null) {
            throw new HadoopIllegalArgumentException("Lock to synchronize on cannot be null");
        }
        this.rwLock = lock;
        this.readLock = new AutoCloseableLock(this.rwLock.readLock());
        this.writeLock = new AutoCloseableLock(this.rwLock.writeLock());
    }

    String[] getBlockPoolList() {
        try (AutoCloseableLock l = this.writeLock.acquire();){
            String[] stringArray = this.map.keySet().toArray(new String[this.map.keySet().size()]);
            return stringArray;
        }
    }

    private void checkBlockPool(String bpid) {
        if (bpid == null) {
            throw new IllegalArgumentException("Block Pool Id is null");
        }
    }

    private void checkBlock(Block b) {
        if (b == null) {
            throw new IllegalArgumentException("Block is null");
        }
    }

    ReplicaInfo get(String bpid, Block block) {
        this.checkBlockPool(bpid);
        this.checkBlock(block);
        ReplicaInfo replicaInfo = this.get(bpid, block.getBlockId());
        if (replicaInfo != null && block.getGenerationStamp() == replicaInfo.getGenerationStamp()) {
            return replicaInfo;
        }
        return null;
    }

    ReplicaInfo get(String bpid, long blockId) {
        this.checkBlockPool(bpid);
        try (AutoCloseableLock l = this.writeLock.acquire();){
            LightWeightResizableGSet<Block, ReplicaInfo> m = this.map.get(bpid);
            ReplicaInfo replicaInfo = m != null ? (ReplicaInfo)m.get((Object)new Block(blockId)) : null;
            return replicaInfo;
        }
    }

    ReplicaInfo add(String bpid, ReplicaInfo replicaInfo) {
        this.checkBlockPool(bpid);
        this.checkBlock(replicaInfo);
        try (AutoCloseableLock l = this.writeLock.acquire();){
            LightWeightResizableGSet m = this.map.get(bpid);
            if (m == null) {
                m = new LightWeightResizableGSet();
                this.map.put(bpid, (LightWeightResizableGSet<Block, ReplicaInfo>)m);
            }
            ReplicaInfo replicaInfo2 = (ReplicaInfo)m.put((Object)replicaInfo);
            return replicaInfo2;
        }
    }

    ReplicaInfo addAndGet(String bpid, ReplicaInfo replicaInfo) {
        this.checkBlockPool(bpid);
        this.checkBlock(replicaInfo);
        try (AutoCloseableLock l = this.writeLock.acquire();){
            ReplicaInfo oldReplicaInfo;
            LightWeightResizableGSet m = this.map.get(bpid);
            if (m == null) {
                m = new LightWeightResizableGSet();
                this.map.put(bpid, (LightWeightResizableGSet<Block, ReplicaInfo>)m);
            }
            if ((oldReplicaInfo = (ReplicaInfo)m.get((Object)new Block(replicaInfo.getBlockId()))) != null) {
                ReplicaInfo replicaInfo2 = oldReplicaInfo;
                return replicaInfo2;
            }
            m.put((Object)replicaInfo);
            ReplicaInfo replicaInfo3 = replicaInfo;
            return replicaInfo3;
        }
    }

    void addAll(ReplicaMap other) {
        this.map.putAll(other.map);
    }

    void mergeAll(ReplicaMap other) {
        for (String bp : other.getBlockPoolList()) {
            for (ReplicaInfo r : other.map.get(bp)) {
                this.add(bp, r);
            }
        }
    }

    ReplicaInfo remove(String bpid, Block block) {
        this.checkBlockPool(bpid);
        this.checkBlock(block);
        try (AutoCloseableLock l = this.writeLock.acquire();){
            ReplicaInfo replicaInfo;
            LightWeightResizableGSet<Block, ReplicaInfo> m = this.map.get(bpid);
            if (m != null && (replicaInfo = (ReplicaInfo)m.get((Object)block)) != null && block.getGenerationStamp() == replicaInfo.getGenerationStamp()) {
                ReplicaInfo replicaInfo2 = (ReplicaInfo)m.remove((Object)block);
                return replicaInfo2;
            }
        }
        return null;
    }

    ReplicaInfo remove(String bpid, long blockId) {
        this.checkBlockPool(bpid);
        try (AutoCloseableLock l = this.writeLock.acquire();){
            LightWeightResizableGSet<Block, ReplicaInfo> m = this.map.get(bpid);
            if (m != null) {
                ReplicaInfo replicaInfo = (ReplicaInfo)m.remove((Object)new Block(blockId));
                return replicaInfo;
            }
        }
        return null;
    }

    int size(String bpid) {
        LightWeightResizableGSet<Block, ReplicaInfo> m = null;
        try (AutoCloseableLock l = this.writeLock.acquire();){
            m = this.map.get(bpid);
            int n = m != null ? m.size() : 0;
            return n;
        }
    }

    Collection<ReplicaInfo> replicas(String bpid) {
        LightWeightResizableGSet<Block, ReplicaInfo> m = null;
        m = this.map.get(bpid);
        return m != null ? m.values() : null;
    }

    void initBlockPool(String bpid) {
        this.checkBlockPool(bpid);
        try (AutoCloseableLock l = this.writeLock.acquire();){
            LightWeightResizableGSet m = this.map.get(bpid);
            if (m == null) {
                m = new LightWeightResizableGSet();
                this.map.put(bpid, (LightWeightResizableGSet<Block, ReplicaInfo>)m);
            }
        }
    }

    void cleanUpBlockPool(String bpid) {
        this.checkBlockPool(bpid);
        try (AutoCloseableLock l = this.writeLock.acquire();){
            this.map.remove(bpid);
        }
    }

    AutoCloseableLock getLock() {
        return this.writeLock;
    }
}

