/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.DataInput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Optional;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.ByteBufferKeyOnlyKeyValue;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hadoop.hbase.SizeCachedByteBufferKeyValue;
import org.apache.hadoop.hbase.SizeCachedKeyValue;
import org.apache.hadoop.hbase.SizeCachedNoTagsByteBufferKeyValue;
import org.apache.hadoop.hbase.SizeCachedNoTagsKeyValue;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoder;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.io.encoding.HFileBlockDecodingContext;
import org.apache.hadoop.hbase.io.hfile.BlockCache;
import org.apache.hadoop.hbase.io.hfile.BlockCacheKey;
import org.apache.hadoop.hbase.io.hfile.BlockType;
import org.apache.hadoop.hbase.io.hfile.BlockWithScanInfo;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.Cacheable;
import org.apache.hadoop.hbase.io.hfile.CorruptHFileException;
import org.apache.hadoop.hbase.io.hfile.FixedFileTrailer;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileBlock;
import org.apache.hadoop.hbase.io.hfile.HFileBlockIndex;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileDataBlockEncoder;
import org.apache.hadoop.hbase.io.hfile.HFileDataBlockEncoderImpl;
import org.apache.hadoop.hbase.io.hfile.HFileInfo;
import org.apache.hadoop.hbase.io.hfile.HFileScanner;
import org.apache.hadoop.hbase.io.hfile.NoOpDataBlockEncoder;
import org.apache.hadoop.hbase.io.hfile.PrefetchExecutor;
import org.apache.hadoop.hbase.io.hfile.ReaderContext;
import org.apache.hadoop.hbase.monitoring.ThreadLocalServerSideScanMetrics;
import org.apache.hadoop.hbase.nio.ByteBuff;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hadoop.hbase.util.ByteBufferUtils;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.IdLock;
import org.apache.hadoop.hbase.util.ObjectIntPair;
import org.apache.hadoop.io.WritableUtils;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@SuppressWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
public abstract class HFileReaderImpl
implements HFile.Reader,
Configurable {
    private static final Logger LOG = LoggerFactory.getLogger(HFileReaderImpl.class);
    protected HFileBlockIndex.CellBasedKeyBlockIndexReader dataBlockIndexReader;
    protected HFileBlockIndex.ByteArrayKeyBlockIndexReader metaBlockIndexReader;
    protected FixedFileTrailer trailer;
    private final boolean primaryReplicaReader;
    protected HFileDataBlockEncoder dataBlockEncoder = NoOpDataBlockEncoder.INSTANCE;
    protected final CacheConfig cacheConf;
    protected ReaderContext context;
    protected final HFileInfo fileInfo;
    protected final Path path;
    protected final String name;
    private Configuration conf;
    protected HFileContext hfileContext;
    protected HFileBlock.FSReader fsBlockReader;
    private IdLock offsetLock = new IdLock();
    static final int MIN_MINOR_VERSION = 0;
    static final int MAX_MINOR_VERSION = 3;
    static final int MINOR_VERSION_WITH_FAKED_KEY = 3;
    public static final int MINOR_VERSION_WITH_CHECKSUM = 1;
    public static final int MINOR_VERSION_NO_CHECKSUM = 0;
    public static final int PBUF_TRAILER_MINOR_VERSION = 2;
    public static final int KEY_VALUE_LEN_SIZE = 8;

    @SuppressWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public HFileReaderImpl(ReaderContext context, HFileInfo fileInfo, CacheConfig cacheConf, Configuration conf) throws IOException {
        this.cacheConf = cacheConf;
        this.context = context;
        this.path = context.getFilePath();
        this.name = this.path.getName();
        this.conf = conf;
        this.primaryReplicaReader = context.isPrimaryReplicaReader();
        this.fileInfo = fileInfo;
        this.trailer = fileInfo.getTrailer();
        this.hfileContext = fileInfo.getHFileContext();
        this.fsBlockReader = new HFileBlock.FSReaderImpl(context, this.hfileContext, cacheConf.getByteBuffAllocator(), conf);
        this.dataBlockEncoder = HFileDataBlockEncoderImpl.createFromFileInfo(fileInfo);
        this.fsBlockReader.setDataBlockEncoder(this.dataBlockEncoder, conf);
        this.dataBlockIndexReader = fileInfo.getDataBlockIndexReader();
        this.metaBlockIndexReader = fileInfo.getMetaBlockIndexReader();
    }

    private Optional<String> toStringFirstKey() {
        return this.getFirstKey().map(CellUtil::getCellKeyAsString);
    }

    private Optional<String> toStringLastKey() {
        return this.getLastKey().map(CellUtil::getCellKeyAsString);
    }

    public String toString() {
        return "reader=" + this.path.toString() + (!this.isFileInfoLoaded() ? "" : ", compression=" + this.trailer.getCompressionCodec().getName() + ", cacheConf=" + this.cacheConf + ", firstKey=" + this.toStringFirstKey() + ", lastKey=" + this.toStringLastKey()) + ", avgKeyLen=" + this.fileInfo.getAvgKeyLen() + ", avgValueLen=" + this.fileInfo.getAvgValueLen() + ", entries=" + this.trailer.getEntryCount() + ", length=" + this.context.getFileSize();
    }

    @Override
    public long length() {
        return this.context.getFileSize();
    }

    @Override
    public Optional<Cell> getFirstKey() {
        if (this.dataBlockIndexReader == null) {
            throw new BlockIndexNotLoadedException(this.path);
        }
        return this.dataBlockIndexReader.isEmpty() ? Optional.empty() : Optional.of(this.dataBlockIndexReader.getRootBlockKey(0));
    }

    @Override
    public Optional<byte[]> getFirstRowKey() {
        return this.getFirstKey().map(CellUtil::cloneRow);
    }

    @Override
    public Optional<byte[]> getLastRowKey() {
        return this.getLastKey().map(CellUtil::cloneRow);
    }

    @Override
    public long getEntries() {
        return this.trailer.getEntryCount();
    }

    @Override
    public CellComparator getComparator() {
        return this.hfileContext.getCellComparator();
    }

    public Compression.Algorithm getCompressionAlgorithm() {
        return this.trailer.getCompressionCodec();
    }

    @Override
    public long indexSize() {
        return (this.dataBlockIndexReader != null ? this.dataBlockIndexReader.heapSize() : 0L) + (this.metaBlockIndexReader != null ? this.metaBlockIndexReader.heapSize() : 0L);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setDataBlockEncoder(HFileDataBlockEncoder dataBlockEncoder) {
        this.dataBlockEncoder = dataBlockEncoder;
        this.fsBlockReader.setDataBlockEncoder(dataBlockEncoder, this.conf);
    }

    @Override
    public void setDataBlockIndexReader(HFileBlockIndex.CellBasedKeyBlockIndexReader reader) {
        this.dataBlockIndexReader = reader;
    }

    @Override
    public HFileBlockIndex.CellBasedKeyBlockIndexReader getDataBlockIndexReader() {
        return this.dataBlockIndexReader;
    }

    @Override
    public void setMetaBlockIndexReader(HFileBlockIndex.ByteArrayKeyBlockIndexReader reader) {
        this.metaBlockIndexReader = reader;
    }

    @Override
    public HFileBlockIndex.ByteArrayKeyBlockIndexReader getMetaBlockIndexReader() {
        return this.metaBlockIndexReader;
    }

    @Override
    public FixedFileTrailer getTrailer() {
        return this.trailer;
    }

    @Override
    public ReaderContext getContext() {
        return this.context;
    }

    @Override
    public HFileInfo getHFileInfo() {
        return this.fileInfo;
    }

    @Override
    public boolean isPrimaryReplicaReader() {
        return this.primaryReplicaReader;
    }

    @Override
    public Path getPath() {
        return this.path;
    }

    @Override
    public DataBlockEncoding getDataBlockEncoding() {
        return this.dataBlockEncoder.getDataBlockEncoding();
    }

    public Configuration getConf() {
        return this.conf;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InterfaceAudience.LimitedPrivate(value={"Unittest"})
    public HFileBlock getCachedBlock(BlockCacheKey cacheKey, boolean cacheBlock, boolean useLock, boolean updateCacheMetrics, BlockType expectedBlockType, DataBlockEncoding expectedDataBlockEncoding) throws IOException {
        block15: {
            BlockCache cache = this.cacheConf.getBlockCache().orElse(null);
            long cachedBlockBytesRead = 0L;
            if (cache != null) {
                HFileBlock cachedBlock = null;
                boolean isScanMetricsEnabled = ThreadLocalServerSideScanMetrics.isScanMetricsEnabled();
                try {
                    HFileBlock compressedBlock;
                    cachedBlock = (HFileBlock)cache.getBlock(cacheKey, cacheBlock, useLock, updateCacheMetrics);
                    if (cachedBlock == null) break block15;
                    if (this.cacheConf.shouldCacheCompressed(cachedBlock.getBlockType().getCategory()) && (compressedBlock = cachedBlock) != (cachedBlock = compressedBlock.unpack(this.hfileContext, this.fsBlockReader))) {
                        compressedBlock.release();
                    }
                    try {
                        this.validateBlockType(cachedBlock, expectedBlockType);
                    }
                    catch (IOException e) {
                        this.returnAndEvictBlock(cache, cacheKey, cachedBlock);
                        cachedBlock = null;
                        throw e;
                    }
                    if (expectedDataBlockEncoding == null) {
                        HFileBlock e = cachedBlock;
                        return e;
                    }
                    DataBlockEncoding actualDataBlockEncoding = cachedBlock.getDataBlockEncoding();
                    if (cachedBlock.getBlockType().isData() && !actualDataBlockEncoding.equals((Object)expectedDataBlockEncoding)) {
                        if (!expectedDataBlockEncoding.equals((Object)DataBlockEncoding.NONE) && !actualDataBlockEncoding.equals((Object)DataBlockEncoding.NONE)) {
                            LOG.info("Evicting cached block with key {} because data block encoding mismatch; expected {}, actual {}, path={}", new Object[]{cacheKey, actualDataBlockEncoding, expectedDataBlockEncoding, this.path});
                            this.returnAndEvictBlock(cache, cacheKey, cachedBlock);
                        }
                        cachedBlock = null;
                        HFileBlock hFileBlock = null;
                        return hFileBlock;
                    }
                    HFileBlock hFileBlock = cachedBlock;
                    return hFileBlock;
                }
                finally {
                    if (isScanMetricsEnabled && cachedBlock != null) {
                        cachedBlockBytesRead = cachedBlock.getOnDiskSizeWithHeader();
                        if (cachedBlock.getNextBlockOnDiskSize() > 0) {
                            cachedBlockBytesRead += (long)cachedBlock.headerSize();
                        }
                    }
                    if (cachedBlockBytesRead > 0L) {
                        ThreadLocalServerSideScanMetrics.addBytesReadFromBlockCache(cachedBlockBytesRead);
                    }
                }
            }
        }
        return null;
    }

    private void returnAndEvictBlock(BlockCache cache, BlockCacheKey cacheKey, Cacheable block) {
        block.release();
        cache.evictBlock(cacheKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HFileBlock getMetaBlock(String metaBlockName, boolean cacheBlock) throws IOException {
        if (this.trailer.getMetaIndexCount() == 0) {
            return null;
        }
        if (this.metaBlockIndexReader == null) {
            throw new IOException(this.path + " meta index not loaded");
        }
        byte[] mbname = Bytes.toBytes((String)metaBlockName);
        int block = this.metaBlockIndexReader.rootBlockContainingKey(mbname, 0, mbname.length);
        if (block == -1) {
            return null;
        }
        long blockSize = this.metaBlockIndexReader.getRootBlockDataSize(block);
        byte[] byArray = this.metaBlockIndexReader.getRootBlockKey(block);
        synchronized (byArray) {
            HFileBlock uncompressedBlock;
            long metaBlockOffset = this.metaBlockIndexReader.getRootBlockOffset(block);
            BlockCacheKey cacheKey = new BlockCacheKey(this.name, metaBlockOffset, this.isPrimaryReplicaReader(), BlockType.META);
            HFileBlock cachedBlock = this.getCachedBlock(cacheKey, cacheBlock &= this.cacheConf.shouldCacheBlockOnRead(BlockType.META.getCategory()), false, true, BlockType.META, null);
            if (cachedBlock != null) {
                assert (cachedBlock.isUnpacked()) : "Packed block leak.";
                return cachedBlock;
            }
            HFileBlock compressedBlock = this.fsBlockReader.readBlockData(metaBlockOffset, blockSize, true, false, true);
            if (compressedBlock != (uncompressedBlock = compressedBlock.unpack(this.hfileContext, this.fsBlockReader))) {
                compressedBlock.release();
            }
            if (cacheBlock) {
                this.cacheConf.getBlockCache().ifPresent(cache -> cache.cacheBlock(cacheKey, uncompressedBlock, this.cacheConf.isInMemory()));
            }
            return uncompressedBlock;
        }
    }

    private boolean shouldUseHeap(BlockType expectedBlockType, boolean cacheBlock) {
        if (!this.cacheConf.getBlockCache().isPresent()) {
            return false;
        }
        if (expectedBlockType != null) {
            cacheBlock &= this.cacheConf.shouldCacheBlockOnRead(expectedBlockType.getCategory());
        }
        if (!this.cacheConf.isCombinedBlockCache()) {
            return cacheBlock;
        }
        return cacheBlock && expectedBlockType != null && !expectedBlockType.isData();
    }

    @Override
    public HFileBlock readBlock(long dataBlockOffset, long onDiskBlockSize, boolean cacheBlock, boolean pread, boolean isCompaction, boolean updateCacheMetrics, BlockType expectedBlockType, DataBlockEncoding expectedDataBlockEncoding) throws IOException {
        return this.readBlock(dataBlockOffset, onDiskBlockSize, cacheBlock, pread, isCompaction, updateCacheMetrics, expectedBlockType, expectedDataBlockEncoding, false);
    }

    /*
     * Exception decompiling
     */
    @Override
    public HFileBlock readBlock(long dataBlockOffset, long onDiskBlockSize, boolean cacheBlock, boolean pread, boolean isCompaction, boolean updateCacheMetrics, BlockType expectedBlockType, DataBlockEncoding expectedDataBlockEncoding, boolean cacheOnly) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[UNCONDITIONALDOLOOP]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public boolean hasMVCCInfo() {
        return this.fileInfo.shouldIncludeMemStoreTS() && this.fileInfo.isDecodeMemstoreTS();
    }

    private void validateBlockType(HFileBlock block, BlockType expectedBlockType) throws IOException {
        if (expectedBlockType == null) {
            return;
        }
        BlockType actualBlockType = block.getBlockType();
        if (expectedBlockType.isData() && actualBlockType.isData()) {
            return;
        }
        if (actualBlockType != expectedBlockType) {
            throw new IOException("Expected block type " + expectedBlockType + ", but got " + actualBlockType + ": " + block + ", path=" + this.path);
        }
    }

    @Override
    public Optional<Cell> getLastKey() {
        return this.dataBlockIndexReader.isEmpty() ? Optional.empty() : Optional.of(this.fileInfo.getLastKeyCell());
    }

    @Override
    public Optional<Cell> midKey() throws IOException {
        return Optional.ofNullable(this.dataBlockIndexReader.midkey(this));
    }

    @Override
    public void close() throws IOException {
        this.close(this.cacheConf.shouldEvictOnClose());
    }

    @Override
    public DataBlockEncoding getEffectiveEncodingInCache(boolean isCompaction) {
        return this.dataBlockEncoder.getEffectiveEncodingInCache(isCompaction);
    }

    @Override
    public HFileBlock.FSReader getUncachedBlockReader() {
        return this.fsBlockReader;
    }

    @Override
    public DataInput getGeneralBloomFilterMetadata() throws IOException {
        return this.getBloomFilterMetadata(BlockType.GENERAL_BLOOM_META);
    }

    @Override
    public DataInput getDeleteBloomFilterMetadata() throws IOException {
        return this.getBloomFilterMetadata(BlockType.DELETE_FAMILY_BLOOM_META);
    }

    private DataInput getBloomFilterMetadata(BlockType blockType) throws IOException {
        if (blockType != BlockType.GENERAL_BLOOM_META && blockType != BlockType.DELETE_FAMILY_BLOOM_META) {
            throw new RuntimeException("Block Type: " + blockType.toString() + " is not supported, path=" + this.path);
        }
        for (HFileBlock b : this.fileInfo.getLoadOnOpenBlocks()) {
            if (b.getBlockType() != blockType) continue;
            return b.getByteStream();
        }
        return null;
    }

    public boolean isFileInfoLoaded() {
        return true;
    }

    @Override
    public HFileContext getFileContext() {
        return this.hfileContext;
    }

    @Override
    public boolean prefetchComplete() {
        return PrefetchExecutor.isCompleted(this.path);
    }

    @Override
    public boolean prefetchStarted() {
        return PrefetchExecutor.isPrefetchStarted();
    }

    @Override
    public HFileScanner getScanner(Configuration conf, boolean cacheBlocks, boolean pread) {
        return this.getScanner(conf, cacheBlocks, pread, false);
    }

    @Override
    public HFileScanner getScanner(Configuration conf, boolean cacheBlocks, boolean pread, boolean isCompaction) {
        if (this.dataBlockEncoder.useEncodedScanner()) {
            return new EncodedScanner(this, cacheBlocks, pread, isCompaction, this.hfileContext, conf);
        }
        return new HFileScannerImpl(this, cacheBlocks, pread, isCompaction);
    }

    public int getMajorVersion() {
        return 3;
    }

    @Override
    public void unbufferStream() {
        this.fsBlockReader.unbufferStream();
    }

    private /* synthetic */ void lambda$readBlock$3(boolean cacheBlock, BlockType.BlockCategory category, BlockCacheKey cacheKey, boolean cacheCompressed, HFileBlock hfileBlock, HFileBlock unpacked, boolean cacheOnly, BlockCache cache) {
        if (cacheBlock && this.cacheConf.shouldCacheBlockOnRead(category)) {
            cache.cacheBlock(cacheKey, cacheCompressed ? hfileBlock : unpacked, this.cacheConf.isInMemory(), cacheOnly);
        }
    }

    private /* synthetic */ void lambda$readBlock$2(boolean cacheBlock, BlockType.BlockCategory category, BlockCacheKey cacheKey, HFileBlock hfileBlock, boolean cacheOnly, BlockCache cache) {
        if (cacheBlock && this.cacheConf.shouldCacheBlockOnRead(category)) {
            cache.cacheBlock(cacheKey, hfileBlock, this.cacheConf.isInMemory(), cacheOnly);
        }
    }

    private /* synthetic */ void lambda$readBlock$1(BlockCacheKey cacheKey, HFileBlock cachedBlock, BlockCache cache) {
        this.returnAndEvictBlock(cache, cacheKey, cachedBlock);
    }

    protected static class EncodedScanner
    extends HFileScannerImpl {
        private final HFileBlockDecodingContext decodingCtx;
        private final DataBlockEncoder.EncodedSeeker seeker;
        private final DataBlockEncoder dataBlockEncoder;

        public EncodedScanner(HFile.Reader reader, boolean cacheBlocks, boolean pread, boolean isCompaction, HFileContext meta, Configuration conf) {
            super(reader, cacheBlocks, pread, isCompaction);
            DataBlockEncoding encoding = reader.getDataBlockEncoding();
            this.dataBlockEncoder = encoding.getEncoder();
            this.decodingCtx = this.dataBlockEncoder.newDataBlockDecodingContext(conf, meta);
            this.seeker = this.dataBlockEncoder.createSeeker(this.decodingCtx);
        }

        @Override
        public boolean isSeeked() {
            return this.curBlock != null;
        }

        @Override
        public void setNonSeekedState() {
            this.reset();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void updateCurrentBlock(HFileBlock newBlock) throws CorruptHFileException {
            try {
                if (newBlock.getBlockType() != BlockType.ENCODED_DATA) {
                    throw new IllegalStateException("EncodedScanner works only on encoded data blocks");
                }
                short dataBlockEncoderId = newBlock.getDataBlockEncodingId();
                if (!DataBlockEncoding.isCorrectEncoder((DataBlockEncoder)this.dataBlockEncoder, (short)dataBlockEncoderId)) {
                    String encoderCls = this.dataBlockEncoder.getClass().getName();
                    throw new CorruptHFileException("Encoder " + encoderCls + " doesn't support data block encoding " + DataBlockEncoding.getNameFromId((short)dataBlockEncoderId) + ",path=" + this.reader.getPath());
                }
                this.updateCurrBlockRef(newBlock);
                ByteBuff encodedBuffer = this.getEncodedBuffer(newBlock);
                this.seeker.setCurrentBuffer(encodedBuffer);
            }
            finally {
                this.releaseIfNotCurBlock(newBlock);
            }
            this.nextIndexedKey = null;
        }

        private ByteBuff getEncodedBuffer(HFileBlock newBlock) {
            ByteBuff origBlock = newBlock.getBufferReadOnly();
            int pos = newBlock.headerSize() + 2;
            origBlock.position(pos);
            origBlock.limit(pos + newBlock.getUncompressedSizeWithoutHeader() - 2);
            return origBlock.slice();
        }

        @Override
        protected boolean processFirstDataBlock() throws IOException {
            this.seeker.rewind();
            return true;
        }

        @Override
        public boolean next() throws IOException {
            boolean isValid = this.seeker.next();
            if (!isValid) {
                HFileBlock newBlock = this.readNextDataBlock();
                boolean bl = isValid = newBlock != null;
                if (isValid) {
                    this.updateCurrentBlock(newBlock);
                } else {
                    this.setNonSeekedState();
                }
            }
            return isValid;
        }

        @Override
        public Cell getKey() {
            this.assertValidSeek();
            return this.seeker.getKey();
        }

        @Override
        public ByteBuffer getValue() {
            this.assertValidSeek();
            return this.seeker.getValueShallowCopy();
        }

        @Override
        public Cell getCell() {
            if (this.curBlock == null) {
                return null;
            }
            return this.seeker.getCell();
        }

        @Override
        public String getKeyString() {
            return CellUtil.toString((Cell)this.getKey(), (boolean)false);
        }

        @Override
        public String getValueString() {
            ByteBuffer valueBuffer = this.getValue();
            return ByteBufferUtils.toStringBinary((ByteBuffer)valueBuffer);
        }

        private void assertValidSeek() {
            if (this.curBlock == null) {
                throw new NotSeekedException(this.reader.getPath());
            }
        }

        @Override
        protected Cell getFirstKeyCellInBlock(HFileBlock curBlock) {
            return this.dataBlockEncoder.getFirstKeyCellInBlock(this.getEncodedBuffer(curBlock));
        }

        @Override
        protected int loadBlockAndSeekToKey(HFileBlock seekToBlock, Cell nextIndexedKey, boolean rewind, Cell key, boolean seekBefore) throws IOException {
            if (this.curBlock == null || this.curBlock.getOffset() != seekToBlock.getOffset()) {
                this.updateCurrentBlock(seekToBlock);
            } else if (rewind) {
                this.seeker.rewind();
            }
            this.nextIndexedKey = nextIndexedKey;
            return this.seeker.seekToKeyInBlock(key, seekBefore);
        }

        @Override
        public int compareKey(CellComparator comparator, Cell key) {
            return this.seeker.compareKey(comparator, key);
        }
    }

    protected static class HFileScannerImpl
    implements HFileScanner {
        private ByteBuff blockBuffer;
        protected final boolean cacheBlocks;
        protected final boolean pread;
        protected final boolean isCompaction;
        private int currKeyLen;
        private int currValueLen;
        private int currMemstoreTSLen;
        private long currMemstoreTS;
        protected final HFile.Reader reader;
        private int currTagsLen;
        private short rowLen;
        private ByteBufferKeyOnlyKeyValue bufBackedKeyOnlyKv = new ByteBufferKeyOnlyKeyValue();
        final ObjectIntPair<ByteBuffer> pair = new ObjectIntPair();
        protected Cell nextIndexedKey;
        protected HFileBlock curBlock;
        protected final ArrayList<HFileBlock> prevBlocks = new ArrayList();

        public HFileScannerImpl(HFile.Reader reader, boolean cacheBlocks, boolean pread, boolean isCompaction) {
            this.reader = reader;
            this.cacheBlocks = cacheBlocks;
            this.pread = pread;
            this.isCompaction = isCompaction;
        }

        void updateCurrBlockRef(HFileBlock block) {
            if (block != null && this.curBlock != null && block.getOffset() == this.curBlock.getOffset()) {
                return;
            }
            if (this.curBlock != null && this.curBlock.isSharedMem()) {
                this.prevBlocks.add(this.curBlock);
            }
            this.curBlock = block;
        }

        void reset() {
            if (this.curBlock != null && this.curBlock.isSharedMem()) {
                this.prevBlocks.add(this.curBlock);
            }
            this.curBlock = null;
        }

        private void returnBlocks(boolean returnAll) {
            this.prevBlocks.forEach(HFileBlock::release);
            this.prevBlocks.clear();
            if (returnAll && this.curBlock != null) {
                this.curBlock.release();
                this.curBlock = null;
            }
        }

        @Override
        public boolean isSeeked() {
            return this.blockBuffer != null;
        }

        public String toString() {
            return "HFileScanner for reader " + String.valueOf(this.getReader());
        }

        protected void assertSeeked() {
            if (!this.isSeeked()) {
                throw new NotSeekedException(this.reader.getPath());
            }
        }

        @Override
        public HFile.Reader getReader() {
            return this.reader;
        }

        private int getKVBufSize() {
            int kvBufSize = 8 + this.currKeyLen + this.currValueLen;
            if (this.currTagsLen > 0) {
                kvBufSize += 2 + this.currTagsLen;
            }
            return kvBufSize;
        }

        @Override
        public void close() {
            if (!this.pread) {
                this.reader.unbufferStream();
            }
            this.returnBlocks(true);
        }

        private int getCurCellSerializedSize() {
            int curCellSize = 8 + this.currKeyLen + this.currValueLen + this.currMemstoreTSLen;
            if (this.reader.getFileContext().isIncludesTags()) {
                curCellSize += 2 + this.currTagsLen;
            }
            return curCellSize;
        }

        protected void readKeyValueLen() {
            long ll = this.blockBuffer.getLongAfterPosition(0);
            this.currKeyLen = (int)(ll >> 32);
            this.currValueLen = (int)(0xFFFFFFFF00000000L ^ ll);
            this.checkKeyValueLen();
            this.rowLen = this.blockBuffer.getShortAfterPosition(8);
            int p = 8 + this.currKeyLen + this.currValueLen;
            if (this.reader.getFileContext().isIncludesTags()) {
                this.currTagsLen = this.blockBuffer.getShortAfterPosition(p);
                this.checkTagsLen();
                p += 2 + this.currTagsLen;
            }
            this.readMvccVersion(p);
        }

        private final void checkTagsLen() {
            if (this.checkLen(this.currTagsLen)) {
                throw new IllegalStateException("Invalid currTagsLen " + this.currTagsLen + ". Block offset: " + this.curBlock.getOffset() + ", block length: " + this.blockBuffer.limit() + ", position: " + this.blockBuffer.position() + " (without header). path=" + this.reader.getPath());
            }
        }

        protected void readMvccVersion(int offsetFromPos) {
            if (!this.reader.getHFileInfo().shouldIncludeMemStoreTS()) {
                return;
            }
            if (!this.reader.getHFileInfo().isDecodeMemstoreTS()) {
                this.currMemstoreTS = 0L;
                this.currMemstoreTSLen = 1;
                return;
            }
            this._readMvccVersion(offsetFromPos);
        }

        private void _readMvccVersion(int offsetFromPos) {
            byte firstByte = this.blockBuffer.getByteAfterPosition(offsetFromPos);
            int len = WritableUtils.decodeVIntSize((byte)firstByte);
            if (len == 1) {
                this.currMemstoreTS = firstByte;
            } else {
                int remaining = len - 1;
                long i = 0L;
                ++offsetFromPos;
                if (remaining >= 4) {
                    i = (long)this.blockBuffer.getIntAfterPosition(offsetFromPos) & 0xFFFFFFFFL;
                    remaining -= 4;
                    offsetFromPos += 4;
                }
                if (remaining >= 2) {
                    short s = this.blockBuffer.getShortAfterPosition(offsetFromPos);
                    i <<= 16;
                    i |= (long)(s & 0xFFFF);
                    remaining -= 2;
                    offsetFromPos += 2;
                }
                for (int idx = 0; idx < remaining; ++idx) {
                    byte b = this.blockBuffer.getByteAfterPosition(offsetFromPos + idx);
                    i <<= 8;
                    i |= (long)(b & 0xFF);
                }
                this.currMemstoreTS = WritableUtils.isNegativeVInt((byte)firstByte) ? i ^ 0xFFFFFFFFFFFFFFFFL : i;
            }
            this.currMemstoreTSLen = len;
        }

        protected int blockSeek(Cell key, boolean seekBefore) {
            int tlen = 0;
            int lastKeyValueSize = -1;
            do {
                int offsetFromPos = 0;
                long ll = this.blockBuffer.getLongAfterPosition(offsetFromPos);
                int klen = (int)(ll >> 32);
                int vlen = (int)(0xFFFFFFFF00000000L ^ ll);
                if (this.checkKeyLen(klen) || this.checkLen(vlen)) {
                    throw new IllegalStateException("Invalid klen " + klen + " or vlen " + vlen + ". Block offset: " + this.curBlock.getOffset() + ", block length: " + this.blockBuffer.limit() + ", position: " + this.blockBuffer.position() + " (without header). path=" + this.reader.getPath());
                }
                this.rowLen = this.blockBuffer.getShortAfterPosition(offsetFromPos += 8);
                this.blockBuffer.asSubByteBuffer(this.blockBuffer.position() + offsetFromPos, klen, this.pair);
                this.bufBackedKeyOnlyKv.setKey((ByteBuffer)this.pair.getFirst(), this.pair.getSecond(), klen, this.rowLen);
                int comp = PrivateCellUtil.compareKeyIgnoresMvcc((CellComparator)this.reader.getComparator(), (Cell)key, (Cell)this.bufBackedKeyOnlyKv);
                offsetFromPos += klen + vlen;
                if (this.reader.getFileContext().isIncludesTags()) {
                    tlen = (this.blockBuffer.getByteAfterPosition(offsetFromPos) & 0xFF) << 8 ^ this.blockBuffer.getByteAfterPosition(offsetFromPos + 1) & 0xFF;
                    if (this.checkLen(tlen)) {
                        throw new IllegalStateException("Invalid tlen " + tlen + ". Block offset: " + this.curBlock.getOffset() + ", block length: " + this.blockBuffer.limit() + ", position: " + this.blockBuffer.position() + " (without header). path=" + this.reader.getPath());
                    }
                    offsetFromPos += tlen + 2;
                }
                if (this.reader.getHFileInfo().shouldIncludeMemStoreTS()) {
                    this.readMvccVersion(offsetFromPos);
                }
                if (comp == 0) {
                    if (seekBefore) {
                        if (lastKeyValueSize < 0) {
                            throw new IllegalStateException("blockSeek with seekBefore at the first key of the block: key=" + CellUtil.getCellKeyAsString((Cell)key) + ", blockOffset=" + this.curBlock.getOffset() + ", onDiskSize=" + this.curBlock.getOnDiskSizeWithHeader() + ", path=" + this.reader.getPath());
                        }
                        this.blockBuffer.moveBack(lastKeyValueSize);
                        this.readKeyValueLen();
                        return 1;
                    }
                    this.currKeyLen = klen;
                    this.currValueLen = vlen;
                    this.currTagsLen = tlen;
                    return 0;
                }
                if (comp < 0) {
                    if (lastKeyValueSize > 0) {
                        this.blockBuffer.moveBack(lastKeyValueSize);
                    }
                    this.readKeyValueLen();
                    if (lastKeyValueSize == -1 && this.blockBuffer.position() == 0) {
                        return -2;
                    }
                    return 1;
                }
                lastKeyValueSize = klen + vlen + this.currMemstoreTSLen + 8;
                if (this.reader.getFileContext().isIncludesTags()) {
                    lastKeyValueSize += tlen + 2;
                }
                this.blockBuffer.skip(lastKeyValueSize);
            } while (this.blockBuffer.hasRemaining());
            this.blockBuffer.moveBack(lastKeyValueSize);
            this.readKeyValueLen();
            return 1;
        }

        @Override
        public Cell getNextIndexedKey() {
            return this.nextIndexedKey;
        }

        @Override
        public int seekTo(Cell key) throws IOException {
            return this.seekTo(key, true);
        }

        @Override
        public int reseekTo(Cell key) throws IOException {
            if (this.isSeeked()) {
                int compared = this.compareKey(this.reader.getComparator(), key);
                if (compared < 1) {
                    return compared;
                }
                if (this.nextIndexedKey != null && (this.nextIndexedKey == KeyValueScanner.NO_NEXT_INDEXED_KEY || PrivateCellUtil.compareKeyIgnoresMvcc((CellComparator)this.reader.getComparator(), (Cell)key, (Cell)this.nextIndexedKey) < 0)) {
                    return this.loadBlockAndSeekToKey(this.curBlock, this.nextIndexedKey, false, key, false);
                }
            }
            return this.seekTo(key, false);
        }

        public int seekTo(Cell key, boolean rewind) throws IOException {
            HFileBlockIndex.CellBasedKeyBlockIndexReader indexReader = this.reader.getDataBlockIndexReader();
            BlockWithScanInfo blockWithScanInfo = ((HFileBlockIndex.BlockIndexReader)indexReader).loadDataBlockWithScanInfo(key, this.curBlock, this.cacheBlocks, this.pread, this.isCompaction, this.getEffectiveDataBlockEncoding(), this.reader);
            if (blockWithScanInfo == null || blockWithScanInfo.getHFileBlock() == null) {
                return -1;
            }
            return this.loadBlockAndSeekToKey(blockWithScanInfo.getHFileBlock(), blockWithScanInfo.getNextIndexedKey(), rewind, key, false);
        }

        @Override
        public boolean seekBefore(Cell key) throws IOException {
            HFileBlock seekToBlock = this.reader.getDataBlockIndexReader().seekToDataBlock(key, this.curBlock, this.cacheBlocks, this.pread, this.isCompaction, this.reader.getEffectiveEncodingInCache(this.isCompaction), this.reader);
            if (seekToBlock == null) {
                return false;
            }
            Cell firstKey = this.getFirstKeyCellInBlock(seekToBlock);
            if (PrivateCellUtil.compareKeyIgnoresMvcc((CellComparator)this.reader.getComparator(), (Cell)firstKey, (Cell)key) >= 0) {
                long previousBlockOffset = seekToBlock.getPrevBlockOffset();
                if (previousBlockOffset == -1L) {
                    this.releaseIfNotCurBlock(seekToBlock);
                    return false;
                }
                this.releaseIfNotCurBlock(seekToBlock);
                int prevBlockSize = -1;
                seekToBlock = this.reader.readBlock(previousBlockOffset, prevBlockSize, this.cacheBlocks, this.pread, this.isCompaction, true, BlockType.DATA, this.getEffectiveDataBlockEncoding());
            }
            this.loadBlockAndSeekToKey(seekToBlock, firstKey, true, key, true);
            return true;
        }

        protected void releaseIfNotCurBlock(HFileBlock block) {
            if (this.curBlock != block) {
                block.release();
            }
        }

        @SuppressWarnings(value={"NP_NULL_ON_SOME_PATH"}, justification="Yeah, unnecessary null check; could do w/ clean up")
        protected HFileBlock readNextDataBlock() throws IOException {
            long lastDataBlockOffset = this.reader.getTrailer().getLastDataBlockOffset();
            if (this.curBlock == null) {
                return null;
            }
            HFileBlock block = this.curBlock;
            do {
                if (block.getOffset() >= lastDataBlockOffset) {
                    this.releaseIfNotCurBlock(block);
                    return null;
                }
                if (block.getOffset() < 0L) {
                    this.releaseIfNotCurBlock(block);
                    throw new IOException("Invalid block offset=" + block + ", path=" + this.reader.getPath());
                }
                if ((block = this.reader.readBlock(block.getOffset() + (long)block.getOnDiskSizeWithHeader(), block.getNextBlockOnDiskSize(), this.cacheBlocks, this.pread, this.isCompaction, true, null, this.getEffectiveDataBlockEncoding())) == null || block.getBlockType().isData()) continue;
                block.release();
            } while (!block.getBlockType().isData());
            return block;
        }

        public DataBlockEncoding getEffectiveDataBlockEncoding() {
            return this.reader.getEffectiveEncodingInCache(this.isCompaction);
        }

        @Override
        public Cell getCell() {
            ByteBuffer buf;
            if (!this.isSeeked()) {
                return null;
            }
            int cellBufSize = this.getKVBufSize();
            long seqId = 0L;
            if (this.reader.getHFileInfo().shouldIncludeMemStoreTS()) {
                seqId = this.currMemstoreTS;
            }
            Object ret = this.blockBuffer.hasArray() ? (this.currTagsLen > 0 ? new SizeCachedKeyValue(this.blockBuffer.array(), this.blockBuffer.arrayOffset() + this.blockBuffer.position(), cellBufSize, seqId, this.currKeyLen, this.rowLen) : new SizeCachedNoTagsKeyValue(this.blockBuffer.array(), this.blockBuffer.arrayOffset() + this.blockBuffer.position(), cellBufSize, seqId, this.currKeyLen, this.rowLen)) : ((buf = this.blockBuffer.asSubByteBuffer(cellBufSize)).isDirect() ? (this.currTagsLen > 0 ? new SizeCachedByteBufferKeyValue(buf, buf.position(), cellBufSize, seqId, this.currKeyLen, this.rowLen) : new SizeCachedNoTagsByteBufferKeyValue(buf, buf.position(), cellBufSize, seqId, this.currKeyLen, this.rowLen)) : (this.currTagsLen > 0 ? new SizeCachedKeyValue(buf.array(), buf.arrayOffset() + buf.position(), cellBufSize, seqId, this.currKeyLen, this.rowLen) : new SizeCachedNoTagsKeyValue(buf.array(), buf.arrayOffset() + buf.position(), cellBufSize, seqId, this.currKeyLen, this.rowLen)));
            return ret;
        }

        @Override
        public Cell getKey() {
            this.assertSeeked();
            ObjectIntPair keyPair = new ObjectIntPair();
            this.blockBuffer.asSubByteBuffer(this.blockBuffer.position() + 8, this.currKeyLen, keyPair);
            ByteBuffer keyBuf = (ByteBuffer)keyPair.getFirst();
            if (keyBuf.hasArray()) {
                return new KeyValue.KeyOnlyKeyValue(keyBuf.array(), keyBuf.arrayOffset() + keyPair.getSecond(), this.currKeyLen);
            }
            byte[] key = new byte[this.currKeyLen];
            ByteBufferUtils.copyFromBufferToArray((byte[])key, (ByteBuffer)keyBuf, (int)keyPair.getSecond(), (int)0, (int)this.currKeyLen);
            return new KeyValue.KeyOnlyKeyValue(key, 0, this.currKeyLen);
        }

        @Override
        public ByteBuffer getValue() {
            this.assertSeeked();
            ObjectIntPair valuePair = new ObjectIntPair();
            this.blockBuffer.asSubByteBuffer(this.blockBuffer.position() + 8 + this.currKeyLen, this.currValueLen, valuePair);
            ByteBuffer valBuf = ((ByteBuffer)valuePair.getFirst()).duplicate();
            valBuf.position(valuePair.getSecond());
            valBuf.limit(this.currValueLen + valuePair.getSecond());
            return valBuf.slice();
        }

        protected void setNonSeekedState() {
            this.reset();
            this.blockBuffer = null;
            this.currKeyLen = 0;
            this.currValueLen = 0;
            this.currMemstoreTS = 0L;
            this.currMemstoreTSLen = 0;
            this.currTagsLen = 0;
        }

        private void positionThisBlockBuffer() {
            try {
                this.blockBuffer.skip(this.getCurCellSerializedSize());
            }
            catch (IllegalArgumentException e) {
                LOG.error("Current pos = " + this.blockBuffer.position() + "; currKeyLen = " + this.currKeyLen + "; currValLen = " + this.currValueLen + "; block limit = " + this.blockBuffer.limit() + "; currBlock currBlockOffset = " + this.curBlock.getOffset() + "; path=" + this.reader.getPath());
                throw e;
            }
        }

        private boolean positionForNextBlock() throws IOException {
            long lastDataBlockOffset = this.reader.getTrailer().getLastDataBlockOffset();
            if (this.curBlock.getOffset() >= lastDataBlockOffset) {
                this.setNonSeekedState();
                return false;
            }
            return this.isNextBlock();
        }

        private boolean isNextBlock() throws IOException {
            HFileBlock nextBlock = this.readNextDataBlock();
            if (nextBlock == null) {
                this.setNonSeekedState();
                return false;
            }
            this.updateCurrentBlock(nextBlock);
            return true;
        }

        private final boolean _next() throws IOException {
            if (this.blockBuffer.remaining() <= 0) {
                return this.positionForNextBlock();
            }
            this.readKeyValueLen();
            return true;
        }

        @Override
        public boolean next() throws IOException {
            this.assertSeeked();
            this.positionThisBlockBuffer();
            return this._next();
        }

        @Override
        public boolean seekTo() throws IOException {
            if (this.reader == null) {
                return false;
            }
            if (this.reader.getTrailer().getEntryCount() == 0L) {
                return false;
            }
            long firstDataBlockOffset = this.reader.getTrailer().getFirstDataBlockOffset();
            if (this.curBlock != null && this.curBlock.getOffset() == firstDataBlockOffset) {
                return this.processFirstDataBlock();
            }
            this.readAndUpdateNewBlock(firstDataBlockOffset);
            return true;
        }

        protected boolean processFirstDataBlock() throws IOException {
            this.blockBuffer.rewind();
            this.readKeyValueLen();
            return true;
        }

        protected void readAndUpdateNewBlock(long firstDataBlockOffset) throws IOException {
            HFileBlock newBlock = this.reader.readBlock(firstDataBlockOffset, -1L, this.cacheBlocks, this.pread, this.isCompaction, true, BlockType.DATA, this.getEffectiveDataBlockEncoding());
            if (newBlock.getOffset() < 0L) {
                this.releaseIfNotCurBlock(newBlock);
                throw new IOException("Invalid offset=" + newBlock.getOffset() + ", path=" + this.reader.getPath());
            }
            this.updateCurrentBlock(newBlock);
        }

        protected int loadBlockAndSeekToKey(HFileBlock seekToBlock, Cell nextIndexedKey, boolean rewind, Cell key, boolean seekBefore) throws IOException {
            if (this.curBlock == null || this.curBlock.getOffset() != seekToBlock.getOffset()) {
                this.updateCurrentBlock(seekToBlock);
            } else if (rewind) {
                this.blockBuffer.rewind();
            }
            this.nextIndexedKey = nextIndexedKey;
            return this.blockSeek(key, seekBefore);
        }

        protected final boolean checkKeyLen(int v) {
            return v <= 0 || v > this.blockBuffer.limit();
        }

        protected final boolean checkLen(int v) {
            return v < 0 || v > this.blockBuffer.limit();
        }

        protected final void checkKeyValueLen() {
            if (this.checkKeyLen(this.currKeyLen) || this.checkLen(this.currValueLen)) {
                throw new IllegalStateException("Invalid currKeyLen " + this.currKeyLen + " or currValueLen " + this.currValueLen + ". Block offset: " + this.curBlock.getOffset() + ", block length: " + this.blockBuffer.limit() + ", position: " + this.blockBuffer.position() + " (without header)., path=" + this.reader.getPath());
            }
        }

        protected void updateCurrentBlock(HFileBlock newBlock) throws IOException {
            try {
                if (newBlock.getBlockType() != BlockType.DATA) {
                    throw new IllegalStateException("ScannerV2 works only on data blocks, got " + newBlock.getBlockType() + "; HFileName=" + this.reader.getPath() + ", dataBlockEncoder=" + this.reader.getDataBlockEncoding() + ", isCompaction=" + this.isCompaction);
                }
                this.updateCurrBlockRef(newBlock);
                this.blockBuffer = newBlock.getBufferWithoutHeader();
                this.readKeyValueLen();
            }
            finally {
                this.releaseIfNotCurBlock(newBlock);
            }
            this.nextIndexedKey = null;
        }

        protected Cell getFirstKeyCellInBlock(HFileBlock curBlock) {
            ByteBuff buffer = curBlock.getBufferWithoutHeader();
            buffer.rewind();
            int klen = buffer.getInt();
            buffer.skip(4);
            ByteBuffer keyBuff = buffer.asSubByteBuffer(klen);
            if (keyBuff.hasArray()) {
                return new KeyValue.KeyOnlyKeyValue(keyBuff.array(), keyBuff.arrayOffset() + keyBuff.position(), klen);
            }
            return new ByteBufferKeyOnlyKeyValue(keyBuff, keyBuff.position(), klen);
        }

        @Override
        public String getKeyString() {
            return CellUtil.toString((Cell)this.getKey(), (boolean)false);
        }

        @Override
        public String getValueString() {
            return ByteBufferUtils.toStringBinary((ByteBuffer)this.getValue());
        }

        public int compareKey(CellComparator comparator, Cell key) {
            this.blockBuffer.asSubByteBuffer(this.blockBuffer.position() + 8, this.currKeyLen, this.pair);
            this.bufBackedKeyOnlyKv.setKey((ByteBuffer)this.pair.getFirst(), this.pair.getSecond(), this.currKeyLen, this.rowLen);
            return PrivateCellUtil.compareKeyIgnoresMvcc((CellComparator)comparator, (Cell)key, (Cell)this.bufBackedKeyOnlyKv);
        }

        @Override
        public void shipped() throws IOException {
            this.returnBlocks(false);
        }
    }

    public static class NotSeekedException
    extends IllegalStateException {
        public NotSeekedException(Path path) {
            super(path + " not seeked to a key/value");
        }
    }

    public static class BlockIndexNotLoadedException
    extends IllegalStateException {
        public BlockIndexNotLoadedException(Path path) {
            super(path + " block index not loaded");
        }
    }
}

