/*
 * Decompiled with CFR 0.152.
 */
package org.grails.forge.feature.spring;

import jakarta.inject.Singleton;
import org.grails.forge.application.ApplicationType;
import org.grails.forge.application.generator.GeneratorContext;
import org.grails.forge.feature.config.ApplicationConfiguration;
import org.grails.forge.feature.spring.SpringThreadingFeature;

@Singleton
public class SpringBootVirtualThreads
implements SpringThreadingFeature {
    @Override
    public String getName() {
        return "spring-boot-virtual-threads";
    }

    @Override
    public String getTitle() {
        return "Spring Boot Virtual Threads";
    }

    @Override
    public String getDescription() {
        return "Enables Virtual Threads in Spring Boot for JDK 25+.";
    }

    @Override
    public boolean supports(ApplicationType applicationType) {
        return true;
    }

    @Override
    public void apply(GeneratorContext generatorContext) {
        ApplicationConfiguration config = generatorContext.getConfiguration();
        config.put("spring.threads.virtual.enabled", generatorContext.getJdkVersion().majorVersion() >= 25);
    }

    @Override
    public boolean isVisible() {
        return true;
    }

    @Override
    public String getDocumentation() {
        return "https://docs.spring.io/spring-boot/reference/features/spring-application.html#features.spring-application.virtual-threads";
    }
}

