/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.src.impl;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Optional;
import java.util.Queue;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.connector.base.source.reader.RecordsWithSplitIds;
import org.apache.flink.connector.base.source.reader.splitreader.SplitReader;
import org.apache.flink.connector.base.source.reader.splitreader.SplitsAddition;
import org.apache.flink.connector.base.source.reader.splitreader.SplitsChange;
import org.apache.flink.connector.file.src.FileSourceSplit;
import org.apache.flink.connector.file.src.impl.FileRecords;
import org.apache.flink.connector.file.src.reader.BulkFormat;
import org.apache.flink.connector.file.src.util.CheckpointedPosition;
import org.apache.flink.connector.file.src.util.RecordAndPosition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
final class FileSourceSplitReader<T, SplitT extends FileSourceSplit>
implements SplitReader<RecordAndPosition<T>, SplitT> {
    private static final Logger LOG = LoggerFactory.getLogger(FileSourceSplitReader.class);
    private final Configuration config;
    private final BulkFormat<T, SplitT> readerFactory;
    private final Queue<SplitT> splits;
    @Nullable
    private BulkFormat.Reader<T> currentReader;
    @Nullable
    private String currentSplitId;

    public FileSourceSplitReader(Configuration config, BulkFormat<T, SplitT> readerFactory) {
        this.config = config;
        this.readerFactory = readerFactory;
        this.splits = new ArrayDeque<SplitT>();
    }

    @Override
    public RecordsWithSplitIds<RecordAndPosition<T>> fetch() throws IOException {
        this.checkSplitOrStartNext();
        BulkFormat.RecordIterator<T> nextBatch = this.currentReader.readBatch();
        return nextBatch == null ? this.finishSplit() : FileRecords.forRecords(this.currentSplitId, nextBatch);
    }

    @Override
    public void handleSplitsChanges(SplitsChange<SplitT> splitChange) {
        if (!(splitChange instanceof SplitsAddition)) {
            throw new UnsupportedOperationException(String.format("The SplitChange type of %s is not supported.", splitChange.getClass()));
        }
        LOG.debug("Handling split change {}", splitChange);
        this.splits.addAll(splitChange.splits());
    }

    @Override
    public void wakeUp() {
    }

    @Override
    public void close() throws Exception {
        if (this.currentReader != null) {
            this.currentReader.close();
        }
    }

    private void checkSplitOrStartNext() throws IOException {
        if (this.currentReader != null) {
            return;
        }
        FileSourceSplit nextSplit = (FileSourceSplit)this.splits.poll();
        if (nextSplit == null) {
            throw new IOException("Cannot fetch from another split - no split remaining");
        }
        this.currentSplitId = nextSplit.splitId();
        Optional<CheckpointedPosition> position = nextSplit.getReaderPosition();
        this.currentReader = position.isPresent() ? this.readerFactory.restoreReader(this.config, nextSplit) : this.readerFactory.createReader(this.config, nextSplit);
    }

    private FileRecords<T> finishSplit() throws IOException {
        if (this.currentReader != null) {
            this.currentReader.close();
            this.currentReader = null;
        }
        FileRecords finishRecords = FileRecords.finishedSplit(this.currentSplitId);
        this.currentSplitId = null;
        return finishRecords;
    }
}

