// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

package org.apache.doris.nereids.trees.expressions.functions.scalar;

import org.apache.doris.catalog.FunctionSignature;
import org.apache.doris.nereids.trees.expressions.Expression;
import org.apache.doris.nereids.trees.expressions.functions.AlwaysNullable;
import org.apache.doris.nereids.trees.expressions.functions.ExplicitlyCastableSignature;
import org.apache.doris.nereids.trees.expressions.functions.PropagateNullLiteral;
import org.apache.doris.nereids.trees.expressions.literal.StringLikeLiteral;
import org.apache.doris.nereids.trees.expressions.shape.BinaryExpression;
import org.apache.doris.nereids.trees.expressions.visitor.ExpressionVisitor;
import org.apache.doris.nereids.types.BigIntType;
import org.apache.doris.nereids.types.DoubleType;
import org.apache.doris.nereids.util.TypeCoercionUtils;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;

import java.util.List;

/**
 * ScalarFunction 'pmod'. This class is generated by GenerateFunction.
 */
public class Pmod extends ScalarFunction
        implements BinaryExpression, ExplicitlyCastableSignature, AlwaysNullable, PropagateNullLiteral {

    public static final FunctionSignature BIGINT_SIGNATURE = FunctionSignature.ret(BigIntType.INSTANCE)
            .args(BigIntType.INSTANCE, BigIntType.INSTANCE);
    public static final FunctionSignature DOUBLE_SIGNATURE = FunctionSignature.ret(DoubleType.INSTANCE)
            .args(DoubleType.INSTANCE, DoubleType.INSTANCE);

    /**
     * constructor with 2 arguments.
     */
    public Pmod(Expression arg0, Expression arg1) {
        super("pmod", arg0, arg1);
    }

    /**
     * withChildren.
     */
    @Override
    public Pmod withChildren(List<Expression> children) {
        Preconditions.checkArgument(children.size() == 2);
        return new Pmod(children.get(0), children.get(1));
    }

    /**
     * already override searchSignature and computeSignature, so getSignatures is useless anymore.
     *
     * @return empty list
     */
    @Override
    public List<FunctionSignature> getSignatures() {
        return ImmutableList.of();
    }

    @Override
    public FunctionSignature computeSignature(FunctionSignature signature) {
        return signature;
    }

    @Override
    public FunctionSignature searchSignature(List<FunctionSignature> signatures) {
        boolean leftCouldBeBigInt = false;
        boolean rightCouldBeBigInt = false;
        if (getArgument(0) instanceof StringLikeLiteral) {
            leftCouldBeBigInt = TypeCoercionUtils.characterLiteralTypeCoercion(
                    ((StringLikeLiteral) getArgument(0)).getValue(), BigIntType.INSTANCE).isPresent();
        }
        if (getArgument(1) instanceof StringLikeLiteral) {
            rightCouldBeBigInt = TypeCoercionUtils.characterLiteralTypeCoercion(
                    ((StringLikeLiteral) getArgument(1)).getValue(), BigIntType.INSTANCE).isPresent();
        }
        if ((getArgument(0).getDataType().isIntegerLikeType() || leftCouldBeBigInt)
                && (getArgument(1).getDataType().isIntegerLikeType() || rightCouldBeBigInt)) {
            return BIGINT_SIGNATURE;
        } else {
            return DOUBLE_SIGNATURE;
        }
    }

    @Override
    public <R, C> R accept(ExpressionVisitor<R, C> visitor, C context) {
        return visitor.visitPmod(this, context);
    }
}
