/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.factory;

import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.util.Asn1Buffer;
import org.apache.directory.api.ldap.codec.api.IntermediateOperationFactory;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.codec.factory.ResponseFactory;
import org.apache.directory.api.ldap.model.message.IntermediateResponse;
import org.apache.directory.api.ldap.model.message.Message;
import org.apache.directory.api.util.Strings;

public final class IntermediateResponseFactory
extends ResponseFactory {
    public static final IntermediateResponseFactory INSTANCE = new IntermediateResponseFactory();

    private IntermediateResponseFactory() {
    }

    @Override
    public void encodeReverse(LdapApiService codec, Asn1Buffer buffer, Message message) {
        int start = buffer.getPos();
        IntermediateResponse intermediateResponse = (IntermediateResponse)message;
        IntermediateOperationFactory factory = codec.getIntermediateResponseFactories().get(intermediateResponse.getResponseName());
        if (factory != null) {
            factory.encodeValue(buffer, intermediateResponse);
            if (buffer.getPos() > start) {
                BerValue.encodeSequence(buffer, (byte)-127, start);
            }
        } else if (!Strings.isEmpty(intermediateResponse.getResponseValue())) {
            BerValue.encodeOctetString(buffer, (byte)-127, intermediateResponse.getResponseValue());
        }
        if (!Strings.isEmpty(intermediateResponse.getResponseName())) {
            BerValue.encodeOctetString(buffer, (byte)-128, intermediateResponse.getResponseName());
        }
        BerValue.encodeSequence(buffer, (byte)121, start);
    }
}

