/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.actions.searchResultEntry;

import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.api.ldap.codec.decorators.SearchResultEntryDecorator;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreSearchResultAttributeValue
extends GrammarAction<LdapMessageContainer<SearchResultEntryDecorator>> {
    private static final Logger LOG = LoggerFactory.getLogger(StoreSearchResultAttributeValue.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();

    public StoreSearchResultAttributeValue() {
        super("Stores AttributeValue");
    }

    public void action(LdapMessageContainer<SearchResultEntryDecorator> container) {
        SearchResultEntryDecorator searchResultEntry = container.getMessage();
        TLV tlv = container.getCurrentTLV();
        Object value = null;
        try {
            if (tlv.getLength() == 0) {
                searchResultEntry.addAttributeValue("");
                LOG.debug("The attribute value is null");
            } else {
                if (container.isBinary(searchResultEntry.getCurrentAttribute().getId())) {
                    value = tlv.getValue().getData();
                    if (IS_DEBUG) {
                        LOG.debug("Attribute value {}", (Object)Strings.dumpBytes((byte[])value));
                    }
                } else {
                    value = Strings.utf8ToString((byte[])tlv.getValue().getData());
                    LOG.debug("Attribute value {}", value);
                }
                searchResultEntry.addAttributeValue(value);
            }
        }
        catch (LdapException ldapException) {
            // empty catch block
        }
        container.setGrammarEndAllowed(true);
    }
}

