/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.concurrent;

import io.netty.util.internal.PlatformDependent;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;

public class ConcurrentSkipListIntObjMultimap<V>
implements Iterable<IntEntry<V>> {
    private final int noKey;
    private volatile Index<V> head;
    private final LongAdder adder;
    private static final int EQ = 1;
    private static final int LT = 2;
    private static final int GT = 0;
    private static final MethodHandle ACQUIRE_FENCE;
    private static final AtomicReferenceFieldUpdater<ConcurrentSkipListIntObjMultimap<?>, Index<?>> HEAD;
    private static final AtomicReferenceFieldUpdater<Node<?>, Node<?>> NEXT;
    private static final AtomicReferenceFieldUpdater<Node<?>, Object> VAL;
    private static final AtomicReferenceFieldUpdater<Index<?>, Index<?>> RIGHT;
    private static volatile int acquireFenceVariable;

    static int cpr(int x, int y) {
        return Integer.compare(x, y);
    }

    final Node<V> baseHead() {
        ConcurrentSkipListIntObjMultimap.acquireFence();
        Index<V> h = this.head;
        return h == null ? null : h.node;
    }

    static <V> void unlinkNode(Node<V> b, Node<V> n, int noKey) {
        if (b != null && n != null) {
            Node p;
            block2: {
                Node f;
                do {
                    if ((f = n.next) == null || f.key != noKey) continue;
                    p = f.next;
                    break block2;
                } while (!NEXT.compareAndSet(n, f, new Node<Object>(noKey, null, f)));
                p = f;
            }
            NEXT.compareAndSet(b, n, p);
        }
    }

    private void addCount(long c) {
        this.adder.add(c);
    }

    final long getAdderCount() {
        long c = this.adder.sum();
        return c <= 0L ? 0L : c;
    }

    private Node<V> findPredecessor(int key) {
        ConcurrentSkipListIntObjMultimap.acquireFence();
        Index<V> q = this.head;
        if (q == null || key == this.noKey) {
            return null;
        }
        while (true) {
            Index d;
            Index r;
            if ((r = q.right) != null) {
                int k;
                Node p = r.node;
                if (p == null || (k = p.key) == this.noKey || p.val == null) {
                    RIGHT.compareAndSet(q, r, r.right);
                    continue;
                }
                if (ConcurrentSkipListIntObjMultimap.cpr(key, k) > 0) {
                    q = r;
                    continue;
                }
            }
            if ((d = q.down) == null) break;
            q = d;
        }
        return q.node;
    }

    private Node<V> findNode(int key) {
        Node<V> b;
        if (key == this.noKey) {
            throw new IllegalArgumentException();
        }
        block0: while ((b = this.findPredecessor(key)) != null) {
            Node n;
            while ((n = b.next) != null) {
                int k = n.key;
                if (k == this.noKey) continue block0;
                if (n.val == null) {
                    ConcurrentSkipListIntObjMultimap.unlinkNode(b, n, this.noKey);
                    continue;
                }
                int c = ConcurrentSkipListIntObjMultimap.cpr(key, k);
                if (c > 0) {
                    b = n;
                    continue;
                }
                if (c != 0) break block0;
                return n;
            }
            break block0;
        }
        return null;
    }

    private V doGet(int key) {
        V result;
        block10: {
            ConcurrentSkipListIntObjMultimap.acquireFence();
            if (key == this.noKey) {
                throw new IllegalArgumentException();
            }
            result = null;
            Index<V> q = this.head;
            if (q != null) {
                int c;
                Object v;
                while (true) {
                    Index d;
                    Index r;
                    if ((r = q.right) != null) {
                        int k;
                        Node p = r.node;
                        if (p == null || (k = p.key) == this.noKey || (v = p.val) == null) {
                            RIGHT.compareAndSet(q, r, r.right);
                            continue;
                        }
                        c = ConcurrentSkipListIntObjMultimap.cpr(key, k);
                        if (c > 0) {
                            q = r;
                            continue;
                        }
                        if (c == 0) {
                            result = v;
                            break block10;
                        }
                    }
                    if ((d = q.down) == null) break;
                    q = d;
                }
                Node b = q.node;
                if (b != null) {
                    Node n;
                    while ((n = b.next) != null) {
                        int k = n.key;
                        v = n.val;
                        if (v == null || k == this.noKey || (c = ConcurrentSkipListIntObjMultimap.cpr(key, k)) > 0) {
                            b = n;
                            continue;
                        }
                        if (c != 0) break;
                        result = v;
                        break;
                    }
                }
            }
        }
        return result;
    }

    private V doPut(int key, V value, boolean onlyIfAbsent) {
        Node<V> z;
        Index<Object> h;
        int levels;
        if (key == this.noKey) {
            throw new IllegalArgumentException();
        }
        while (true) {
            block16: {
                Node<V> p;
                Node n;
                int c;
                Node<Object> b;
                ConcurrentSkipListIntObjMultimap.acquireFence();
                levels = 0;
                h = this.head;
                if (h == null) {
                    Node<Object> base = new Node<Object>(this.noKey, null, null);
                    h = new Index<Object>(base, null, null);
                    b = HEAD.compareAndSet(this, null, h) ? base : null;
                } else {
                    Index<V> q = h;
                    while (true) {
                        Index d;
                        Index r;
                        if ((r = q.right) != null) {
                            int k;
                            Node p2 = r.node;
                            if (p2 == null || (k = p2.key) == this.noKey || p2.val == null) {
                                RIGHT.compareAndSet(q, r, r.right);
                                continue;
                            }
                            if (ConcurrentSkipListIntObjMultimap.cpr(key, k) > 0) {
                                q = r;
                                continue;
                            }
                        }
                        if ((d = q.down) == null) break;
                        ++levels;
                        q = d;
                    }
                    b = q.node;
                }
                if (b == null) continue;
                z = null;
                do {
                    if ((n = b.next) == null) {
                        if (b.key == this.noKey) {
                            ConcurrentSkipListIntObjMultimap.cpr(key, key);
                        }
                        c = -1;
                        continue;
                    }
                    int k = n.key;
                    if (k == this.noKey) break block16;
                    Object v = n.val;
                    if (v == null) {
                        ConcurrentSkipListIntObjMultimap.unlinkNode(b, n, this.noKey);
                        c = 1;
                        continue;
                    }
                    c = ConcurrentSkipListIntObjMultimap.cpr(key, k);
                    if (c <= 0) continue;
                    b = n;
                } while (c > 0 || !NEXT.compareAndSet(b, n, p = new Node<V>(key, value, n)));
                z = p;
            }
            if (z != null) break;
        }
        int lr = ThreadLocalRandom.current().nextInt();
        if ((lr & 3) == 0) {
            int hr = ThreadLocalRandom.current().nextInt();
            long rnd = (long)hr << 32 | (long)lr & 0xFFFFFFFFL;
            int skips = levels;
            Index<V> x = null;
            while (true) {
                x = new Index<V>(z, x, null);
                if (rnd >= 0L || --skips < 0) break;
                rnd <<= 1;
            }
            if (ConcurrentSkipListIntObjMultimap.addIndices(h, skips, x, this.noKey) && skips < 0 && this.head == h) {
                Index<V> hx = new Index<V>(z, x, null);
                Index nh = new Index(h.node, h, hx);
                HEAD.compareAndSet(this, h, nh);
            }
            if (z.val == null) {
                this.findPredecessor(key);
            }
        }
        this.addCount(1L);
        return null;
    }

    static <V> boolean addIndices(Index<V> q, int skips, Index<V> x, int noKey) {
        int key;
        Node z;
        if (x != null && (z = x.node) != null && (key = z.key) != noKey && q != null) {
            boolean retrying = false;
            while (true) {
                int c;
                Index r;
                if ((r = q.right) != null) {
                    int k;
                    Node p = r.node;
                    if (p == null || (k = p.key) == noKey || p.val == null) {
                        RIGHT.compareAndSet(q, r, r.right);
                        c = 0;
                    } else {
                        c = ConcurrentSkipListIntObjMultimap.cpr(key, k);
                        if (c > 0) {
                            q = r;
                        } else if (c == 0) {
                            break;
                        }
                    }
                } else {
                    c = -1;
                }
                if (c >= 0) continue;
                Index d = q.down;
                if (d != null && skips > 0) {
                    --skips;
                    q = d;
                    continue;
                }
                if (d != null && !retrying && !ConcurrentSkipListIntObjMultimap.addIndices(d, 0, x.down, noKey)) break;
                x.right = r;
                if (RIGHT.compareAndSet(q, r, x)) {
                    return true;
                }
                retrying = true;
            }
        }
        return false;
    }

    final V doRemove(int key, Object value) {
        Node<V> b;
        if (key == this.noKey) {
            throw new IllegalArgumentException();
        }
        V result = null;
        block0: while ((b = this.findPredecessor(key)) != null && result == null) {
            Node n;
            while ((n = b.next) != null) {
                int k = n.key;
                if (k == this.noKey) continue block0;
                Object v = n.val;
                if (v == null) {
                    ConcurrentSkipListIntObjMultimap.unlinkNode(b, n, this.noKey);
                    continue;
                }
                int c = ConcurrentSkipListIntObjMultimap.cpr(key, k);
                if (c > 0) {
                    b = n;
                    continue;
                }
                if (c < 0) break block0;
                if (value != null && !value.equals(v)) {
                    b = n;
                    continue;
                }
                if (!VAL.compareAndSet(n, v, null)) continue;
                result = v;
                ConcurrentSkipListIntObjMultimap.unlinkNode(b, n, this.noKey);
                continue block0;
            }
            break block0;
        }
        if (result != null) {
            this.tryReduceLevel();
            this.addCount(-1L);
        }
        return result;
    }

    private void tryReduceLevel() {
        Index e;
        Index d;
        Index<V> h = this.head;
        if (h != null && h.right == null && (d = h.down) != null && d.right == null && (e = d.down) != null && e.right == null && HEAD.compareAndSet(this, h, d) && h.right != null) {
            HEAD.compareAndSet(this, d, h);
        }
    }

    final Node<V> findFirst() {
        Node<V> b = this.baseHead();
        if (b != null) {
            Node n;
            while ((n = b.next) != null) {
                if (n.val == null) {
                    ConcurrentSkipListIntObjMultimap.unlinkNode(b, n, this.noKey);
                    continue;
                }
                return n;
            }
        }
        return null;
    }

    final IntEntry<V> findFirstEntry() {
        Node<V> b = this.baseHead();
        if (b != null) {
            Node n;
            while ((n = b.next) != null) {
                Object v = n.val;
                if (v == null) {
                    ConcurrentSkipListIntObjMultimap.unlinkNode(b, n, this.noKey);
                    continue;
                }
                return new IntEntry(n.key, v);
            }
        }
        return null;
    }

    private IntEntry<V> doRemoveFirstEntry() {
        Node<V> b = this.baseHead();
        if (b != null) {
            Node n;
            while ((n = b.next) != null) {
                Object v = n.val;
                if (v != null && !VAL.compareAndSet(n, v, null)) continue;
                int k = n.key;
                ConcurrentSkipListIntObjMultimap.unlinkNode(b, n, this.noKey);
                if (v == null) continue;
                this.tryReduceLevel();
                this.findPredecessor(k);
                this.addCount(-1L);
                return new IntEntry(k, v);
            }
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    final Node<V> findLast() {
        block0: while (true) {
            ConcurrentSkipListIntObjMultimap.acquireFence();
            q = this.head;
            if (q == null) break;
            while (true) {
                if ((r = q.right) != null) {
                    p = r.node;
                    if (p == null || p.val == null) {
                        ConcurrentSkipListIntObjMultimap.RIGHT.compareAndSet(q, r, r.right);
                        continue;
                    }
                    q = r;
                    continue;
                }
                d = q.down;
                if (d == null) break;
                q = d;
            }
            b = q.node;
            if (b == null) continue;
            while (true) {
                if ((n = b.next) == null) {
                    if (b.key == this.noKey) break block0;
                    return b;
                }
                if (n.key != this.noKey) ** break;
                continue block0;
                if (n.val == null) {
                    ConcurrentSkipListIntObjMultimap.unlinkNode(b, n, this.noKey);
                    continue;
                }
                b = n;
            }
            break;
        }
        return null;
    }

    final IntEntry<V> findLastEntry() {
        Node<V> n;
        Object v;
        do {
            if ((n = this.findLast()) != null) continue;
            return null;
        } while ((v = n.val) == null);
        return new IntEntry(n.key, v);
    }

    /*
     * Unable to fully structure code
     */
    private IntEntry<V> doRemoveLastEntry() {
        block9: {
            block0: while (true) {
                ConcurrentSkipListIntObjMultimap.acquireFence();
                q = this.head;
                if (q == null) break block9;
                while (true) {
                    if ((r = q.right) != null) {
                        p = r.node;
                        if (p == null || p.val == null) {
                            ConcurrentSkipListIntObjMultimap.RIGHT.compareAndSet(q, r, r.right);
                            continue;
                        }
                        if (p.next != null) {
                            q = r;
                            continue;
                        }
                    }
                    if ((d = q.down) == null) break;
                    q = d;
                }
                b = q.node;
                if (b == null) continue;
                while (true) {
                    if ((n = b.next) == null) {
                        if (b.key != this.noKey) continue block0;
                        break block9;
                    }
                    k = n.key;
                    if (k != this.noKey) ** break;
                    continue block0;
                    v = n.val;
                    if (v == null) {
                        ConcurrentSkipListIntObjMultimap.unlinkNode(b, n, this.noKey);
                        continue;
                    }
                    if (n.next != null) {
                        b = n;
                        continue;
                    }
                    if (ConcurrentSkipListIntObjMultimap.VAL.compareAndSet(n, v, null)) break block0;
                }
                break;
            }
            ConcurrentSkipListIntObjMultimap.unlinkNode(b, n, this.noKey);
            this.tryReduceLevel();
            this.findPredecessor(k);
            this.addCount(-1L);
            return new IntEntry<V>(k, v);
        }
        return null;
    }

    final IntEntry<V> findNearEntry(int key, int rel) {
        Node<V> n;
        Object v;
        do {
            if ((n = this.findNear(key, rel)) != null) continue;
            return null;
        } while ((v = n.val) == null);
        return new IntEntry(n.key, v);
    }

    final Node<V> findNear(int key, int rel) {
        Node<V> result;
        if (key == this.noKey) {
            throw new IllegalArgumentException();
        }
        block0: while (true) {
            Node<V> b;
            if ((b = this.findPredecessor(key)) == null) {
                result = null;
                break;
            }
            while (true) {
                Node n;
                if ((n = b.next) == null) {
                    result = (rel & 2) != 0 && b.key != this.noKey ? b : null;
                    break block0;
                }
                int k = n.key;
                if (k == this.noKey) continue block0;
                if (n.val == null) {
                    ConcurrentSkipListIntObjMultimap.unlinkNode(b, n, this.noKey);
                    continue;
                }
                int c = ConcurrentSkipListIntObjMultimap.cpr(key, k);
                if (c == 0 && (rel & 1) != 0 || c < 0 && (rel & 2) == 0) {
                    result = n;
                    break block0;
                }
                if (c <= 0 && (rel & 2) != 0) {
                    result = b.key != this.noKey ? b : null;
                    break block0;
                }
                b = n;
            }
            break;
        }
        return result;
    }

    public ConcurrentSkipListIntObjMultimap(int noKey) {
        this.noKey = noKey;
        this.adder = new LongAdder();
    }

    public boolean containsKey(int key) {
        return this.doGet(key) != null;
    }

    public V get(int key) {
        return this.doGet(key);
    }

    public V getOrDefault(int key, V defaultValue) {
        V v = this.doGet(key);
        return v == null ? defaultValue : v;
    }

    public void put(int key, V value) {
        Objects.requireNonNull(value);
        this.doPut(key, value, false);
    }

    public V remove(int key) {
        return this.doRemove(key, null);
    }

    public boolean containsValue(Object value) {
        Objects.requireNonNull(value);
        Node<V> b = this.baseHead();
        if (b != null) {
            Node n;
            while ((n = b.next) != null) {
                Object v = n.val;
                if (v != null && value.equals(v)) {
                    return true;
                }
                b = n;
            }
        }
        return false;
    }

    public int size() {
        long c;
        return this.baseHead() == null ? 0 : ((c = this.getAdderCount()) >= Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)c);
    }

    public boolean isEmpty() {
        return this.findFirst() == null;
    }

    public void clear() {
        Index<V> h;
        ConcurrentSkipListIntObjMultimap.acquireFence();
        while ((h = this.head) != null) {
            Index r = h.right;
            if (r != null) {
                RIGHT.compareAndSet(h, r, null);
                continue;
            }
            Index d = h.down;
            if (d != null) {
                HEAD.compareAndSet(this, h, d);
                continue;
            }
            long count = 0L;
            Node b = h.node;
            if (b != null) {
                Node n;
                while ((n = b.next) != null) {
                    Object v = n.val;
                    if (v != null && VAL.compareAndSet(n, v, null)) {
                        --count;
                        v = null;
                    }
                    if (v != null) continue;
                    ConcurrentSkipListIntObjMultimap.unlinkNode(b, n, this.noKey);
                }
            }
            if (count == 0L) break;
            this.addCount(count);
        }
    }

    public boolean remove(int key, Object value) {
        if (key == this.noKey) {
            throw new IllegalArgumentException();
        }
        return value != null && this.doRemove(key, value) != null;
    }

    public boolean replace(int key, V oldValue, V newValue) {
        if (key == this.noKey) {
            throw new IllegalArgumentException();
        }
        Objects.requireNonNull(oldValue);
        Objects.requireNonNull(newValue);
        while (true) {
            Node<V> n;
            if ((n = this.findNode(key)) == null) {
                return false;
            }
            Object v = n.val;
            if (v == null) continue;
            if (!oldValue.equals(v)) {
                return false;
            }
            if (VAL.compareAndSet(n, v, newValue)) break;
        }
        return true;
    }

    public int firstKey() {
        Node<V> n = this.findFirst();
        if (n == null) {
            return this.noKey;
        }
        return n.key;
    }

    public int lastKey() {
        Node<V> n = this.findLast();
        if (n == null) {
            return this.noKey;
        }
        return n.key;
    }

    public IntEntry<V> lowerEntry(int key) {
        return this.findNearEntry(key, 2);
    }

    public int lowerKey(int key) {
        Node<V> n = this.findNear(key, 2);
        return n == null ? this.noKey : n.key;
    }

    public IntEntry<V> floorEntry(int key) {
        return this.findNearEntry(key, 3);
    }

    public int floorKey(int key) {
        Node<V> n = this.findNear(key, 3);
        return n == null ? this.noKey : n.key;
    }

    public IntEntry<V> ceilingEntry(int key) {
        return this.findNearEntry(key, 1);
    }

    public int ceilingKey(int key) {
        Node<V> n = this.findNear(key, 1);
        return n == null ? this.noKey : n.key;
    }

    public IntEntry<V> higherEntry(int key) {
        return this.findNearEntry(key, 0);
    }

    public int higherKey(int key) {
        Node<V> n = this.findNear(key, 0);
        return n == null ? this.noKey : n.key;
    }

    public IntEntry<V> firstEntry() {
        return this.findFirstEntry();
    }

    public IntEntry<V> lastEntry() {
        return this.findLastEntry();
    }

    public IntEntry<V> pollFirstEntry() {
        return this.doRemoveFirstEntry();
    }

    public IntEntry<V> pollLastEntry() {
        return this.doRemoveLastEntry();
    }

    public IntEntry<V> pollCeilingEntry(int key) {
        Node<V> node;
        Object val;
        do {
            if ((node = this.findNear(key, 1)) != null) continue;
            return null;
        } while ((val = node.val) == null || !this.remove(node.key, val));
        return new IntEntry(node.key, val);
    }

    @Override
    public Iterator<IntEntry<V>> iterator() {
        return new EntryIterator();
    }

    public void forEach(BiConsumer<Integer, ? super V> action) {
        Objects.requireNonNull(action);
        Node<V> b = this.baseHead();
        if (b != null) {
            Node n;
            while ((n = b.next) != null) {
                Object v = n.val;
                if (v != null) {
                    action.accept(n.key, v);
                }
                b = n;
            }
        }
    }

    public void replaceAll(BiFunction<Integer, ? super V, ? extends V> function) {
        Objects.requireNonNull(function);
        Node<V> b = this.baseHead();
        if (b != null) {
            Node n;
            while ((n = b.next) != null) {
                Object v;
                while ((v = n.val) != null) {
                    V r = function.apply(n.key, v);
                    Objects.requireNonNull(r);
                    if (!VAL.compareAndSet(n, v, r)) continue;
                    break;
                }
                b = n;
            }
        }
    }

    private static <T> Class<T> cls(Class<?> cls) {
        return cls;
    }

    private static void acquireFence() {
        try {
            ACQUIRE_FENCE.invokeExact();
        }
        catch (Throwable e) {
            LinkageError error = new LinkageError();
            error.initCause(e);
            throw error;
        }
    }

    private static void acquireFenceFallback() {
        int ignore = acquireFenceVariable = 1;
    }

    static {
        try {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            Class mapCls = ConcurrentSkipListIntObjMultimap.cls(ConcurrentSkipListIntObjMultimap.class);
            Class indexCls = ConcurrentSkipListIntObjMultimap.cls(Index.class);
            Class nodeCls = ConcurrentSkipListIntObjMultimap.cls(Node.class);
            if (PlatformDependent.hasVarHandle()) {
                Class varHandleCls = ConcurrentSkipListIntObjMultimap.cls(Class.forName("java.lang.invoke.VarHandle"));
                ACQUIRE_FENCE = lookup.findStatic(varHandleCls, "acquireFence", MethodType.methodType(Void.TYPE));
            } else {
                ACQUIRE_FENCE = lookup.findStatic(mapCls, "acquireFenceFallback", MethodType.methodType(Void.TYPE));
            }
            HEAD = AtomicReferenceFieldUpdater.newUpdater(mapCls, indexCls, "head");
            NEXT = AtomicReferenceFieldUpdater.newUpdater(nodeCls, nodeCls, "next");
            VAL = AtomicReferenceFieldUpdater.newUpdater(nodeCls, Object.class, "val");
            RIGHT = AtomicReferenceFieldUpdater.newUpdater(indexCls, indexCls, "right");
        }
        catch (ReflectiveOperationException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    final class EntryIterator
    extends Iter<IntEntry<V>> {
        EntryIterator() {
        }

        @Override
        public IntEntry<V> next() {
            Node n = this.next;
            if (n == null) {
                throw new NoSuchElementException();
            }
            int k = n.key;
            Object v = this.nextValue;
            this.advance(n);
            return new IntEntry<Object>(k, v);
        }
    }

    abstract class Iter<T>
    implements Iterator<T> {
        Node<V> lastReturned;
        Node<V> next;
        V nextValue;

        Iter() {
            this.advance(ConcurrentSkipListIntObjMultimap.this.baseHead());
        }

        @Override
        public final boolean hasNext() {
            return this.next != null;
        }

        final void advance(Node<V> b) {
            Node n = null;
            Object v = null;
            this.lastReturned = b;
            if (this.lastReturned != null) {
                while ((n = b.next) != null) {
                    Object v2 = n.val;
                    v = v2;
                    if (v2 != null) break;
                    b = n;
                }
            }
            this.nextValue = v;
            this.next = n;
        }

        @Override
        public final void remove() {
            int k;
            Node n = this.lastReturned;
            if (n == null || (k = n.key) == ConcurrentSkipListIntObjMultimap.this.noKey) {
                throw new IllegalStateException();
            }
            ConcurrentSkipListIntObjMultimap.this.remove(k, n.val);
            this.lastReturned = null;
        }
    }

    public static final class IntEntry<V>
    implements Comparable<IntEntry<V>> {
        private final int key;
        private final V value;

        public IntEntry(int key, V value) {
            this.key = key;
            this.value = value;
        }

        public int getKey() {
            return this.key;
        }

        public V getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (!(o instanceof IntEntry)) {
                return false;
            }
            IntEntry intEntry = (IntEntry)o;
            return this.key == intEntry.key && Objects.equals(this.value, intEntry.value);
        }

        public int hashCode() {
            int result = this.key;
            result = 31 * result + Objects.hashCode(this.value);
            return result;
        }

        public String toString() {
            return "IntEntry[" + this.key + " => " + this.value + ']';
        }

        @Override
        public int compareTo(IntEntry<V> o) {
            return Integer.compare(this.key, o.key);
        }
    }

    static final class Index<V> {
        final Node<V> node;
        final Index<V> down;
        volatile Index<V> right;

        Index(Node<V> node, Index<V> down, Index<V> right) {
            this.node = node;
            this.down = down;
            this.right = right;
        }
    }

    static final class Node<V> {
        final int key;
        volatile V val;
        volatile Node<V> next;

        Node(int key, V value, Node<V> next) {
            this.key = key;
            this.val = value;
            this.next = next;
        }
    }
}

