/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElementRef;
import jakarta.xml.bind.annotation.XmlTransient;
import org.apache.camel.Expression;
import org.apache.camel.ExpressionFactory;
import org.apache.camel.Predicate;
import org.apache.camel.builder.ExpressionClause;
import org.apache.camel.model.CopyableDefinition;
import org.apache.camel.model.ExpressionNodeHelper;
import org.apache.camel.model.HasExpressionType;
import org.apache.camel.model.OptionalIdentifiedDefinition;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.spi.Metadata;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlTransient
public abstract class BasicExpressionNode<T extends BasicExpressionNode<T>>
extends OptionalIdentifiedDefinition<T>
implements HasExpressionType,
CopyableDefinition<T> {
    @Metadata(description="Expression used as the predicate to evaluate whether this when should trigger and route the message or not.")
    @XmlElementRef
    private ExpressionDefinition expression;

    public BasicExpressionNode() {
    }

    public BasicExpressionNode(ExpressionDefinition expression) {
        this.setExpression(expression);
    }

    public BasicExpressionNode(Expression expression) {
        this.setExpression(expression);
    }

    public BasicExpressionNode(Predicate predicate) {
        this.setPredicate(predicate);
    }

    protected BasicExpressionNode(BasicExpressionNode source) {
        super(source);
        this.expression = source.expression != null ? source.expression.copyDefinition() : null;
    }

    public ExpressionDefinition getExpression() {
        return this.expression;
    }

    public void setExpression(Expression expression) {
        if (expression != null) {
            this.setExpression(ExpressionNodeHelper.toExpressionDefinition(expression));
        }
    }

    private void setPredicate(Predicate predicate) {
        if (predicate != null) {
            this.setExpression(ExpressionNodeHelper.toExpressionDefinition(predicate));
        }
    }

    public void setExpression(ExpressionDefinition expression) {
        this.expression = expression;
    }

    @Override
    public ExpressionDefinition getExpressionType() {
        return this.getExpression();
    }

    @Override
    public void setExpressionType(ExpressionDefinition expressionType) {
        this.setExpression(expressionType);
    }

    public String getLabel() {
        if (this.getExpression() == null) {
            return "";
        }
        return this.getExpression().getLabel();
    }

    public void preCreateProcessor() {
        ExpressionFactory model;
        ExpressionClause clause;
        ExpressionDefinition exp = this.getExpression();
        if (this.getExpression() != null && this.getExpression().getExpressionValue() != null) {
            exp = this.getExpression().getExpressionValue();
        }
        if (exp instanceof ExpressionClause && (clause = (ExpressionClause)((Object)exp)).getExpressionType() != null && (model = clause.getExpressionType()) instanceof ExpressionDefinition) {
            ExpressionDefinition expressionDefinition = (ExpressionDefinition)model;
            this.setExpression(expressionDefinition);
        }
        if (this.getExpression() != null && this.getExpression().getExpression() == null) {
            if (this.getExpression().getPredicate() != null) {
                this.getExpression().setExpression(this.getExpression().getPredicate().toString());
            } else if (this.getExpression().getExpressionValue() != null) {
                this.getExpression().setExpression(this.getExpression().getExpressionValue().toString());
            }
        }
    }
}

