/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.extension.verifier;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.camel.component.extension.ComponentVerifierExtension;
import org.apache.camel.component.extension.verifier.DefaultResult;
import org.apache.camel.component.extension.verifier.IllegalOptionException;
import org.apache.camel.component.extension.verifier.NoSuchOptionException;
import org.apache.camel.component.extension.verifier.ResultErrorBuilder;
import org.apache.camel.util.function.ThrowingBiConsumer;
import org.apache.camel.util.function.ThrowingConsumer;

public final class ResultBuilder {
    private ComponentVerifierExtension.Scope scope = null;
    private ComponentVerifierExtension.Result.Status status = null;
    private List<ComponentVerifierExtension.VerificationError> verificationErrors;

    public ResultBuilder scope(ComponentVerifierExtension.Scope scope) {
        this.scope = scope;
        return this;
    }

    public ResultBuilder status(ComponentVerifierExtension.Result.Status status) {
        this.status = status;
        return this;
    }

    @Deprecated
    public ResultBuilder error(Optional<ComponentVerifierExtension.VerificationError> verificationError) {
        return this.error((ComponentVerifierExtension.VerificationError)verificationError.orElse(null));
    }

    public ResultBuilder error(ComponentVerifierExtension.VerificationError verificationError) {
        if (verificationError != null) {
            if (this.verificationErrors == null) {
                this.verificationErrors = new ArrayList<ComponentVerifierExtension.VerificationError>();
            }
            this.verificationErrors.add(verificationError);
            this.status = ComponentVerifierExtension.Result.Status.ERROR;
        }
        return this;
    }

    public ResultBuilder error(Supplier<ComponentVerifierExtension.VerificationError> supplier) {
        return this.error(supplier.get());
    }

    public ResultBuilder error(ThrowingConsumer<ResultBuilder, Exception> consumer) {
        try {
            consumer.accept((Object)this);
        }
        catch (NoSuchOptionException e) {
            this.error(ResultErrorBuilder.withMissingOption(e.getOptionName()).build());
        }
        catch (IllegalOptionException e) {
            this.error(ResultErrorBuilder.withIllegalOption(e.getOptionName(), e.getOptionValue()).build());
        }
        catch (Exception e) {
            this.error(ResultErrorBuilder.withException(e).build());
        }
        return this;
    }

    public <T> ResultBuilder error(T data, ThrowingBiConsumer<ResultBuilder, T, Exception> consumer) {
        try {
            consumer.accept((Object)this, data);
        }
        catch (NoSuchOptionException e) {
            this.error(ResultErrorBuilder.withMissingOption(e.getOptionName()).build());
        }
        catch (IllegalOptionException e) {
            this.error(ResultErrorBuilder.withIllegalOption(e.getOptionName(), e.getOptionValue()).build());
        }
        catch (Exception e) {
            this.error(ResultErrorBuilder.withException(e).build());
        }
        return this;
    }

    public ResultBuilder errors(List<ComponentVerifierExtension.VerificationError> verificationErrors) {
        verificationErrors.forEach(this::error);
        return this;
    }

    public ComponentVerifierExtension.Result build() {
        return new DefaultResult(this.scope != null ? this.scope : ComponentVerifierExtension.Scope.PARAMETERS, this.status != null ? this.status : ComponentVerifierExtension.Result.Status.UNSUPPORTED, this.verificationErrors != null ? Collections.unmodifiableList(this.verificationErrors) : Collections.emptyList());
    }

    public static ResultBuilder withStatus(ComponentVerifierExtension.Result.Status status) {
        return new ResultBuilder().status(status);
    }

    public static ResultBuilder withStatusAndScope(ComponentVerifierExtension.Result.Status status, ComponentVerifierExtension.Scope scope) {
        return new ResultBuilder().status(status).scope(scope);
    }

    public static ResultBuilder withScope(ComponentVerifierExtension.Scope scope) {
        return new ResultBuilder().scope(scope);
    }

    public static ResultBuilder unsupported() {
        return ResultBuilder.withStatusAndScope(ComponentVerifierExtension.Result.Status.UNSUPPORTED, ComponentVerifierExtension.Scope.PARAMETERS);
    }

    public static ResultBuilder unsupportedScope(ComponentVerifierExtension.Scope scope) {
        return ResultBuilder.withStatusAndScope(ComponentVerifierExtension.Result.Status.UNSUPPORTED, scope);
    }
}

