/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spi;

import org.apache.camel.util.StringHelper;

public class DataType {
    public static final String DEFAULT_SCHEME = "camel";
    public static final String JAVA_TYPE_SCHEME = "java";
    public static final String ANY_TYPE_URN = "camel:any";
    public static final DataType ANY = new DataType("camel:any");
    private final String scheme;
    private String name;
    private boolean isJavaType;
    private String typeString;

    public DataType(String urn) {
        if (urn != null) {
            String[] split = StringHelper.splitOnCharacter((String)urn, (String)":", (int)2);
            this.scheme = split[0];
            this.isJavaType = this.scheme.equals(JAVA_TYPE_SCHEME);
            if (split.length > 1) {
                this.name = split[1];
            }
        } else {
            this.scheme = DataType.ANY.scheme;
            this.name = DataType.ANY.name;
        }
    }

    public DataType(Class<?> clazz) {
        this.scheme = JAVA_TYPE_SCHEME;
        this.isJavaType = true;
        this.name = clazz.getName();
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getName() {
        return this.name;
    }

    public String getFullName() {
        return this.name != null && !this.name.isEmpty() ? this.scheme + ":" + this.name : this.scheme;
    }

    public boolean isJavaType() {
        return this.isJavaType;
    }

    public String toString() {
        if (this.typeString == null) {
            this.typeString = this.getFullName();
        }
        return this.typeString;
    }

    public static boolean isAnyType(DataType dataType) {
        return dataType == null || ANY.equals(dataType);
    }

    public static boolean isJavaType(DataType dataType) {
        return dataType != null && dataType.isJavaType();
    }

    public boolean equals(Object target) {
        if (target instanceof DataType) {
            DataType targetDt = (DataType)target;
            String targetScheme = targetDt.getScheme();
            String targetName = targetDt.getName();
            if (targetScheme == null) {
                return false;
            }
            if (targetName == null) {
                return targetScheme.equals(this.getScheme()) && this.getName() == null;
            }
            return targetScheme.equals(this.getScheme()) && targetName.equals(this.getName());
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }
}

