% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mab_impute.R
\name{imputation_preparation}
\alias{imputation_preparation}
\title{Outcome Imputation Preparation}
\usage{
imputation_preparation(
  current_data,
  block_cols,
  imputation_information,
  whole_experiment,
  blocking,
  perfect_assignment,
  current_period
)
}
\arguments{
\item{current_data}{A tibble/data.table with only observations from the current sampling period.}

\item{block_cols}{A character vector of variables to block by. This vector should not be named.}

\item{imputation_information}{Object created by \code{\link[=imputation_precompute]{imputation_precompute()}} containing the conditional means and success dates
for each treatment block to impute from.}

\item{whole_experiment}{Logical; if TRUE, uses all past experimental data for imputing outcomes.
If FALSE, uses only data available up to the current period. In large datasets or with a high number
of periods, setting this to FALSE can be more computationally intensive, though not a significant
contributor to total run time.}

\item{blocking}{Logical; whether or not to use treatment blocking. Treatment blocking is used to ensure an even-enough
distribution of treatment conditions across blocks. For example, blocking by gender would mean the randomized assignment should
split treatments evenly not just throughout the sample (so for 4 arms, 25-25-25-25), but also within each block, so 25\% of men
would receive each treatment and 25\% of women the same.}

\item{perfect_assignment}{Logical; if TRUE, assumes perfect information for treatment assignment
(i.e., all outcomes are observed regardless of the date).
If FALSE, hides outcomes not yet theoretically observed, based
on the dates treatments would have been assigned for each wave.
This is useful when simulating batch-based assignment where treatments were assigned
on a given day whether or not all the information from a prior batch was available and
you have exact dates treatments were assigned.}

\item{current_period}{Numeric value of length 1; current treatment wave of the simulation.}
}
\value{
A named list containing:
\itemize{
\item \code{current_data}: A tibble/data.table containing \code{impute_block} column to guide the outcome imputations
\item \code{impute_success}: A tibble/data.table object containing probabilities of success by \code{treatment_block} used to impute
outcomes. Subsetted from the \code{\link[=imputation_precompute]{imputation_precompute()}} output.
\item \code{impute_dates}: Named date vector by treatment condition, containing the dates of success
to impute if perfect_assignment is FALSE. Subsetted from the \code{\link[=imputation_precompute]{imputation_precompute()}} output.}
}
\description{
Executes all preparations necessary to impute outcomes for
each iteration of the simulation loop. Adds an additional column to the current data,
subsets necessary information from the \code{\link[=imputation_precompute]{imputation_precompute()}} output, and checks to ensure
compatibility with \code{\link[randomizr:block_ra]{randomizr::block_ra()}}.
}
\details{
The goal of this function is to set up the imputation procedure and prevent
errors from occurring. \code{\link[randomizr:block_ra]{randomizr::block_ra()}} does not see the names
of the probabilities passed per block, so the imputation information must be subsetted
to contain only the treatment blocks which exist in a given period.

These checks are not implemented in \code{tryCatch()} block because they have to happen
in every iteration.

\code{impute_block} is the observation's new treatment block, combining any
blocking variables with their new treatment assigned via the Multi-Arm-Bandit
procedure.
}
\keyword{internal}
