% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cca_pvar.R
\name{run_sparse_cca}
\alias{run_sparse_cca}
\title{Run Sparse CCA with PCA Preprocessing}
\usage{
run_sparse_cca(
  X_matrix,
  Y_matrix,
  n_components = 3L,
  variance_threshold = 0.9,
  min_pcs = 8L,
  max_pcs = 12L
)
}
\arguments{
\item{X_matrix}{Numeric matrix of direct prices.}

\item{Y_matrix}{Numeric matrix of production prices.}

\item{n_components}{Number of canonical components to extract. Default 3.}

\item{variance_threshold}{Cumulative variance threshold for PCA. Default 0.90.}

\item{min_pcs}{Minimum number of PCs to retain. Default 8.}

\item{max_pcs}{Maximum number of PCs to retain. Default 12.}
}
\value{
A list containing:
\describe{
  \item{method}{Method used for CCA}
  \item{correlations}{Canonical correlations}
  \item{U_loadings}{X loadings in PC space}
  \item{V_loadings}{Y loadings in PC space}
  \item{W_X_original}{X loadings projected to original variables}
  \item{W_Y_original}{Y loadings projected to original variables}
  \item{n_pcs_x}{Number of PCs used for X}
  \item{n_pcs_y}{Number of PCs used for Y}
}
}
\description{
Performs canonical correlation analysis on PCA-reduced price matrices,
with optional sparsity penalties.
}
\details{
The function first reduces dimensionality using PCA, then applies CCA.
Falls back to base R cancor if specialized packages unavailable.
}
\examples{
set.seed(123)
n <- 50
p <- 20
X <- matrix(rnorm(n * p), n, p)
Y <- X \%*\% matrix(rnorm(p * 5), p, 5) + matrix(rnorm(n * 5, 0, 0.5), n, 5)
colnames(X) <- paste0("X", 1:p)
colnames(Y) <- paste0("Y", 1:5)

result <- run_sparse_cca(X, Y, n_components = 2)
print(result$correlations)

}
