% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tseffects.R
\name{GDTE.adl.plot}
\alias{GDTE.adl.plot}
\title{Evaluate (and possibly plot) the General Dynamic Treatment Effect (GDTE) for an autoregressive distributed lag (ADL) model}
\usage{
GDTE.adl.plot(
  model = NULL,
  x.vrbl = NULL,
  y.vrbl = NULL,
  d.x = NULL,
  d.y = NULL,
  te.type = "pte",
  inferences.y = "levels",
  inferences.x = "levels",
  dM.level = 0.95,
  s.limit = 20,
  se.type = "const",
  return.data = FALSE,
  return.plot = TRUE,
  return.formulae = FALSE,
  ...
)
}
\arguments{
\item{model}{the \code{lm} model containing the ADL estimates}

\item{x.vrbl}{a named vector of the x variables and corresponding lag orders in the ADL model}

\item{y.vrbl}{a named vector of the (lagged) y variables and corresponding lag orders in the ADL model}

\item{d.x}{the order of differencing of the x variable in the ADL model}

\item{d.y}{the order of differencing of the y variable in the ADL model}

\item{te.type}{the desired treatment history. \code{te.type} determines the counterfactual series (h) that will be applied to the independent variable. -1 represents a Pulse Treatment Effect (PTE). 0 represents a Step Treatment Effect (STE). These can also be specified via \code{pte}, \code{pulse}, \code{ste}, and \code{step}. For others, see Vande Kamp, Jordan, and Rajan. The default is \code{pte}}

\item{inferences.y}{does the user want resulting inferences about the dependent variable in levels or in differences? (For y variables where \code{d.y} is 0, this is automatically levels.) The default is \code{levels}}

\item{inferences.x}{does the user want to apply the counterfactual treatment to the independent variable in levels or in differences? (For x variables where \code{d.x} is 0, this is automatically levels.) The default is \code{levels}}

\item{dM.level}{level of significance of the GDTE, calculated by the delta method. The default is 0.95}

\item{s.limit}{an integer for the number of periods to determine the GDTE (beginning at s = 0)}

\item{se.type}{the type of standard error to extract from the ADL model. The default is \code{const}, but any argument to \code{vcovHC} from the \code{sandwich} package is accepted}

\item{return.data}{return the raw calculated GDTEs as a list element under \code{estimates}. The default is \code{FALSE}}

\item{return.plot}{return the visualized GDTEs as a list element under \code{plot}. The default is \code{TRUE}}

\item{return.formulae}{return the formulae for the GDTEs as a list element under \code{formulae} (for the GDTEs) and \code{binomials} (for the treatment history). The default is \code{FALSE}}

\item{...}{other arguments to be passed to the call to plot}
}
\value{
depending on \code{return.data}, \code{return.plot}, and \code{return.formulae}, a list of elements relating to the GDTE
}
\description{
Evaluate (and possibly plot) the General Dynamic Treatment Effect (GDTE) for an autoregressive distributed lag (ADL) model
}
\details{
We assume that the ADL model estimated is well specified, free of residual autocorrelation, balanced, and meets other standard time-series qualities. Given that, to obtain causal inferences for the specified treatment history, the user only needs a named vector of the x and y variables, as well as the order of the differencing
}
\examples{
# ADL(1,1)
# Use the toy data to run an ADL. No argument is made this is well specified; it is just expository 
model <- lm(y ~ l_1_y + x + l_1_x, data = toy.ts.interaction.data)
test.pulse <- GDTE.adl.plot(model = model,
                                  x.vrbl = c("x" = 0, "l_1_x" = 1), 
                                  y.vrbl = c("l_1_y" = 1),
                                  d.x = 0, 
                                  d.y = 0,
                                  te.type = "pulse", 
                                  inferences.y = "levels", 
                                  inferences.x = "levels",
                                  s.limit = 20, 
                                  return.plot = TRUE, 
                                  return.formulae = TRUE)
names(test.pulse)

# Using Cavari's (2019) approval model (without interactions)
# Cavari's original model: APPROVE ~ APPROVE_ECONOMY + APPROVE_FOREIGN + 
#     APPROVE_L1 + PARTY_IN + PARTY_OUT + UNRATE + 
#	     MIP_MACROECONOMICS + MIP_FOREIGN + 
#     DIVIDEDGOV + ELECTION + HONEYMOON + as.factor(PRESIDENT)

cavari.model <- lm(APPROVE ~ APPROVE_ECONOMY + APPROVE_FOREIGN + MIP_MACROECONOMICS + MIP_FOREIGN +
     APPROVE_L1 + PARTY_IN + PARTY_OUT + UNRATE + 
     DIVIDEDGOV + ELECTION + HONEYMOON + as.factor(PRESIDENT), data = approval)

# What if there was a permanent, one-unit change in the salience of foreign affairs?
cavari.step <- GDTE.adl.plot(model = cavari.model,
                                  x.vrbl = c("MIP_FOREIGN" = 0), 
                                  y.vrbl = c("APPROVE_L1" = 1),
                                  d.x = 0,
                                  d.y = 0,
                                  te.type = "ste", 
                                  inferences.y = "levels", 
                                  inferences.x = "levels",
                                  s.limit = 10, 
                                  return.plot = TRUE, 
                                  return.formulae = TRUE)
}
\author{
Soren Jordan, Garrett N. Vande Kamp, and Reshi Rajan
}
\keyword{ADL}
\keyword{plot}
