% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/viewer.R
\name{augmentedInfoPanel}
\alias{augmentedInfoPanel}
\alias{polarPlotPanel}
\alias{viewImages}
\title{A simple interactive viewer for MriImage objects}
\usage{
augmentedInfoPanel(indexNames = NULL)

polarPlotPanel(directions, bValues = NULL)

viewImages(images, colourScales = NULL, point = NULL, interactive = TRUE,
  crosshairs = TRUE, orientationLabels = TRUE,
  infoPanel = RNifti::defaultInfoPanel, ...)
}
\arguments{
\item{indexNames}{A list whose elements are either \code{NULL} or a named
character vector giving the names associated with each index in the image.}

\item{directions}{A matrix of 3D acquisition direction vectors, one per row.}

\item{bValues}{A vector of b-values, if the image is diffusion-weighted.}

\item{images}{An \code{MriImage} object, or list of \code{MriImage} objects.}

\item{colourScales}{A list of colour scales to use for each image, which
will be recycled to the length of \code{images}. See
\code{\link{getColourScale}} for details. The default is to use greyscale.}

\item{point}{A length-3 integer vector giving the initial location of the
crosshairs, in voxels.}

\item{interactive}{A single logical value. If \code{TRUE}, the plot is
interactive.}

\item{crosshairs}{A single logical value. If \code{TRUE}, the crosshairs are
displayed.}

\item{orientationLabels}{A single logical value. If \code{TRUE}, orientation
labels are displayed.}

\item{infoPanel}{A function with at least three arguments, which must plot
something to fill the bottom-right panel of the viewer after each change
of crosshair location. The three mandatory arguments correspond to the
current location in the image, the image values at that location, and the
names of each image. The \code{defaultInfoPanel} and
\code{timeSeriesPanel} functions from package \code{RNifti} are valid
examples.}

\item{\dots}{Additional arguments to \code{infoPanel}.}
}
\value{
These functions are called for their side effects.
}
\description{
The \code{viewImages} function provides a simple interactive viewer for
\code{MriImage} objects. 3D and 4D images may be used.
}
\note{
The \code{defaultInfoPanel} and \code{timeSeriesPanel} functions are
  not intended to be called directly. They are simple examples of valid
  values for the \code{infoPanel} argument to \code{viewImages}.
}
\references{
Please cite the following reference when using TractoR in your
work:

J.D. Clayden, S. Muñoz Maniega, A.J. Storkey, M.D. King, M.E. Bastin & C.A.
Clark (2011). TractoR: Magnetic resonance imaging and tractography with R.
Journal of Statistical Software 44(8):1-18. \doi{10.18637/jss.v044.i08}.
}
\seealso{
\code{\link{getColourScale}}
}
\author{
Jon Clayden
}
