% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models-mobilenetv2.R
\name{model_mobilenet_v2}
\alias{model_mobilenet_v2}
\title{MobileNetV2 Model}
\usage{
model_mobilenet_v2(pretrained = FALSE, progress = TRUE, ...)
}
\arguments{
\item{pretrained}{(bool): If TRUE, returns a model pre-trained on ImageNet.}

\item{progress}{(bool): If TRUE, displays a progress bar of the download to
stderr.}

\item{...}{Other parameters passed to the model implementation.}
}
\description{
Constructs a MobileNetV2 architecture from
\href{https://arxiv.org/abs/1801.04381}{MobileNetV2: Inverted Residuals and Linear Bottlenecks}.
}
\seealso{
Other classification_model: 
\code{\link{model_alexnet}()},
\code{\link{model_convnext}},
\code{\link{model_efficientnet}},
\code{\link{model_efficientnet_v2}},
\code{\link{model_facenet}},
\code{\link{model_inception_v3}()},
\code{\link{model_maxvit}()},
\code{\link{model_mobilenet_v3}},
\code{\link{model_resnet}},
\code{\link{model_vgg}},
\code{\link{model_vit}}
}
\concept{classification_model}
