% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-namespace-docs.R,
%   R/gen-namespace-examples.R, R/gen-namespace.R
\name{torch_dstack}
\alias{torch_dstack}
\title{Dstack}
\usage{
torch_dstack(tensors)
}
\arguments{
\item{tensors}{(sequence of Tensors) sequence of tensors to concatenate}
}
\description{
Dstack
}
\section{dstack(tensors, *, out=None) -> Tensor }{


Stack tensors in sequence depthwise (along third axis).

This is equivalent to concatenation along the third axis after 1-D and 2-D
tensors have been reshaped by \code{\link[=torch_atleast_3d]{torch_atleast_3d()}}.
}

\examples{
if (torch_is_installed()) {

a <- torch_tensor(c(1, 2, 3))
b <- torch_tensor(c(4, 5, 6))
torch_dstack(list(a,b))
a <- torch_tensor(rbind(1,2,3))
b <- torch_tensor(rbind(4,5,6))
torch_dstack(list(a,b))
}
}
