% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-namespace-docs.R,
%   R/gen-namespace-examples.R, R/gen-namespace.R
\name{torch_atanh}
\alias{torch_atanh}
\title{Atanh}
\usage{
torch_atanh(self)
}
\arguments{
\item{self}{(Tensor) the input tensor.}
}
\description{
Atanh
}
\note{
The domain of the inverse hyperbolic tangent is \verb{(-1, 1)} and values outside this range
will be mapped to \code{NaN}, except for the values \code{1} and \code{-1} for which the output is
mapped to \verb{+/-INF} respectively.

\deqn{
    \mbox{out}_{i} = \tanh^{-1}(\mbox{input}_{i})
}
}
\section{atanh(input, *, out=None) -> Tensor }{


Returns a new tensor with the inverse hyperbolic tangent of the elements of \code{input}.
}

\examples{
if (torch_is_installed()) {

a = torch_randn(c(4))$uniform_(-1, 1)
a
torch_atanh(a)
}
}
