% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/patchwork.R
\docType{methods}
\name{wrap_heatmap}
\alias{wrap_heatmap}
\alias{wrap_heatmap,InputHeatmap-method}
\title{Wrap tidyHeatmap (ComplexHeatmap) in a patchwork-compliant patch}
\source{
[Mangiola and Papenfuss., 2020](https://joss.theoj.org/papers/10.21105/joss.02472)
}
\usage{
wrap_heatmap(
  panel = NULL,
  plot = NULL,
  full = NULL,
  clip = TRUE,
  ignore_tag = FALSE,
  padding = NULL
)

\S4method{wrap_heatmap}{InputHeatmap}(
  panel = NULL,
  plot = NULL,
  full = NULL,
  clip = TRUE,
  ignore_tag = FALSE,
  padding = NULL
)
}
\arguments{
\item{panel, plot, full}{A grob, ggplot, patchwork, formula, raster, or
nativeRaster object to add to the respective area.}

\item{clip}{Should the grobs be clipped if expanding outside its area}

\item{ignore_tag}{Should tags be ignored for this patch. This is relevant
when using automatic tagging of plots and the content of the patch does not
qualify for a tag.}

\item{padding}{A grid::unit object. It defined the padding distance for the plot. It is helpful when the heatmap is assembled with other ggplots through patchwork.}
}
\value{
A wrapped_patch object

A wrapped_patch object
}
\description{
In order to add tidyHeatmap (ComplexHeatmap) element to a patchwork they can be
converted to a compliant representation using the `wrap_heatmap()` function.
This allows you to position either grobs, ggplot objects, patchwork
objects, or even base graphics (if passed as a formula) in either the full
area, the full plotting area (anything between and
including the axis label), or the panel area (only the actual area where data
is drawn).
}
\examples{


tidyHeatmap::N52 |>
tidyHeatmap::heatmap(
 .row = symbol_ct,
 .column = UBR,
 .value = `read count normalised log`,
) |> 
wrap_heatmap()
}
\references{
Mangiola, S. and Papenfuss, A.T., 2020. "tidyHeatmap: an R package for 
  modular heatmap production based on tidy principles." Journal of Open Source Software.
  doi:10.21105/joss.02472.
}
