% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stk_map.R
\name{stk_map}
\alias{stk_map}
\title{Plot skytrackr results}
\usage{
stk_map(
  df,
  bbox,
  start_location,
  roi,
  dynamic = FALSE,
  intervals = FALSE,
  simplify = FALSE
)
}
\arguments{
\item{df}{A data frame with locations produced with the skytrackr() function}

\item{bbox}{A geographic bounding box provided as a vector with the format
xmin, ymin, xmax, ymax.}

\item{start_location}{A start location as lat/lon to indicate
the starting position of the track (optional)}

\item{roi}{A region of interest under consideration, only used in
plots during optimization}

\item{dynamic}{Option to create a dynamic interactive graph rather than
a static plot. Both the path as the locations are shown. The size
of the points is proportional to the latitudinal uncertainty, while
equinox windows are marked with red points. (default = FALSE)}

\item{intervals}{show the uncertainty intervals as shaded
ellipses (default = FALSE)}

\item{simplify}{simplify the plot and only show the map (default = FALSE)}
}
\value{
A ggplot map of tracked locations or mapview dynamic overview.
}
\description{
Create a map of estimated locations as a static or dynamic map.
}
\examples{
\donttest{

# define land mask with a bounding box
# and an off-shore buffer (in km), in addition
# you can specify the resolution of the resulting raster
mask <- stk_mask(
  bbox  =  c(-20, -40, 60, 60), #xmin, ymin, xmax, ymax
  buffer = 150, # in km
  resolution = 0.5 # map grid in degrees
  )

# define a step selection distribution/function
ssf <- function(x, shape = 0.9, scale = 100, tolerance = 1500){
  norm <- sum(stats::dgamma(1:tolerance, shape = shape, scale = scale))
  prob <- stats::dgamma(x, shape = shape, scale = scale) / norm
}

# estimate locations
locations <- cc876 |> skytrackr(
  plot = TRUE,
  mask = mask,
  step_selection = ssf,
  start_location = c(50, 4),
      control = list(
        sampler = 'DEzs',
        settings = list(
        iterations = 10, # change iterations
         message = FALSE
        )
      )
  )

#----- actual plotting routines ----
# static plot, with required bounding box
locations |> stk_map()
}
}
