% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{observation_impute_cpp}
\alias{observation_impute_cpp}
\title{Get imputed data}
\usage{
observation_impute_cpp(index_xtrain, index_s, x_train, x_explain, S)
}
\arguments{
\item{index_xtrain}{Positive integer. Represents a sequence of row indices from \code{x_train},
i.e. \code{min(index_xtrain) >= 1} and \code{max(index_xtrain) <= nrow(x_train)}.}

\item{index_s}{Positive integer. Represents a sequence of row indices from \code{S},
i.e. \code{min(index_s) >= 1} and \code{max(index_s) <= nrow(S)}.}

\item{x_train}{Matrix.
Contains the training data.}

\item{x_explain}{Matrix with 1 row.
Contains the features of the observation for a single prediction.}

\item{S}{arma::mat.
Matrix of dimension (\code{n_coalitions}, \code{n_features}) containing binary representations of the used coalitions.
S cannot contain the empty or grand coalition, i.e., a row containing only zeros or ones.
This is not a problem internally in shapr as the empty and grand coalitions are treated differently.}
}
\value{
Numeric matrix
}
\description{
Get imputed data
}
\details{
\code{S(i, j) = 1} if and only if feature \code{j} is present in feature
combination \code{i}, otherwise \code{S(i, j) = 0}. I.e. if \code{m = 3}, there
are \code{2^3 = 8} unique ways to combine the features. In this case \code{dim(S) = c(8, 3)}.
Let's call the features \code{x1, x2, x3} and take a closer look at the combination
represented by \code{s = c(x1, x2)}. If this combination is represented by the second row,
the following is true: \code{S[2, 1:3] = c(1, 1, 0)}.

The returned object, \code{X}, is a numeric matrix where
\code{dim(X) = c(length(index_xtrain), ncol(x_train))}. If feature \code{j} is present in
the k-th observation, that is \code{S[index_[k], j] == 1}, \code{X[k, j] = x_explain[1, j]}.
Otherwise \code{X[k, j] = x_train[index_xtrain[k], j]}.
}
\author{
Nikolai Sellereite
}
\keyword{internal}
