% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.roclearn.R
\name{summary.roclearn}
\alias{summary.roclearn}
\title{Summarize a fitted linear model}
\usage{
\method{summary}{roclearn}(object, ...)
}
\arguments{
\item{object}{A fitted model of class \code{"roclearn"}.}

\item{...}{Unused.}
}
\value{
Invisibly returns \code{object} after printing a formatted summary.
}
\description{
Display key information from a fitted \code{"roclearn"} object, including:
data dimensions, model specification, convergence status, training time,
and leading coefficient estimates.
}
\examples{
set.seed(123)
n <- 100
n_pos <- round(0.2 * n)
n_neg <- n - n_pos
X <- rbind(
  matrix(rnorm(2 * n_neg, mean = -1), ncol = 2),
  matrix(rnorm(2 * n_pos, mean =  1), ncol = 2)
)
y <- c(rep(-1, n_neg), rep(1, n_pos))

fit <- roclearn(X, y, lambda = 0.1, approx=TRUE)
summary(fit)
}
\seealso{
\code{\link{roclearn}}, \code{\link{summary.kroclearn}},
\code{\link{cv.roclearn}}, \code{\link{cv.kroclearn}}
}
